% FUNCTION [...] = gf_mdbrick_set(mdbrick MDB, [operation [, args]])
%
%   Modify a model brick object.
%   
%
%   * gf_mdbrick_set(mdbrick MDB, 'param', string name, {mesh_fem mf,V | V})
%   Change the value of a brick parameter.
%   
%   `name` is the name of the parameter. `V` should contain the
%   new parameter value (vector or float). If a mesh_fem is given,
%   `V` should hold the field values over that mesh_fem (i.e. its
%   last dimension should be gf_mesh_fem_get(mesh_fem MF, 'nbdof') or 1 for
%   constant field).
%
%   * gf_mdbrick_set(mdbrick MDB, 'penalization_epsilon', scalar eps)
%   Change the penalization coefficient of a constraint brick.
%   
%   This is only applicable to the bricks which inherit from the
%   constraint brick, such as the Dirichlet ones. And of course it
%   is not effective when the constraint is enforced via direct
%   elimination or via Lagrange multipliers. The default value of
%   `eps` is 1e-9.
%
%   * gf_mdbrick_set(mdbrick MDB, 'constraints', mat H, vec R)
%   Set the constraints imposed by a constraint brick.
%   
%   This is only applicable to the bricks which inherit from the
%   constraint brick, such as the Dirichlet ones. Imposes `H.U=R`.
%
%   * gf_mdbrick_set(mdbrick MDB, 'constraints_rhs', mat H, vec R)
%   Set the right hand side of the constraints imposed by a constraint brick.
%   
%   This is only applicable to the bricks which inherit from the
%   constraint brick, such as the Dirichlet ones.
%
%
function [varargout]=gf_mdbrick_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdbrick_set', varargin{:});
  else
    gf_matlab('mdbrick_set', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
