% FUNCTION [...] = gf_mdstate_get(mdstate MDS, [operation [, args]])
%
%   Get information from a model state object.
%   
%
%   * b = gf_mdstate_get(mdstate MDS, 'is_complex')
%   Return 0 is the model state is real, 1 if it is complex.
%
%   * T = gf_mdstate_get(mdstate MDS, 'tangent_matrix')
%   Return the tangent matrix stored in the model state.
%
%   * C = gf_mdstate_get(mdstate MDS, 'constraints_matrix')
%   Return the constraints matrix stored in the model state.
%
%   * A = gf_mdstate_get(mdstate MDS, 'reduced_tangent_matrix')
%   Return the reduced tangent matrix (i.e. the tangent matrix after
%   elimination of the constraints).
%
%   * gf_mdstate_get(mdstate MDS, 'constraints_nullspace')
%   Return the nullspace of the constraints matrix.
%
%   * gf_mdstate_get(mdstate MDS, 'state')
%   Return the vector of unknowns, which contains the solution after gf_mdbrick_get(mdbrick MDB, 'solve').
%
%   * gf_mdstate_get(mdstate MDS, 'residual')
%   Return the residual.
%
%   * gf_mdstate_get(mdstate MDS, 'reduced_residual')
%   Return the residual on the reduced system.
%
%   * gf_mdstate_get(mdstate MDS, 'unreduce', vec U)
%   Reinsert the constraint eliminated from the system.
%
%   * z = gf_mdstate_get(mdstate MDS, 'memsize')
%   Return the amount of memory (in bytes) used by the model state.
%
%   * s = gf_mdstate_get(mdstate MDS, 'char')
%   Output a (unique) string representation of the mdstate.
%   
%   This can be used to perform comparisons between two
%   different mdstate objects.
%   This function is to be completed.
%   
%
%   * gf_mdstate_get(mdstate MDS, 'display')
%   displays a short summary for a mdstate.
%
%
function [varargout]=gf_mdstate_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdstate_get', varargin{:});
  else
    gf_matlab('mdstate_get', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
