% FUNCTION [...] = gf_mesh_im([operation [, args]])
%
%   General constructor for mesh_im objects.
%
%   This object represent an integration method defined on a whole mesh (an
%   potentialy on its boundaries).
%   
%
%   * MIM = gf_mesh_im('load', string fname[, mesh m])
%   Load a mesh_im from a file.
%   
%   If the mesh `m` is not supplied (this kind of file does not store the
%   mesh), then it is read from the file and its descriptor is returned as
%   the second output argument.
%
%   * MIM = gf_mesh_im('from string', string s[, mesh m])
%   Create a mesh_im object from its string description.
%   
%   See also ``gf_mesh_im_get(mesh_im MI, 'char')``
%
%   * MIM = gf_mesh_im('clone', mesh_im mim)
%   Create a copy of a mesh_im.
%
%   * MIM = gf_mesh_im('levelset', mesh_levelset mls, string where, integ im[, integ im_tip[, integ im_set]])
%   Build an integration method conformal to a partition defined
%   implicitely by a levelset.
%   
%   The `where` argument define the domain of integration with respect to
%   the levelset, it has to be chosen among 'ALL', 'INSIDE', 'OUTSIDE' and
%   'BOUNDARY'.
%
%   * MIM = gf_mesh_im(mesh m, [{integ im|int im_degree}])
%   Build a new mesh_im object.
%   
%   For convenience, optional arguments (`im` or `im_degree`) can be
%   provided, in that case a call to ``gf_mesh_im_get(mesh_im MI, 'integ')`` is issued
%   with these arguments.
%
%
function [varargout]=gf_mesh_im(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_im', varargin{:});
  else
    gf_matlab('mesh_im', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
