#!/usr/bin/perl -w  # -*- cperl -*- #
#
#  bug.pm   - Allow users to make bug reports.
#
#  GNU MP3D - A portable(ish) MP3 server.
#
# Homepage:
#   http://www.gnump3d.org/
#
# Author:
#  Steve Kemp <steve@steve.org.uk>
#
# Version:
#  $Id: bug.pm,v 1.7 2005/12/03 17:56:36 skx Exp $
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  Steve Kemp
#  ---
#  http://www.steve.org.uk/
#
#



#
#  The package this module is implementing.
#
package plugins::bug;


#
#  Register the plugin.
#
::register_plugin("plugins::bug");


#
#  Minimal constructor.
#
sub new { return bless {}; }



use English;


#
#  Return the author of this plugin.
#
sub getAuthor
{
    return( 'Steve Kemp <steve@steve.org.uk>' );
}


#
#  Return the version of this plugin.
#
sub getVersion
{
    my $REVISION      = '$Id: bug.pm,v 1.7 2005/12/03 17:56:36 skx Exp $';
    my $VERSION       = "";
    $VERSION = join (' ', (split (' ', $REVISION))[1..2]);
    $VERSION =~ s/,v\b//;
    $VERSION =~ s/(\S+)$/($1)/;

    return( $VERSION );
}


#
# Will this plugin handle the given URI path?
#
sub wantsPath
{
    my ( $class, $path ) = ( @_ );

    if ( $path =~ /^\/bug\/*/i )
    {
	return 1;
    }

    return 0;
}


#
#  Handle requests to this plugin.
#
sub handlePath
{
package main;
    my ($class, $uri ) = shift;
 
    my $header   = &getHTTPHeader( 200, "text/html" );
    sendData( $data, $header );

    my $text = $class->_getBugsForm( $ARGUMENTS{"theme"});
    &sendData( $data, $text );

    close( $data );
    exit;
}



#
#  Read and return the bug reporting form to the caller.
sub _getBugsForm
{
    my ($class, $theme) = ( @_ );

package main;

    my $text    = "";

    my @template = &getThemeFile( $theme, "bug.html" );

    foreach my $line (@template )
    {
	#
	# Make global substitutions.
	#
        $line =~ s/\$HEADER//g;
	$line =~ s/\$HOSTNAME/$host/g;
	$line =~ s/\$VERSION/$VERSION/g;
	$line =~ s/\$RELEASE/$RELEASE/g;
	$line =~ s/\$DIRECTORY/\/bug\//g;
	$line =~ s/\$META/$meta_tags/g;

	#
	# Now handle the special sections.
	#
	if ( $line =~ /(.*)\$BANNER(.*)/ )
	{
	    # Insert banner;
	    my $pre  = $1;
	    my $post = $2;

	    $text .= $pre;
	    $text .= &getBanner( "/bug/" );
	    $text .= $post;
	}
	elsif ( $line =~ /(.*)\$BUG_REPORT_URL(.*)/ )
	{
	    my $BUG_REPORT_URL =  "http://www.steve.org.uk/cgi-bin/gnump3dbug/report.cgi";

	    $text .= $1;
	    $text .= $BUG_REPORT_URL;
	    $text .= $2;
	}
	elsif ( $line =~ /(.*)\$connected_address(.*)/ )
	{
	    my $pre  = $1;
	    my $post = $2;

	    $text .= $pre;
	    $text .= $connected_address;
	    $text .= $post;
	}
	elsif ( $line =~ /(.*)\$USER_AGENT(.*)/ )
	{
	    my $pre  = $1;
	    my $post = $2;

	    $text .= $pre;
	    $text .= $USER_AGENT;
	    $text .= $post;
	}
	elsif ( $line =~ /(.*)\$OSNAME(.*)/ )
	{
	    my $pre  = $1;
	    my $post = $2;

	    $text .= $pre;
	    $text .= $OSNAME;
	    $text .= $post;
	}
	elsif ( $line =~ /(.*)\$host(.*)/ )
	{
	    my $pre  = $1;
	    my $post = $2;

	    $text .= $pre;
	    $text .= $host;
	    $text .= $post;
	}
	elsif ( $line =~ /(.*)\$\](.*)/ )
	{
	    my $pre  = $1;
	    my $post = $2;

	    $text .= $pre;
	    $text .= $];
	    $text .= $post;
	}
	elsif ( $line =~ /(.*)\$REQUEST(.*)/ )
	{
	    my $pre  = $1;
	    my $post = $2;

	    $text .= $pre;
	    $text .= $REQUEST;
	    $text .= $post;
	}
	elsif ( $line =~ /(.*)\$BUG_CONFIG(.*)/ )
	{
	    my $pre  = $1;
	    my $post = $2;

	    $text .= $pre;

	    #
	    # My bug reporting CGI script.
	    #
	    my %CONFIG_HASH = &gnump3d::config::getHash();
	    my $BUG_CONFIG  = "";

	    # Build up a string containing the server's configuration options.
	    foreach my $key ( sort ( keys( %CONFIG_HASH ) ) )
	    {
		$BUG_CONFIG .= $key . " = '" . $CONFIG_HASH{$key} . "'\n";
	    }

	    $text .= $BUG_CONFIG;
	    $text .= $post;
	    $SIG{CHLD} = "IGNORE";
	}
	else
	{
	    $text .= $line;
	}
    }

    return( $text );
}



1;
