<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


if (empty($_REQUEST['user_id'])) {
	header("Location: sn_list.php");
	exit;
}

include "inc/header_sn.inc.php";

//ACS check
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['network'], $c_acs['arr_acs']['privilege']['allow_profile'])) { //resourece_id, Priv_id
	//append language setup
	require_once($languageArrayPath . 'arr_rsp.lang.php');
	
	
	//setup Wiki
	require_once('class/Wiki/Wiki.php');
	$wiki =& new Text_Wiki();
	$wiki->disableRule('freelink');
	$wiki->disableRule('wikilink');
	$wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=');
	
	
	// SETUP TAGS
	require_once('class/Tag.class.php');
	$tag = new Tag($db, $c_node['rsp']['item_type']['network']);
	$tag->user_id = $me['user_id'];


	if (isset($_POST['update_tag'])) {
		$frmdata['item_id'] = $frmdata['user_id'];
		$tag->deleteTags($frmdata);
		$tag->insertTags($frmdata);
	}	
	else
	//block or unblock user
	if (isset($_REQUEST['block'])) {
		$display = "block";
	}
	elseif (isset($_REQUEST['unblock'])) {
		$sn->user_id = $me['user_id'];
		$user_blocked = $sn->unSetBlockUser($_REQUEST['user_id'], 'unblock');
	}
	elseif (isset($_POST['set_block'])) {
		$sn->user_id = $me['user_id'];
		$user_blocked = $sn->setBlockUser($frmdata['user_id'], $frmdata['block_description']);
		
	
		//refresh this page to show new status
		header("Location: sn_profile.php?user_id=" . $_POST['user_id']."&". strip_tags(SID));
		exit;
	}
	elseif (isset($_POST['invite_relation'])) {
		//get text file
		$body_im_file = readTxtFile($languageTextPath . "im_invite.txt.php");
		$body_file_im_txt = str_replace("NAME", $frmdata['invite_message'], $body_im_file);
		
		// add a br_relation record with a level of "approval_pending"
		$sn->user_id = $me['user_id'];
		
		if ($sn->insertRelation($frmdata['user_id'], $c_node['user']['relation_type']['approval_pending'])) {
			//send IM
			$im->sendMessage($frmdata['user_id'], $lang["subject_im_invite"], $body_file_im_txt, 1);
		}
					
		if (!empty($GLOBALS['am_error_log'])) {
			$output_message = $frmdata;
		}
	}
	elseif (isset($_POST['delete_relation'])) {
		$sn->user_id = $me['user_id'];
		$sn->deleteRelation($frmdata['user_id']);
		
		unset($output_profile['relation_to']);
		
		$_SESSION['relations'] = $sn->selRelations($me['user_id']);
	}
	elseif (isset($_POST['update_relation'])) {
		$sn->user_id = $me['user_id'];
		$sn->updateRelation($frmdata);
		
		$relation_to = $sn->selRelation($me['user_id'], $output_user['user_id']);
		
		if (!empty($relation_to)) {
			$output_profile['relation_to'] = $relation_to;
		}
	}
	else {
		if ($sn->getBlockStatus($output_user['user_id'])) {
			$display = "blocked";
		}
	}


	// format profile
	$output_profile['profile_summary'] = $wiki->transform($output_profile['profile_summary'], 'Xhtml');
	
	
	// are we blocking this person?
	if ($sn->getBlockStatus($_REQUEST['user_id'])) {
		$display = "blocked";
	}

	// Is this a pending relationship?
	$output_profile['relation_to_pending'] = $sn->selRelation($me['user_id'], $output_user['user_id'], $c_node['user']['relation_type']['approval_pending']);
	
	//get tags
	$tag->item_id = $output_profile['user_id'];
	$output_my_tags = $tag->selTags();
	
	
	//setup file
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	
	
	require_once('class/Forum.class.php');
	$forum = new Forum($db, null, $file);
	$forum->limit = 5;
	$forum->user_id = $output_user['user_id'];
	$output_subjects = $forum->selSubjects();


	require_once('class/Library.class.php');
	$library = new Library($db, null, $file);
	$library->user_id = $output_user['user_id'];
	$library->limit = 5;
	$output_library = $library->selLibraryItems();
	
	
	require_once('class/Blog.class.php');
	$blog = new Blog($db, null, $file);
	$blog->user_id = $output_user['user_id'];
	$blog->limit = 5;
	$output_blogs = $blog->selBlogs();
	
	
	require_once('class/Statistic.class.php');
	$statistic = new Statistic($db);
	$statistic->user_id = $output_user['user_id'];
	$output_statistics = $statistic->getStatistics();
	
	
	require_once('class/Comment.class.php');
	$comment = new Comment($db, $c_node['rsp']['item_type']['blog'], $date);
	$comment->user_id = $output_user['user_id'];
	$comment->limit = 10;
	$output_comments = $comment->selComments();
	

	//get the relationships
	$sn->createNetwork($me['user_id']);
	$output_relationship_paths = $sn->getDegreePaths($output_user['user_id']);

	
	if (!empty($output_relationship_paths)) {
		foreach($output_relationship_paths as $key => $r):
			foreach($r['relation'] as $key => $i):
				$user->user_ids[] = $i;
			endforeach;
		endforeach;
		
		$output_relationship_profiles = $user->selProfiles();
	}
	
	//get their relationships
	$output_relationship_relations = $sn->selRelations($output_user['user_id']);
	
	unset($user->user_ids);
	
	if (!empty($output_relationship_relations)) {
		foreach($output_relationship_relations as $key => $i):
			$user->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		$output_relationship_relations_profiles = $user->selProfiles();
	}
}
else {
	$display = "deny";
}


//move to template
if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

if (!empty($output_relationship_paths)) {
	$body->set('relationship_paths', $output_relationship_paths);
}

if (!empty($output_relationship_relations)) {
	$body->set('relationship_relations', $output_relationship_relations);
}

if (!empty($output_relationship_profiles)) {
	$body->set('relationship_profiles', $output_relationship_profiles);
}

if (!empty($output_relationship_relations_profiles)) {
	$body->set('relationship_relations_profiles', $output_relationship_relations_profiles);
}

if (!empty($output_statistics)) {
	$body->set('statistics', $output_statistics);
}

if (!empty($user_blocked)) {
	$body->set('user_blocked', $user_blocked);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

$body->set('rsp_item_type_ids', $c_node['rsp']['item_type']);

$template_pageLink =  $lang['txt_profile'];
$template_pageLinkNote = $lang['txt_profile'] . ": " . $output_profile['profile_nic'];

include "inc/footer.inc.php";

?>
