<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


//ACS check
if (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['forum'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


require_once($languageArrayPath . 'arr_acs.lang.php');


// SETUP FORUM ---------------------------------------------------------
require_once('class/Forum.class.php');
$forum = new Forum($db, null, $file);

if (isset($_REQUEST['topic_id'])) {
	$forum->topic_id = $_REQUEST['topic_id'];
}

if (isset($_REQUEST['subject_id'])) {
	$forum->subject_id = $_REQUEST['subject_id'];
}


//SETUP RSP ---------------------------------------------------------
require_once('class/Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['forum']);
$rsp->user_id = $me['user_id'];


// SETUP WIKI ---------------------------------------------------------------
$wiki_path = "lib_view.php?user_id=" . $me['user_id'] . "&page=";
$wiki_new_path = "lib_edit.php?page=";
$wiki_image_base = "get_file.php?file=";

require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);


// SETUP BOOKMARKS ---------------------------------------------------------
require_once('class/Bookmark.class.php');
$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['forum'], $me['user_id']);
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];


//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (!empty($frmdata)) {
	$frmdata['subject_synopsis'] = htmlspecialchars($frmdata['subject_synopsis']);
	$frmdata['subject_title'] = htmlspecialchars($frmdata['subject_title']);
	
	if (isset($frmdata['preview'])) {
		$frmdata['subject_body'] = stripslashes($frmdata['subject_body']);
		$frmdata['subject_synopsis'] = stripslashes($frmdata['subject_synopsis']);
		$frmdata['subject_title'] = stripslashes($frmdata['subject_title']);
		$frmdata['subject_body_preview'] = $wiki->transform($frmdata['subject_body'], 'Xhtml');

		if (!empty($frmdata['rsp_node'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['node'], 'degree_id' => $frmdata['rsp_degree'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		if (!empty($frmdata['rsp_public'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['public'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		$output_subject = $frmdata;
		
		$display = "edit_subject";
	}
	elseif (isset($frmdata['save_subject']) || isset($frmdata['save_go_subject'])) {
		
		if (empty($frmdata['subject_title'])) {
		    $GLOBALS['igloo_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['igloo_error_log'])) {
			//
			$forum->user_id = $me['user_id'];
			
			if (isset($frmdata['subject_id']) && $frmdata['subject_id'] > 0) {
		         //we update the event
		 		$forum->updateSubject($frmdata);
			}
		 	else { //we insert record
		 		$forum->user_id = $me['user_id'];
		 		$forum->insertSubject($frmdata);
		 	}
			
			if (empty($GLOBALS['igloo_error_log'])) {
				//insert into setup rsp
				$temp['language_id'] = $me['language_id'];
				
				$temp['item_id'] = $forum->subject_id;
				//delete all
				$rsp->deleteRspItem($forum->subject_id);
				
				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					if (!empty($frmdata['rsp_node_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if ($frmdata['rsp_node'] == "all") {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_node'];
					}
					
					if($c_node['rsp']['node']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					
					if (!empty($frmdata['rsp_public_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if($c_node['rsp']['public']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				// add bookmark tracking
				$bookmark->item_id = $forum->subject_id;
				$bookmark->deleteBookmark();
				if (!empty($frmdata['ins_mark'])) {
					$bookmark->insertBookmark(1);
				}
				
				//setup statistics
				require_once('class/Statistic.class.php');
				$statistic = new Statistic($db, null, $date);
				
				//update stats
				$forum->user_id = $me['user_id'];
				$statistic->user_id = $me['user_id'];
				$statistic->section_item_id = $me['user_id'];
				$statistic->statistic_type_id = $c_node['statistic']['user']['total_forum_subjects'];
				
				$statistic->setStatistic($forum->getSubjectCount());
				
				if (isset($frmdata['save_go_subject'])) {
					header("Location: frm_view.php?subject_id=" . $forum->subject_id . "&". strip_tags(SID));
					exit;
				}
				else {
					header("Location: frm_edit.php?subject_id=" . $forum->subject_id . "&". strip_tags(SID));
					exit;
				}
			}
			else { // somehing errored
				$output_subject = $frmdata;
			}
			
			$display = "edit_subject";
		}
	}
	elseif (isset($frmdata['save_topic']) || isset($frmdata['save_go_topic'])) {
		
		if (empty($frmdata['topic_title'])) {
		    $GLOBALS['igloo_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['igloo_error_log'])) {
			//
			if (isset($frmdata['topic_id']) && $frmdata['topic_id'] > 0) {
		         //we update the event
		 		$forum->updateTopic($frmdata);
			}
		 	else { //we insert record
		 		$forum->user_id = $me['user_id'];
		 		$forum->insertTopic($frmdata);
		 	}
			
			if (empty($GLOBALS['igloo_error_log'])) {
				
				if (empty($frmdata['role_ids'])) {
					$frmdata['role_ids'] = array();
				}
				
				$forum->insertTopicRoles($frmdata['role_ids']);
				
				if (isset($frmdata['save_go_topic'])) {
					header("Location: frm_view.php?topic_id=" . $forum->topic_id . "&". strip_tags(SID));
					exit;
				}
				else {
					header("Location: frm_edit.php?topic_id=" . $forum->topic_id . "&". strip_tags(SID));
					exit;
				}
			}
			else { // somehing errored
				$output_topic = $frmdata;
			}
			
			$display = "edit_topic";
		}
	}
	elseif (isset($frmdata['delete_topic']) && isset($frmdata['topic_id'])) {
		//we can only delete a topic if no subjects are under it
		$forum->deleteTopic($frmdata['topic_id']);
	
	$display = "edit_topic";
	}
}
elseif (isset($_REQUEST['add_subject'])) {
	
	if (isset($_REQUEST['topic_id'])) {//we edit topic
		$output_topic['topic_id'] = $_REQUEST['topic_id'];
	}
	
	$display = "edit_subject";
}
elseif (isset($_REQUEST['topic_id'])) {//we edit topic
	$output_topic = $forum->selTopic();
	
	if (!empty($output_topic)) {
	    $output_topic['total_subjects'] = $forum->getSubjectCount();
	}
	
	//$output_roles = $group_acs->getGroupRoles();
	$output_topic_roles = $forum->SelTopicRoles();	
	
	$display = "edit_topic";
}
elseif (isset($_REQUEST['add_topic'])) {//we add topic
	
	$display = "edit_topic";
}
elseif (isset($_REQUEST['subject_id'])) {
	$output_subject = $forum->selSubject();
	
	$display = "edit_subject";
}
else { // add a subject
	$display = "edit_subject";
}


// SETUP LIBRARY ---------------------------------------------------------
require_once('class/Library.class.php');
$library = new Library($db, null);
$output_wikipages = $library->getPages();
$file->user_id = $me['user_id'];
$output_filenames = $file->getFiles();


$file->user_id = $me['user_id'];
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


// if we have edit permissions we list all topics, else we check for 
// the topics I can add to
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['forum'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
	$output_topics = $forum->selTopics();
}
else {
	//$output_topic_roles = $forum->SelTopicRoles($group_acs->role_id);
	
	if (!empty($output_topic_roles)) {
		$output_topic_role_ids = array();
		foreach($output_topic_roles as $key => $i):
			array_push($output_topic_role_ids, $i['topic_id']);
		endforeach;
		
		$forum->topic_ids = $output_topic_role_ids;
		$output_topics = $forum->getTopics();
	}
	else {
		header("Location: frm_view.php?". strip_tags(SID));
		exit;
	}
}

if (isset($output_subject)) {
	//get bookmark
	$bookmark->item_id = $output_subject['subject_id'];
	$output_blog['bookmark'] = $bookmark->getBookmark(1);
}

//RSP items
if (!empty($forum->subject_id)) {
	$output_subject['rsp'] = $rsp->selRspItem($forum->subject_id);
}

//move to template
if (!empty($subject->subject_id)) {
	$output_subject['rsp'] = $rsp->selRspItem($subject->subject_id);
}

//move vars to template
if (!empty($output_wikipages)) {
	$body->set('wikipages', $output_wikipages);
}

if (!empty($output_filenames)) {
	$body->set('filenames', $output_filenames);
}

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}

if (!empty($output_topic)) {
	$body->set('topic', $output_topic);
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
}

if (!empty($output_roles)) {
    $body->set('roles', $output_roles);
}

if (!empty($output_topic_roles)) {
    $body->set('topic_roles', $output_topic_roles);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
