<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


//ACS check
if (!isset($rss_access_granted) && (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['forum'], $c_acs['arr_acs']['privilege']['allow_access']))) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_acs.lang.php');


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['forum']);
$comment->wiki = $wiki;

if (isset($me['user_id'])) {
	$comment->user_id = $me['user_id'];
}


// SETUP FORUM -----------------------------------------------------------
require_once('class/Forum.class.php');
$forum = new Forum($db, null, null);
$forum->comment = $comment;
$forum->rsp_level_id = $rsp_level_id;

if (!empty($_REQUEST['topic_id'])) {
	$forum->topic_id = $_REQUEST['topic_id'];
}

if (isset($_REQUEST['subject_id'])) {
	$forum->subject_id = $_REQUEST['subject_id'];
}


// SETUP TAGS -----------------------------------------------------------
require_once('class/Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['forum']);

if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
}


// SETUP BOOKMARKS -------------------------------------------------------
if (isset($me['user_id'])) {
	require_once('class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['forum'], $me['user_id']);
}

// PROCESS FORM ----------------------------------------------------------
if (isset($_REQUEST['view']) && $_REQUEST['view'] == "node") {
	unset($_REQUEST['view']);
}

if (isset($_POST['update_tag'])) {
	$frmdata['item_id'] = $frmdata['subject_id'];
	$tag->deleteItemTags($frmdata);
	$tag->insertTags($frmdata);
	
	return header("Location: frm_view.php?subject_id=". $frmdata['subject_id'] . "&" . strip_tags(SID));
	exit;
}	
elseif (isset($_POST['preview'])) {
	unset($forum->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
	
	$forum->subject_id = $_REQUEST['subject_id'];
	
	$output_subject = $forum->selSubject();
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $frmdata['subject_id'];
	$comment->item_user_id = $frmdata['item_user_id'];
	$comment->insertComment($frmdata);
		
	if (empty($GLOBALS['igloo_error_log'])) {
		//setup statistics
		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db, $date);
		//update stats
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		unset($comment->item_id, $comment->rsp_item_type_id, $comment->section_id, $comment->section_item_id);
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());
		
		return header("Location: frm_view.php?subject_id=". $frmdata['subject_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	unset($forum->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
	$forum->subject_id = $_REQUEST['subject_id'];
	
	$output_subject = $forum->selSubject();
	
}
elseif (isset($_POST['delete_subject'])) {
	$forum->deleteSubject($forum->subject_id);
	
	return header("Location: frm_view.php?" . strip_tags(SID));
	exit;
}
elseif (isset($_REQUEST['bookmark']) && isset($me['user_id'])) { // bookmark options for this item
	$bookmark->item_id = $_REQUEST['subject_id'];
	
	if ($_REQUEST['bookmark'] == "ins_mark") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		
		if (!empty($_REQUEST['notify'])) {
			$bookmark->insertBookmark(1);
		}
		else {
			$bookmark->insertBookmark();
		}
	}
	elseif ($_REQUEST['bookmark'] == "del_mark") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->deleteBookmark();
	}
	elseif ($_REQUEST['bookmark'] == "ins_tip") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->insertBookmark();
	}
	elseif ($_REQUEST['bookmark'] == "del_tip") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->deleteBookmark();
	}
	
	header("Location: frm_view.php?subject_id=". $_REQUEST['subject_id'] . "&" . strip_tags(SID));
	exit;
}elseif (isset($_REQUEST['view'])) {
	if ($_REQUEST['view'] == "my_network" && isset($me['user_id'])) {
		//get the latest relations subjects
		unset($forum->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$forum->file = $file;
		
		$my_network = $_SESSION['relations'];
		
		if (!empty($my_network)) {
			foreach($my_network as $key => $i):
				$forum->user_ids[] = $i['user_id_relation'];
				$user->user_ids[] = $i['user_id_relation'];
			endforeach;
		}
		else {
			$forum->user_ids[] = 0;
			$user->user_ids[] = 0;
		}
		
		$user->file = $file;
		$output_users = $user->selUsers();
		
		$forum->limit = $c_node['display']['max_list_rows'];
		$network_subjects = $forum->selSubjects();
		
		//sort subjects under people
		if (!empty($output_users)) {
			foreach ($output_users as $item_key => $i):
				foreach($network_subjects as $content_key => $c):
					if ($i['user_id'] == $c['user_id']) {
						$output_users[$item_key]['subjects'][] = $c;
						unset ($network_subjects[$content_key]);
					}
				endforeach;
			endforeach;
		}
		
		$output_my_network_subjects = $output_users;
		
		$lang['txt_intro_network'] = str_replace('MAXLISTNUMBER', $c_node['display']['max_list_rows'], $lang['txt_intro_network']);
		$lang['txt_outro_network'] = str_replace('MAXLISTNUMBER', $c_node['display']['max_list_rows'], $lang['txt_outro_network']);
		
		$menu_section = "network";
	}
	elseif ($_REQUEST['view'] == "my_subject" && isset($me['user_id'])) {
		//get my subjects
		unset($forum->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$forum->file = $file;
		$forum->include_hidden=1;
		$forum->user_id = $me['user_id'];
		unset($forum->topic_id);
		
		$output_subjects = $forum->selSubjects();
		
		$menu_section = "my";
	}
	elseif ($_REQUEST['view'] == "marked_subjects" && isset($me['user_id'])) {
		//get my marked subjects
		unset($forum->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$forum->file = $file;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
		$watched_subject_ids = $bookmark->getBookmarks();
		
		$forum->user_id = $me['user_id'];
		
		if (!empty($watched_subject_ids)) {
			$forum->subject_ids = $watched_subject_ids;
			$output_subjects = $forum->selSubjects();
		}
	}
}
elseif (isset($_REQUEST['user_id'])) {
	//get subjects for this user (if relation)
	unset($forum->rsp_level_id);
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$forum->file = $file;
	
	$forum->user_id = $_REQUEST['user_id'];
	
	$output_subjects = $forum->selSubjects();
	
	// get the user
	$output_profile = $user->selProfile(null, $_REQUEST['user_id']);
	
	
	$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	//setup file
	if (isset($output_profile['file_id'])) {
		$file->file_id = $output_profile['file_id'];
		$output_profile['image'] = $file->getFileRecord();
	}
	if (isset($output_profile) && empty($output_profile['image'])) {
		$output_profile['image']['file_title'] = "";
		$output_profile['image']['file'] = $file->noimage;
	}
}
elseif (isset($_REQUEST['topic_id']) && $_REQUEST['topic_id'] > 0) {
    unset($forum->rsp_level_id);
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$forum->file = $file;
	
	$forum->topic = $_REQUEST['topic_id'];
	$output_topic = $forum->selTopic();
	
	if (!empty($output_topic['group_id'])) {
		$group_id = $output_topic['group_id'];
		include_once ('inc/header_group.inc.php');
		require_once($languagePath . 'grp_common.lang.php');
		$forum->group_id = $output_topic['group_id'];
	}
	
	$output_topic_roles = $forum->selTopicRoles();
	$output_subjects = $forum->selSubjects();
	$output_sidebar_topics = $forum->selTopics();
	
	//check to see if we can add a subject
	if (!empty($output_topic_roles)) {
		foreach($output_topic_roles as $key => $tr):
			if ($tr['role_id'] == $me['role_id']) {
				$output_topic['add_subject'] = 1;
				break;
			}
		endforeach;
	}
	
	unset($menu_section);
}
elseif (isset($_REQUEST['subject_id']) && $_REQUEST['subject_id'] > 0) {
	//get subject
	unset($forum->rsp_level_id);
	$output_subject = $forum->selSubject();
	
	$forum->topic_id = $output_subject['topic_id'];
	$output_topic = $forum->selTopic();
	
	$output_sidebar_topics = $forum->selTopics();
	
	unset($menu_section);
}
else { //overview
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$forum->file = $file;
	
	$forum->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
	$forum->rsp_status_id = $c_node['rsp']['status']['live'];
	
	unset($forum->topic_id);
	$forum->limit=10;
	$forum->order_by = "s.subject_create_datetime desc";
	$output_subjects = $forum->selSubjects();
	
	
	// get comments --------------------------------------------------------
	unset($comment->user_id);
	$comment->limit = 10;
	$comment->orderby = "c.comment_create_datetime desc";
	$output_comments = $comment->selComments();
	
	$lang['txt_intro_node'] = str_replace('MAXLISTNUMBER', $c_node['display']['max_list_rows'], $lang['txt_intro_node']);
	
	$menu_section = "magazine";
	$display = "latest";
	
	$lang['txt_intro'] = $lang['txt_intro_latest'];
	
	$output_sidebar_topics = $forum->selTopics();
	
	$_REQUEST['view'] = "node";
}


// CHECK PERMISSION TO VIEW SUBJECT ------------------------------------------
if (!empty($output_subject)) {
	// Are we allowed to see this subject?
	require_once($languageArrayPath . 'arr_rsp.lang.php');
	
	require_once('class/Rsp.class.php');
	$rsp = new Rsp($db, $c_node['rsp']['item_type']['forum']);
	$output_subject['rsp'] = $rsp->selRspItem($output_subject['subject_id']);
	
	if (!empty($output_subject['rsp'])) { // is the item set to public?
		foreach ($output_subject['rsp'] as $key => $i):
			if ($i['level_id'] == $c_node['rsp']['rsp_level']['public']) {
				$allow_view = 1;
				break;
			}
			elseif (!empty($_SESSION['s_md5']) && empty($i['degree_id']) && $i['level_id'] == $c_node['rsp']['rsp_level']['node']) { // is the item set to node and the user logged in?
				$allow_view = 1;
				break;
			}
			elseif (!empty($i['degree_id'])) { // is it set to network and are they in my network?
				foreach($_SESSION['relations'] as $key => $r):
					if ($output_blog['user_id'] == $r['user_id_relation']) {
						$allow_view = 1;
						break;
					}
					
					if (isset($allow_view)) {
						break;
					}
				endforeach;
			}
		endforeach;
	}
	elseif (isset($me['user_id']) && $me['user_id'] == $output_subject['user_id']) {
		// is the author me?
		$allow_view = 1;
	}
	
	if (!isset($allow_view)) {
		unset($output_subject);
	}
}


// FORMAT SUBJECT -------------------------------------------------------
if (isset($output_subject)) {
	$output_subject['display_subject_body'] = $wiki->transform($output_subject['subject_body'], 'Xhtml');
	
	// GET AUTHOR
	$output_author = $user->selProfile(null, $output_subject['user_id']);
	
	// GET BOOKMARK --------------------------------------------------
	if (isset($bookmark)) {
		$bookmark->item_id = $output_subject['subject_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_subject['bookmark']['watch'] = 1;
		}
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_subject['bookmark']['recommend'] = 1;
		}
	}
	
	//get comments
	unset($comment->user_id);
	$output_comments = $comment->selComments($forum->subject_id);
	
	
	//get subject image
	if (isset($output_subject['file_id'])) {
		$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		$file->file_id = $output_subject['file_id'];
		$output_subject['image'] = $file->getFileRecord();
	}
	
	
	//get tags
	$tag->item_id = $forum->subject_id;
	$output_my_tags = $tag->selTags();
	unset($tag->user_id);
	$output_item_tags = $tag->selTags(1);
}



// SETUP TEMPLATE ---------------------------------------------------------

if (!empty($_REQUEST['view'])) {
	$body->set('view', $_REQUEST['view']);
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
	$body->set('rsp_config', $c_node['rsp']);
}                                 

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);  
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);  
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_topic)) {
    $body->set('topic', $output_topic);
}

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}

if (!empty($output_sidebar_topics)) {
	$body->set('sidebar_topics', $output_sidebar_topics);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($output_topic_roles)) {
    $body->set('topic_roles', $output_topic_roles);
}

if (isset($output_subject['subject_id'])) {
	$template_pageLinkNote = $output_subject['subject_title'];
}

$body->set('batch_enabled', $c_node['batch']['enabled']);
$body->set('rspconfig', $c_node['rsp']);

$template_pageLink = $lang['txt_forum'];

include "inc/footer.inc.php";

?>
