<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post" name="comment" id="id_frm_comment">

<?php
if (isset($poll) && isset($poll['vote_required']) && !isset($poll['current_answer']['answer_id'])) {
	echo $lang['txt_poll_required'] . "<br />";
}
else {
	if (isset($comments)) {
	foreach($comments as $key => $i):
	?>
	
	<div class="comment">
		<span class="comment_author">
			<b><?php echo $lang['txt_comment'];?></b> -&#62; 
			<?php echo $this->date->formatDate($i['comment_create_datetime'], 1);?><br />
			<?php
			if (empty($poll['poll_anon'])) {
			?>
			<b><?php echo $lang['txt_from'];?></b> -&#62;
			<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a>, 
			<?php echo $lang['txt_joined'] . ": " . $this->date->formatDate($i['profile_create_datetime']);?>, 
			<?php echo $lang['txt_hometown'] . ": " . $i['profile_hometown'];?><br />
			<?php }?>
			
			<?php
			if (isset($poll) && empty($poll['poll_anon'])) {
			?>
				<b><?php echo $lang['hdr_vote_history'];?></b> -&#62; 
				<?php
				if (isset($i['vote'])) {
					$separator = ", ";
					foreach($i['vote'] as $key => $r):
						if ($key == (count($i['vote'])-1)) {
							$separator=".";
						}
						echo $r['option_body'] . " (" . $r['answer_create_datetime'] . ")" . $separator;
					endforeach;
				}
				?>
			<br />
			<?php }?>
		</span>
		
		<?php echo $i['comment_body'];?><br />
		
	</div>
	<?php
	endforeach;
	?>
	<?php }?>
	
	<div id="comment_form">

	<?php
	if (isset($library['library_id'])) {
	?>
		<p align="right">
			<?php
			$comm_url = $page_url;
			
			if (isset($_REQUEST['ico'])) {
				$comm_url = str_replace('&amp;ico=1', '', $comm_url);
				$comm_lang = $lang['href_all_comments'];
			}
			else {
				$comm_url = $comm_url . "&amp;ico=1";
				$comm_lang = $lang['href_item_comments_only'];
			}
			?>
			
			<a href="<?php echo $comm_url;?>"><?php echo $comm_lang;?></a>&nbsp;<br />
		</p>
		<br />
	<?php }?>


	<h3>
	<?php
		if (isset($display) && $display == "preview_comment") {
		?>
		<?php echo $lang['hdr_comment_preview'];?>
		<?php }?>
	</h3>
	
	<?php
	if (!isset($me['user_id'])) { //not logged in
	?>
		<p>
			<b><?php echo $lang['txt_no_comment_allowed_login'];?></b><br />
		</p>
	<?php
	}
	elseif (!empty($unlocked)) {
	?>
	
	
	<?php
	if (isset($hidden_form)) {
		foreach($hidden_form as $key => $i):
	?>
	<input type="hidden" name="<?php echo $key?>" value="<?php echo $i;?>" />
	<?php 
		endforeach;
	}
	?>
	
	<?php
	if (isset($display) && $display == "preview_comment") {
	?>
	<p>
		<input type="hidden" name="comment_body" value="<?php echo $comment['comment_body'];?>" />
		<?php echo $comment['display_comment_body'];?><br />
	</p>
	<p align="right">
		<input type="submit" name="edit_again" class="button_urgent" value="<?php echo $lang['sub_edit_again'];?>" />&nbsp;&nbsp;
		<input type="submit" name="insert" class="button_urgent" value="<?php echo $lang['sub_save'];?>" /><br />
	</p>
	<?php
	}
	else {
	?>
	
	
	<span class="gui">
		<script language="JavaScript" type="text/javascript">
			var displayType = 'comment';
		</script>
		<script language="JavaScript" type="text/javascript" src="js/gui_wiki.js"></script>
		</span>
	<h4><?php echo $lang['hdr_add_comment'];?></h4>
	
	<p>
		<textarea id="id_comment" name="comment_body" rows="4" cols="70"><?php if(isset($comment['comment_body'])) { echo $comment['comment_body'];}?></textarea><br />
		<script language="JavaScript" type="text/javascript">
			var txtarea = document.comment.comment_body;
		</script>
	</p>
	
	<p align="right">
		<?php if (isset($allow_spellcheck)) {?>
		<input type="button" value="<?php echo $lang['sub_check_spelling'];?>" class="input_submit" onClick="openSpellChecker();" />&nbsp;
		<?php }?>
		<input type="submit" name="preview" class="input_submit" value="<?php echo $lang['sub_preview'];?>" />&nbsp;
		
		<input type="submit" name="insert" class="input_submit" value="<?php echo $lang['sub_add'];?>" /><br />
	</p>
	<?php }?>
	<?php
	}
	else {
	?>
		<p>
			<?php echo $lang['txt_no_comment_allowed'];?><br />
		</p>
	<?php }?>
	</div>
<?php }?>
</form>