<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


// SETUP CHANNEL --------------------------------------------------------
require_once('class/Channel.class.php');
$channel = new Channel($db);


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'chl_view.lang.php');


//SETUP RSP ---------------------------------------------------------
require_once('class/Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['channel']);
$rsp->user_id = $me['user_id'];

if($c_node['rsp']['node']['auto_publish'] == 1) {
	$rsp->status_id = $c_node['rsp']['status']['live'];
}
else {
	$rsp->status_id = $c_node['rsp']['status']['pending'];
}


if (isset($frmdata['channel_insert'])) {
	$channel->user_id = $me['user_id'];
	$frmdata['language_id'] = $me['language_id'];
	$channel->insertChannel($frmdata);
	
	if (empty($GLOBALS['igloo_error_log'])) {
		$temp['item_id'] = $channel->channel_id;
		$temp['language_id'] = $me['language_id'];
		
		//delete all
		$rsp->deleteRspItem($channel->channel_id);

		//insert node rsp entry
		if (!empty($frmdata['rsp_node'])) {
			$temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
			$rsp->insertRspItem($temp);
		}
		
		header("Location: chl_view.php?channel_id=" . $channel->channel_id . "&". strip_tags(SID));
		exit;
	}
}
elseif (isset($frmdata['channel_save'])) {
	$frmdata['language_id'] = $me['language_id'];
	$channel->updateChannel($frmdata);
	
	if (empty($GLOBALS['igloo_error_log'])) {
		$temp['language_id'] = $me['language_id'];
		$temp['item_id'] = $frmdata['channel_id'];
		//delete all
		$rsp->deleteRspItem($frmdata['channel_id']);

		//insert node rsp entry
		if (!empty($frmdata['rsp_node'])) {
			$temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
			$rsp->insertRspItem($temp);
		}
		
		header("Location: chl_view.php?channel_id=" . $frmdata['channel_id'] . "&". strip_tags(SID));
		exit;
	}
}
elseif (isset($frmdata['channel_delete'])) {
	$channel->deleteChannel($frmdata['channel_id']);
	
	header("Location: chl_view.php?". strip_tags(SID));
	exit;
}


//if we get a channel ID get the channel list
if (isset($_REQUEST['channel_id'])) {
	$output_channel = $channel->selChannel($_REQUEST['channel_id']);
}


//RSP items
if (isset($output_channel['channel_id'])) {
	$output_channel['rsp'] = $rsp->selRspItem($output_channel['channel_id']);
}

//move vars to template
if (!empty($output_channel)) {
	$body->set('channel', $output_channel);
}

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>