/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.model;

import java.util.Date;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.jatec.ironmailer.framework.MailTools;
import net.jatec.ironmailer.framework.StringTools;
import org.apache.log4j.Logger;

public class MessageHeader {
    public static final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$model$MessageHeader == null ? (class$net$jatec$ironmailer$model$MessageHeader = MessageHeader.class$((String)"net.jatec.ironmailer.model.MessageHeader")) : class$net$jatec$ironmailer$model$MessageHeader));
    private String subject;
    private Date date;
    private String dateString;
    private String size;
    private InternetAddress fromAddress;
    private MimeMessage message;
    private String[] flags;
    private boolean isLastInFolder;
    private boolean hasAttachment;
    private boolean isTextOnly;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$MessageHeader;

    public MessageHeader(Message message) throws IllegalArgumentException, MessagingException {
        this(message, false);
    }

    public MessageHeader(Message message, boolean bl) throws IllegalArgumentException, MessagingException {
        int n;
        if (message == null) {
            throw new IllegalArgumentException("parameter message may not be null");
        }
        if (!(message instanceof MimeMessage)) {
            throw new IllegalArgumentException("parameter message of unsupported type " + message.getClass().getName());
        }
        this.message = (MimeMessage)message;
        this.subject = this.message.getSubject();
        this.date = this.message.getReceivedDate();
        this.dateString = StringTools.toStandardString((Date)this.date);
        this.size = StringTools.sizeToString((long)this.message.getSize());
        Address[] addressArray = this.message.getFrom();
        if (addressArray != null && addressArray.length >= 1) {
            if (addressArray[0] instanceof InternetAddress) {
                this.fromAddress = (InternetAddress)addressArray[0];
            } else {
                throw new MessagingException("unsupported address type " + addressArray[0].getClass().getName());
            }
        }
        this.isTextOnly = this.message.isMimeType("text/plain");
        this.hasAttachment = this.message.isMimeType("multipart/*");
        Flags flags = this.message.getFlags();
        if (log.isDebugEnabled()) {
            log.debug((Object)("MessageHeader() got flags: " + MailTools.toString((Flags)flags)));
        }
        Flags.Flag[] flagArray = flags.getSystemFlags();
        String[] stringArray = flags.getUserFlags();
        int n2 = flagArray.length + (this.hasAttachment ? 1 : 0);
        this.flags = new String[n2];
        for (n = 0; n < flagArray.length; ++n) {
            Flags.Flag flag = flagArray[n];
            String string = MailTools.getFlagAsString((Flags.Flag)flag);
            this.flags[n] = string != null ? string : "unknown";
        }
        for (n = 0; n < stringArray.length; ++n) {
            log.info((Object)("Note: message has user flag " + stringArray[n] + ", ignoring"));
        }
        if (this.hasAttachment) {
            this.flags[n2 - 1] = "attach";
        }
        this.isLastInFolder = bl;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDateString() {
        return this.dateString;
    }

    public String getFromName() {
        return this.fromAddress.getPersonal();
    }

    public String getFromEmail() {
        return this.fromAddress.getAddress();
    }

    public InternetAddress getFromAddress() {
        return this.fromAddress;
    }

    public String getSize() {
        return this.size;
    }

    public String[] getFlags() {
        return this.flags;
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public boolean isLastInFolder() {
        return this.isLastInFolder;
    }

    public boolean isTextOnly() {
        return this.isTextOnly;
    }

    public boolean hasAttachment() {
        return this.hasAttachment();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

