/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.util.Vector;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.URLName;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.UserInstallationException;
import net.jatec.ironmailer.model.ApplicationConfiguration;
import net.jatec.ironmailer.model.MailFolderHeader;
import net.jatec.ironmailer.model.MailboxOverview;
import net.jatec.ironmailer.model.ModelException;
import org.apache.log4j.Logger;

public class MailboxFetcher {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$MailboxFetcher == null ? (class$net$jatec$ironmailer$controller$MailboxFetcher = MailboxFetcher.class$((String)"net.jatec.ironmailer.controller.MailboxFetcher")) : class$net$jatec$ironmailer$controller$MailboxFetcher));
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$MailboxFetcher;

    public MailboxOverview createMailboxOverview(Store store, ApplicationConfiguration applicationConfiguration) throws IllegalArgumentException, MessagingException, UserInstallationException, ControllerException {
        Vector<MailFolderHeader> vector;
        URLName uRLName;
        this.log.debug((Object)"createMailboxOverview() called");
        if (store == null) {
            throw new IllegalArgumentException("parameter store must be given");
        }
        String string = "unknown";
        try {
            Folder folder;
            Folder folder2;
            if (this.log.isDebugEnabled()) {
                folder2 = store.getPersonalNamespaces();
                this.log.debug((Object)("createMailboxOverview: got " + ((Folder)folder2).length + " folders in personal namespace"));
                for (int i = 0; i < ((Folder)folder2).length; ++i) {
                    folder = folder2[i];
                    this.log.debug((Object)("createMailboxOverview: folder nb " + i + " in personal namespace has name=" + folder.getName() + ", fullName=" + folder.getFullName() + ",exists?" + folder.exists() + (folder.exists() ? ", separator=" + folder.getSeparator() : "")));
                }
            }
            folder2 = store.getDefaultFolder();
            this.log.debug((Object)"createMailboxOverview() got default folder");
            uRLName = folder2.getURLName();
            string = uRLName.getUsername();
            this.log.debug((Object)"createMailboxOverview() going to get mail folders");
            if ((folder2.getType() & 2) == 0) {
                throw new UserInstallationException("root folder has no subfolders", string, applicationConfiguration.getAdmin());
            }
            Folder[] folderArray = folder2.list();
            if (folderArray == null) {
                throw new UserInstallationException("user has no folders", string, applicationConfiguration.getAdmin());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("createMailboxOverview() got " + folderArray.length + " potential mail folders"));
            }
            vector = new Vector<MailFolderHeader>(folderArray.length);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"retrieve primary folder");
            }
            if ((folder = store.getFolder("INBOX")).exists()) {
                try {
                    MailFolderHeader mailFolderHeader = this.getMailFolderHeader(folder, 0);
                    vector.insertElementAt(mailFolderHeader, 0);
                }
                catch (ModelException modelException) {
                    this.log.warn((Object)"unexpected error on primary folder", (Throwable)modelException);
                }
            } else {
                this.log.info((Object)("primary folder not found for " + string));
            }
            for (int i = 0; i < folderArray.length; ++i) {
                if (!folderArray[i].exists() || !folderArray[i].isSubscribed() || "INBOX".equals(folderArray[i].getName())) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("createMailboxOverview() fetching header for folder nr " + i));
                }
                try {
                    MailFolderHeader mailFolderHeader = this.getMailFolderHeader(folderArray[i], 0);
                    vector.add(mailFolderHeader);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("createMailboxOverview() got header for folder nr " + i));
                    continue;
                }
                catch (MessagingException messagingException) {
                    this.log.warn((Object)("createMailboxOverview() got an exception with content: " + messagingException.toString() + ", propagating"));
                    throw messagingException;
                }
                catch (ModelException modelException) {
                    this.log.warn((Object)("createMailboxOverview() got an exception trying to create the model: " + modelException.toString() + ", creating a controller exception"));
                    throw new ControllerException("createMailboxOverview() got an exception trying to create the model: " + modelException.toString(), (Throwable)modelException);
                }
            }
        }
        catch (FolderNotFoundException folderNotFoundException) {
            throw new UserInstallationException("shouldn't happen here: " + folderNotFoundException.toString(), string, applicationConfiguration.getAdmin());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"createMailboxOverview() completed, now returning the object");
        }
        return new MailboxOverview(uRLName, vector);
    }

    private MailFolderHeader getMailFolderHeader(Folder folder, int n) throws FolderNotFoundException, MessagingException, ModelException {
        MailFolderHeader mailFolderHeader;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getMailFolderHeader() called on folder " + folder.getName()));
        }
        if ((mailFolderHeader = new MailFolderHeader(folder, n)).holdsFolders()) {
            Folder[] folderArray = folder.listSubscribed();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"getMailFolderHeader() in case where subfolders exist");
            }
            MailFolderHeader[] mailFolderHeaderArray = new MailFolderHeader[folderArray.length];
            for (int i = 0; i < folderArray.length; ++i) {
                mailFolderHeaderArray[i] = this.getMailFolderHeader(folderArray[i], n + 1);
            }
            mailFolderHeader.setSubfolders(mailFolderHeaderArray);
        }
        return mailFolderHeader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

