/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.model;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import net.jatec.ironmailer.model.Contact;
import net.jatec.ironmailer.model.ContactDuplicateException;
import org.apache.log4j.Logger;

public class ContactList {
    public static final String KEY = "ContactList";
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$model$ContactList == null ? (class$net$jatec$ironmailer$model$ContactList = ContactList.class$((String)"net.jatec.ironmailer.model.ContactList")) : class$net$jatec$ironmailer$model$ContactList));
    public static final Class[] TYPES = new Class[]{class$net$jatec$ironmailer$model$ContactList == null ? (class$net$jatec$ironmailer$model$ContactList = ContactList.class$((String)"net.jatec.ironmailer.model.ContactList")) : class$net$jatec$ironmailer$model$ContactList, class$net$jatec$ironmailer$model$Contact == null ? (class$net$jatec$ironmailer$model$Contact = ContactList.class$((String)"net.jatec.ironmailer.model.Contact")) : class$net$jatec$ironmailer$model$Contact, class$java$util$Vector == null ? (class$java$util$Vector = ContactList.class$((String)"java.util.Vector")) : class$java$util$Vector, class$javax$mail$internet$InternetAddress == null ? (class$javax$mail$internet$InternetAddress = ContactList.class$((String)"javax.mail.internet.InternetAddress")) : class$javax$mail$internet$InternetAddress, class$javax$mail$Address == null ? (class$javax$mail$Address = ContactList.class$((String)"javax.mail.Address")) : class$javax$mail$Address};
    private long key = System.currentTimeMillis();
    private Vector contacts = new Vector();
    static /* synthetic */ Class class$net$jatec$ironmailer$model$ContactList;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$Contact;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$javax$mail$internet$InternetAddress;
    static /* synthetic */ Class class$javax$mail$Address;

    public ContactList() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ContactList() created" + this.toString()));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("clone() called on " + this.toString()));
        }
        return super.clone();
    }

    public void setContacts(Vector vector) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setContacts() called, parameter has " + (vector != null ? vector.size() : 0) + " elements."));
        }
        this.contacts = vector;
    }

    public Vector getContacts() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getContacts() called on " + this.toString()));
        }
        return (Vector)this.contacts.clone();
    }

    public void setKey(long l) {
        this.key = l;
    }

    public long getKey() {
        return this.key;
    }

    public int getLength() {
        return this.contacts.size();
    }

    public Contact getContact(int n) {
        return (Contact)this.contacts.elementAt(n);
    }

    public Iterator getIterator() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"getIterator() called");
        }
        return this.contacts.iterator();
    }

    public void deleteContact(int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("deleteContact() called for index " + n));
        }
        if (n < 0 || n > this.contacts.size() - 1) {
            throw new IllegalArgumentException("index " + n + " out of bounds");
        }
        this.contacts.remove(n);
    }

    public void setContact(int n, Contact contact) {
        if (n < 0 || n > this.getLength() - 1) {
            throw new IllegalArgumentException("contactNr " + n + " is out of bounds");
        }
        if (contact == null) {
            throw new IllegalArgumentException("empty contact");
        }
        this.contacts.setElementAt(contact, n);
    }

    public void addContact(Contact contact) throws ContactDuplicateException {
        String string;
        if (contact == null) {
            throw new IllegalArgumentException("parameter newContact may not be empty");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"addContact() called");
        }
        if ((string = contact.getEmailAddress().getAddress()) != null) {
            Iterator iterator = this.contacts.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ++n;
                Contact contact2 = (Contact)iterator.next();
                if (!string.equals(contact2.getEmailAddress().getAddress())) continue;
                throw new ContactDuplicateException(contact, contact2, n);
            }
        }
        this.contacts.add(contact);
    }

    public boolean isEmpty() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("isEmpty() called, returning " + (this.contacts.size() == 0)));
        }
        return this.contacts.size() == 0;
    }

    public void sort(Comparator comparator) {
        if (!this.isEmpty()) {
            TreeSet treeSet = new TreeSet(comparator);
            treeSet.addAll(this.contacts);
            this.contacts = new Vector(treeSet);
        }
    }

    public String getContactEmails(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nArray != null) {
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                Contact contact = this.getContact(nArray[i]);
                if (!bl) {
                    stringBuffer.append(", ");
                }
                if (contact != null) {
                    stringBuffer.append(contact.getEmailAddress().toString());
                }
                bl = false;
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContactList ").append(this.key).append(" with " + this.getLength() + " elements");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

