/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.model;

import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import net.jatec.ironmailer.framework.MailTools;
import net.jatec.ironmailer.framework.StringTools;
import org.apache.log4j.Logger;

public class SendInfo {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$model$SendInfo == null ? (class$net$jatec$ironmailer$model$SendInfo = SendInfo.class$((String)"net.jatec.ironmailer.model.SendInfo")) : class$net$jatec$ironmailer$model$SendInfo));
    private boolean isOK;
    private String subject;
    private String recipients;
    private String date;
    private String validSentAddresses;
    private String validUnsentAddresses;
    private String invalidAddresses;
    private String serviceMessage;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$SendInfo;

    public SendInfo(MimeMessage mimeMessage, MessagingException messagingException) throws IllegalArgumentException, MessagingException {
        this.isOK = messagingException == null;
        this.log.debug((Object)("SendInfo() called, did sending work ? " + this.isOK));
        this.subject = mimeMessage.getSubject();
        this.recipients = MailTools.toString((Address[])mimeMessage.getAllRecipients());
        this.date = StringTools.getCurrentDateAsString();
        if (this.isOK) {
            this.validSentAddresses = null;
            this.validUnsentAddresses = null;
            this.invalidAddresses = null;
            this.serviceMessage = null;
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("SendInfo() handling case where sending failed, due to exception " + messagingException.getMessage()));
            }
            if (messagingException instanceof SendFailedException) {
                SendFailedException sendFailedException = (SendFailedException)((Object)messagingException);
                this.validSentAddresses = MailTools.toString((Address[])sendFailedException.getValidSentAddresses());
                this.validUnsentAddresses = MailTools.toString((Address[])sendFailedException.getValidUnsentAddresses());
                this.invalidAddresses = MailTools.toString((Address[])sendFailedException.getInvalidAddresses());
                this.serviceMessage = MailTools.toDisplayableString((MessagingException)((Object)sendFailedException));
            } else {
                this.serviceMessage = messagingException instanceof AddressException ? MailTools.toDisplayableString((MessagingException)messagingException) : MailTools.toDisplayableString((MessagingException)messagingException);
            }
        }
    }

    public String getValidSentAddresses() {
        return this.validSentAddresses;
    }

    public String getValidUnsentAddresses() {
        return this.validUnsentAddresses;
    }

    public String getInvalidAddresses() {
        return this.invalidAddresses;
    }

    public String getServiceMessage() {
        return this.serviceMessage;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public String getDate() {
        return this.date;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

