/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.net.URL;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.search.SearchTerm;
import net.jatec.ironmailer.controller.AbstractWorkerBean;
import net.jatec.ironmailer.controller.AttachmentController;
import net.jatec.ironmailer.controller.ContactListController;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.FolderManager;
import net.jatec.ironmailer.controller.FolderSetupException;
import net.jatec.ironmailer.controller.GeneralStore;
import net.jatec.ironmailer.controller.MailSearcher;
import net.jatec.ironmailer.controller.MailSender;
import net.jatec.ironmailer.controller.MailServerConnection;
import net.jatec.ironmailer.controller.MailboxController;
import net.jatec.ironmailer.controller.NoConnectionException;
import net.jatec.ironmailer.controller.ServerConnection;
import net.jatec.ironmailer.controller.UserInput;
import net.jatec.ironmailer.controller.action.ActionDispatcher;
import net.jatec.ironmailer.model.ApplicationConfiguration;
import net.jatec.ironmailer.model.ComposeInfo;
import net.jatec.ironmailer.model.ComposeReference;
import net.jatec.ironmailer.model.MailFolder;
import net.jatec.ironmailer.model.MailFolderHeader;
import net.jatec.ironmailer.model.MailMessage;
import net.jatec.ironmailer.model.MailPart;
import net.jatec.ironmailer.model.MailboxOverview;
import net.jatec.ironmailer.model.MessageHeader;
import net.jatec.ironmailer.model.SearchMessagesResults;
import net.jatec.ironmailer.model.SendInfo;
import net.jatec.ironmailer.model.user.UserPreferences;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MailWorkerBean
extends AbstractWorkerBean {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$MailWorkerBean == null ? (class$net$jatec$ironmailer$controller$MailWorkerBean = MailWorkerBean.class$((String)"net.jatec.ironmailer.controller.MailWorkerBean")) : class$net$jatec$ironmailer$controller$MailWorkerBean));
    private int testCtr;
    private String testString;
    private ApplicationConfiguration applicationConfiguration;
    private UserPreferences userPreferences;
    private boolean userPreferencesAvailable;
    private ComposeInfo lastComposeInfo;
    private MailSender mailSender;
    private SendInfo sendInfo;
    private GeneralStore userConfStore;
    private MailboxController mailboxController;
    private AttachmentController attachmentController;
    private FolderManager folderManager;
    private ActionDispatcher actionDispatcher;
    private Throwable lastException;
    private String firstPage;
    private ContactListController contactListController;
    private UserInput userInput;
    private SearchMessagesResults searchMessagesResults;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$MailWorkerBean;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$user$UserPreferences;

    public void initialize(ServerConnection serverConnection, URL uRL, Parameters parameters) throws IllegalArgumentException, Exception {
        super.initialize(serverConnection, uRL, parameters);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"initialize() local initializations");
        }
        this.applicationConfiguration = new ApplicationConfiguration(uRL, parameters);
        this.mailSender = new MailSender(serverConnection, this.applicationConfiguration);
        Store store = ((MailServerConnection)serverConnection).getStore();
        this.folderManager = new FolderManager(store);
        this.mailboxController = new MailboxController(store, this.applicationConfiguration);
        this.attachmentController = new AttachmentController(this.mailboxController);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"initialize() setting up user preferences");
        }
        try {
            this.initUserPreferences();
            this.userPreferencesAvailable = true;
        }
        catch (ControllerException controllerException) {
            this.log.warn((Object)"user preferences not available", (Throwable)controllerException);
            this.userPreferencesAvailable = false;
        }
        this.contactListController = new ContactListController((MailServerConnection)this.getServerConnection(), this.applicationConfiguration);
        this.actionDispatcher = new ActionDispatcher();
    }

    private void closeCache(boolean bl) throws MessagingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("closeCache() called with expunge " + bl));
        }
        if (this.mailboxController != null) {
            this.mailboxController.closeCache(bl);
        }
        if (this.lastComposeInfo != null) {
            this.lastComposeInfo.destroy();
        }
    }

    public void setTestCtr(int n) {
        this.testCtr = n;
    }

    public int getTestCtr() {
        return this.testCtr;
    }

    public void setTestString(String string) {
        this.testString = string;
    }

    public String getTestString() {
        return this.testString;
    }

    public void close() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"close() specific closings");
        }
        if (this.userConfStore != null) {
            this.userConfStore.close();
        }
        this.contactListController.close();
        this.closeCache(true);
        super.close();
    }

    public ActionDispatcher getActionDispatcher() {
        return this.actionDispatcher;
    }

    public void setMailboxOverview(boolean bl) throws ControllerException {
        try {
            this.mailboxController.setMailboxOverview(bl);
        }
        catch (ControllerException controllerException) {
            this.doError(controllerException);
        }
    }

    public MailboxOverview getMailboxOverview() {
        return this.mailboxController.getMailboxOverview();
    }

    public void setMailFolder(int n, boolean bl) throws ControllerException {
        this.mailboxController.setMailFolder(n, bl);
    }

    public MailFolder getMailFolder(int n) {
        return this.mailboxController.getMailFolder(n);
    }

    public MessageHeader getMessageHeader(int n, int n2) throws ControllerException {
        MessageHeader messageHeader = null;
        try {
            messageHeader = this.mailboxController.getMessageHeader(n, n2);
        }
        catch (ControllerException controllerException) {
            this.doError(controllerException);
        }
        return messageHeader;
    }

    public void setMessage(int n, int n2) throws ControllerException {
        try {
            this.mailboxController.setMessage(n, n2);
        }
        catch (ControllerException controllerException) {
            this.doError(controllerException);
        }
    }

    public MailMessage getMailMessage(int n, int n2) {
        return this.mailboxController.getMailMessage(n, n2);
    }

    public void setMessagesFlag(int n, int[] nArray, String string, boolean bl) throws ControllerException {
        try {
            this.mailboxController.setMessagesFlag(n, nArray, string, bl);
        }
        catch (ControllerException controllerException) {
            this.doError(controllerException);
        }
    }

    public void setMailAttachment(int n, int n2, int n3) throws ControllerException {
        try {
            this.attachmentController.setMailAttachment(n, n2, n3);
        }
        catch (ControllerException controllerException) {
            this.doError(controllerException);
        }
    }

    public MailPart getMailAttachment(int n, int n2, int n3) {
        return this.attachmentController.getMailAttachment(n, n2, n3);
    }

    public void setMailAttachmentPart(int n, int n2, int n3, int n4) throws ControllerException {
        try {
            this.attachmentController.setMailAttachmentPart(n, n2, n3, n4);
        }
        catch (ControllerException controllerException) {
            this.doError(controllerException);
        }
    }

    public MailPart getMailAttachmentPart(int n, int n2, int n3, int n4) {
        return this.attachmentController.getMailAttachmentPart(n, n2, n3, n4);
    }

    public void copyOrMoveMessages(int n, int n2, int[] nArray, boolean bl) throws ControllerException {
        this.mailboxController.copyOrMoveMessages(n, n2, nArray, bl);
    }

    public void setComposeInfo(ComposeInfo composeInfo) throws ControllerException {
        this.log.debug((Object)"setComposeInfo() called");
        this.lastComposeInfo = composeInfo;
    }

    public ComposeInfo getComposeInfo() {
        return this.lastComposeInfo;
    }

    public void send() throws ControllerException {
        if (this.lastComposeInfo == null) {
            this.doError(new ControllerException("worker bean setup error: trying to send but compose info is not set", null));
        }
        try {
            ComposeReference composeReference;
            this.sendInfo = this.mailSender.send(this.lastComposeInfo);
            if (this.sendInfo.isOK() && (composeReference = this.lastComposeInfo.getReference()) != null && composeReference.isReply()) {
                this.mailboxController.setFlag(composeReference.getFolderNr(), composeReference.getMessageNr(), Flags.Flag.ANSWERED, true);
            }
        }
        catch (MessagingException messagingException) {
            this.sendInfo = null;
            this.doError(new ControllerException("error sending", (Throwable)messagingException));
        }
    }

    public SendInfo getSendInfo() {
        return this.sendInfo;
    }

    public void addFolder(String string, boolean bl) throws ControllerException, FolderSetupException {
        this.log.debug((Object)("addFolder() called for name " + string));
        this.folderManager.addFolder(string, bl);
        this.mailboxController.setMailboxOverview(true);
        this.log.debug((Object)("addFolder() successfully created folder " + string));
    }

    public void deleteFolder(int n) throws ControllerException {
        this.log.debug((Object)("deleteFolder() called for number " + n));
        MailFolderHeader mailFolderHeader = this.getMailboxOverview().getMailFolderHeader(n);
        if (!mailFolderHeader.isDeleteable()) {
            this.doError(new ControllerException("setup error: trying to delete undeleteable folder nr " + n, null));
        }
        this.folderManager.deleteFolder(mailFolderHeader.getFolder());
        this.mailboxController.setMailboxOverview(true);
        this.log.debug((Object)("deleteFolder() successfully deleted folder nr " + n));
    }

    private GeneralStore getUserConfStore() throws ControllerException {
        if (this.userConfStore == null) {
            this.userConfStore = new GeneralStore((MailServerConnection)this.getServerConnection(), this.applicationConfiguration.getUserConfigurationFolder());
        }
        return this.userConfStore;
    }

    public void initUserPreferences() throws ControllerException {
        this.log.debug((Object)"initUserPreferences() called");
        try {
            this.userPreferences = (UserPreferences)this.getUserConfStore().getObject("UserPreferences", class$net$jatec$ironmailer$model$user$UserPreferences == null ? (class$net$jatec$ironmailer$model$user$UserPreferences = MailWorkerBean.class$((String)"net.jatec.ironmailer.model.user.UserPreferences")) : class$net$jatec$ironmailer$model$user$UserPreferences);
        }
        catch (ControllerException controllerException) {
            this.doError(new ControllerException("error setting user preferences", (Throwable)controllerException));
        }
        this.log.debug((Object)("getUserPreferences() : read current preferences, is null? " + (this.userPreferences == null)));
    }

    public boolean isUserPreferencesAvailable() {
        return this.userPreferencesAvailable;
    }

    public UserPreferences getUserPreferences() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getUserPreferences() called, null ? " + (this.userPreferences == null)));
            this.log.debug((Object)("getUserPreferences() returning this value: " + this.userPreferences));
        }
        return this.userPreferences;
    }

    public void setUserPreferences(UserPreferences userPreferences) throws NoConnectionException, ControllerException {
        try {
            this.getUserConfStore().writeAsXml("UserPreferences", (Object)userPreferences, UserPreferences.TYPES);
        }
        catch (ControllerException controllerException) {
            this.doError(new ControllerException("error setting user preferences", (Throwable)controllerException));
        }
        this.userPreferences = userPreferences;
    }

    public void setContactList() throws ControllerException {
        try {
            this.contactListController.initContactList();
        }
        catch (ControllerException controllerException) {
            this.doError(new ControllerException("error storing contact list", (Throwable)controllerException));
        }
    }

    public ContactListController getContactListController() {
        return this.contactListController;
    }

    public void searchMessages(SearchTerm searchTerm) throws ControllerException {
        try {
            MailSearcher mailSearcher = new MailSearcher(this.mailboxController);
            this.searchMessagesResults = mailSearcher.searchMessages(searchTerm);
        }
        catch (ControllerException controllerException) {
            this.doError(controllerException);
        }
    }

    public void setSearchMessagesResults(SearchMessagesResults searchMessagesResults) {
        this.searchMessagesResults = searchMessagesResults;
    }

    public SearchMessagesResults getSearchMessagesResults() {
        return this.searchMessagesResults;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public MailSender getMailSender() {
        return this.mailSender;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public void setLastException(Throwable throwable) {
        this.lastException = throwable;
    }

    public UserInput getUserInput() {
        return this.userInput;
    }

    public void setUserInput(UserInput userInput) {
        this.userInput = userInput;
    }

    public void setFirstPage(String string) {
        this.firstPage = string;
    }

    public String getFirstPage() {
        return this.firstPage;
    }

    private void doError(ControllerException controllerException) throws ControllerException {
        this.setLastException((Throwable)controllerException);
        throw controllerException;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

