<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="page/compose">
   <content>


<!-- TO DO : how to implement this now ??	  
which field to focus
<body class="body_bg">
   <xsl:attribute name="onload">
      <xsl:choose>
         <xsl:when test="is_reply">
             <xsl:value-of select="'document.composeform.body.focus();'"/>
         </xsl:when>
	 <xsl:otherwise>
	     <xsl:value-of select="'document.composeform.to.focus();'"/>
	 </xsl:otherwise>
      </xsl:choose>
   </xsl:attribute>
-->
	  	
   <!-- define the action link for this form -->
   <xsl:variable name="action_link">
       <xsl:value-of select="'leavecompose?act=leavecompose'" />
   </xsl:variable>

   <form method="post" name="composeform">
       <xsl:attribute name="action">
         <xsl:value-of select="$action_link"/>
       </xsl:attribute>
       <table cellpadding="4" cellspacing="2" border="0" width="100%">
	<tbody>
	<!-- header row -->
	<tr>
	   <td class="simpletext" height="22" colspan="3"><img align="middle" border="0" hspace="5" src="images/gnome/composer-32.png" />
		<xsl:value-of select="normalize-space(headertext1)" />
	   </td>
	</tr>

	<!-- date row -->
	<tr class="bg_for_invert">
	   <td class="white_text" height="22" colspan="3">
		<xsl:value-of select="normalize-space(date/text)" />:&#160;<xsl:value-of select="normalize-space(date/content)" />
	   </td>
 	</tr>

	<!-- "To:" row -->
	<tr class="field_light_bg">
	   <td width="13%" class="link_text" height="22"><xsl:value-of select="normalize-space(to/text)" /></td>
	   <td width="87%" class="simpletext" height="22" colspan="2">
		<input class="simpletext" size="40" name="to" type="text">
			<xsl:attribute name="value">
				<xsl:value-of select="normalize-space(to/content)" />
			</xsl:attribute>
		</input>
	   </td>
	</tr>

	<!-- "CC:" row -->
	<tr class="field_middle_bg">
	   <td width="13%" class="link_text" height="22">	
		<xsl:value-of select="normalize-space(cc/text)" /></td>
	   <td width="87%" class="simpletext" height="22" colspan="2">
		<input class="simpletext" size="40" name="cc" type="text">
			<xsl:attribute name="value"><xsl:value-of select="normalize-space(cc/content)" /></xsl:attribute>
		</input>
	   </td>
	</tr>

	<!-- "Reply-To:" row -->
	<tr class="field_light_bg">
	   <td width="13%" class="link_text" height="22">
		<xsl:value-of select="normalize-space(replyto/text)" /></td>
	   <td width="87%" class="simpletext" height="22" colspan="2">
		<input class="simpletext" size="40" name="replyto" type="text">
			<xsl:attribute name="value"><xsl:value-of select="normalize-space(replyto/content)" /></xsl:attribute>
		</input>
	   </td>
	</tr>

	<!-- "BCC" row -->
	<tr class="field_middle_bg">
	   <td width="13%" class="link_text" height="22">
		<xsl:value-of select="normalize-space(bcc/text)" /></td>
	   <td width="87%" class="simpletext" height="22" colspan="2">
		<input class="simpletext" size="40" name="bcc" type="text">
			<xsl:attribute name="value"><xsl:value-of select="normalize-space(bcc/content)" /></xsl:attribute>
		</input>
	   </td>
	</tr>

	<!-- "Subject" row -->
	<tr class="field_light_bg">
	   <td width="13%" class="link_text" height="22">
		<xsl:value-of select="normalize-space(subject/text)" /></td>
	   <td width="87%" class="simpletext" height="22" colspan="2">
		<input class="simpletext" size="40" name="subject" type="text">
			<xsl:attribute name="value"><xsl:value-of select="normalize-space(subject/content)" /></xsl:attribute>
		</input>
	   </td>
	</tr>

	<!-- Attachment stuff -->
	<tr class="field_middle_bg">
	   <td width="13%" class="link_text" height="22">
		<xsl:value-of select="normalize-space(attachment/text)" />
	   </td>
	   <td width="74%" class="simpletext" height="22">
		<xsl:value-of select="normalize-space(attachment/content)" />
	   </td>
	   <td width="13%" class="simpletext" height="22">
		<input name="attach" class="simpletext" type="submit">
			<xsl:attribute name="value">
				<xsl:value-of select="normalize-space(actiontext1)" />
			</xsl:attribute>
		</input>
	   </td>
	</tr>

	<!-- message body text row -->
	<tr class="field_light_bg">
	   <td align="center" width="13%" class="simpletext" height="22"></td>
	   <td class="simpletext" width="74%" height="22" colspan="2">
		<!-- WARNING : careful about repositioning the following content:
			may alter the display (for fields "reference") -->
		<!-- WARNING 2: do not use normalize-spaces on body contents 
			-->
		<textarea wrap="physical" class="simpletext" rows="20" cols="80" name="body">
		   <xsl:choose>
		        <!-- first case: there is a custom separator: use it -->
			<xsl:when test="body/reference/separator">
			   <xsl:value-of select="normalize-space(body/reference/separator/beforeDate)"/>&#160;<xsl:value-of select="normalize-space(body/reference/separator/date)"/>&#160;<xsl:value-of select="normalize-space(body/reference/separator/afterDate)"/>&#160;&#13;<xsl:value-of select="body/content" />
			</xsl:when>
 
			<!-- OK, so there is no custom separator.
			If we are replying, create default separator
			-->
			<xsl:when test="body/reference/reply">---&#160;<xsl:value-of select="normalize-space(body/reference/datetext)"/>&#160;<xsl:value-of select="normalize-space(body/reference/date)"/>&#160;<xsl:value-of select="normalize-space(body/reference/reply/text1)"/>&#160;(<xsl:value-of select="normalize-space(body/reference/from)"/>)&#160;<xsl:value-of select="normalize-space(body/reference/reply/text2)"/>&#160;---&#10;&#13;<xsl:value-of select="body/content" />
			</xsl:when>

			<!-- Check case where we are forwarding,
			and there is no custom separator
			-->
			<xsl:when test="body/reference/forward">---&#160;<xsl:value-of select="normalize-space(body/reference/forward/header)" />&#160; ---&#10;&#13;---&#160;<xsl:value-of select="normalize-space(body/reference/datetext)"/>&#160;<xsl:value-of select="normalize-space(body/reference/date)"/>&#160;<xsl:value-of select="normalize-space(body/reference/forward/text1)"/>&#160;(<xsl:value-of select="normalize-space(body/reference/from)"/>)&#160;<xsl:value-of select="normalize-space(body/reference/forward/text2)"/>&#160;---&#10;&#13;<xsl:value-of select="body/content" />
			</xsl:when>

			<!-- default case: no reference, but maybe there is
			already a body which was being composed
			-->
			<xsl:when test="body/content"><xsl:value-of select="body/content" /></xsl:when>
		   </xsl:choose>
		</textarea>
	   </td>
	</tr>

	<tr>
	   <!-- send button -->
	   <td align="center" class="simpletext" colspan="3">
		<input name="send" class="simpletext" type="submit">
			<xsl:attribute name="value">
				<xsl:value-of select="normalize-space(actiontext2)" />
			</xsl:attribute>
		</input>
	   </td>
	</tr>


	</tbody>
	</table>
    </form>

   </content>
</xsl:template>
	
   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
