<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="page">

<html>
 <head>
  <title><xsl:value-of select="normalize-space(title)" /></title>
  <meta content="AUTHOR" value="jwk"/>
  <link type="text/css" href="ironmailercss" rel="stylesheet" />
 </head>

 <body class="body_bg">

  <table name="errortab" border="0" cellpadding="10" cellspacing="5"
  width="80%" align="center">

    <tr>
        <td>
		<img alt="logo" src="images/application_logo_small.png"/>
	</td>
	<td>
	  <table cellpadding="3" cellspacing="5">
	    <tr>
           	<td class="bold_red">
		        <xsl:value-of select="normalize-space(error/header)"/>
		</td>
	    </tr>
	    <xsl:if test="extra">
	      <tr>
	        <td class="simpletext">
		    <xsl:value-of select="normalize-space(extra)"/>
		</td>
	      </tr>
	    </xsl:if>

	    <tr>
	      <td class="simpletext">
	         <xsl:value-of select="normalize-space(login/message)"/><br/>
	         <a target="_parent">
		   <xsl:attribute name="href">
                      <xsl:value-of select="concat(normalize-space(login/path),normalize-space(login/link_to_login))"/>
	           </xsl:attribute>
	           <xsl:value-of select="normalize-space(login/link_label)" />
                 </a>	      
	      </td>
	    </tr>

	    <xsl:if test="contact">
	    <tr>
	      <td class="infotext">
		        <xsl:variable name="mailempfaenger" select="normalize-space(contact/email)"/>
                        <xsl:variable name="mailsubject"
                        select="concat(normalize-space(error/header),' - ',normalize-space(error/content))"/>
                        <xsl:variable name="mail" select="concat('mailto:',$mailempfaenger,'?subject=IronMailer: ',$mailsubject)"/>
	      		<xsl:value-of
        	  	  select="normalize-space(contact/prefix)"/>
			  &#160;
	       		<a>
        	  	  <xsl:attribute name="href"><xsl:value-of
        	  	  select="$mail"/></xsl:attribute>
			  <xsl:value-of
        	  	  select="normalize-space(contact/name)"/>
			  &#160;(<xsl:value-of select="$mailempfaenger"/>)
	       		</a>,
	      		<xsl:value-of
        	  	  select="normalize-space(contact/suffix)"/>
			  &#160;
	      		<br />
		   </td>
		 </tr>
	     </xsl:if>

		 <tr>
		   <td class="infotext">
		      	&#160;&#160;&#160;
			<xsl:value-of select="normalize-space(error/content)"/>
		   </td>
	  	</tr>
	</table>
       </td>
      </tr>
  </table>
	
	
	<xsl:comment>Error content: <xsl:value-of select="error/content"/></xsl:comment>
	<xsl:comment>Error stack: <xsl:value-of select="error/stack"/></xsl:comment>

 </body>
</html>

</xsl:template>


</xsl:stylesheet>
