/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.util.Vector;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.URLName;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.UserInstallationException;
import net.jatec.ironmailer.model.ApplicationConfiguration;
import net.jatec.ironmailer.model.MailFolderHeader;
import net.jatec.ironmailer.model.MailboxOverview;
import net.jatec.ironmailer.model.ModelException;
import org.apache.log4j.Logger;

public class MailboxFetcher {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$MailboxFetcher == null ? (class$net$jatec$ironmailer$controller$MailboxFetcher = MailboxFetcher.class$((String)"net.jatec.ironmailer.controller.MailboxFetcher")) : class$net$jatec$ironmailer$controller$MailboxFetcher));
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$MailboxFetcher;

    public MailboxOverview createMailboxOverview(Store store, ApplicationConfiguration applicationConfiguration) throws IllegalArgumentException, MessagingException, UserInstallationException, ControllerException {
        Vector<MailFolderHeader> vector;
        URLName uRLName;
        block15: {
            this.log.debug((Object)"createMailboxOverview() called");
            if (store == null) {
                throw new IllegalArgumentException("parameter store must be given");
            }
            String string = "unknown";
            try {
                Folder folder = store.getDefaultFolder();
                this.log.debug((Object)"createMailboxOverview() got default folder");
                uRLName = folder.getURLName();
                string = uRLName.getUsername();
                this.log.debug((Object)"createMailboxOverview() going to get mail folders");
                if ((folder.getType() & 2) != 0) {
                    MailFolderHeader mailFolderHeader;
                    Folder[] folderArray = folder.listSubscribed("*");
                    if (folderArray == null) {
                        throw new UserInstallationException("user has no folders", string, applicationConfiguration.getAdmin());
                    }
                    this.log.debug((Object)("createMailboxOverview() got " + folderArray.length + " potential mail folders"));
                    vector = new Vector<MailFolderHeader>(folderArray.length);
                    boolean bl = false;
                    for (int i = 0; i < folderArray.length; ++i) {
                        if (folderArray[i].exists()) {
                            this.log.debug((Object)("createMailboxOverview() fetching header for folder nr " + i));
                            try {
                                mailFolderHeader = new MailFolderHeader(folderArray[i]);
                                this.log.debug((Object)("createMailboxOverview() got header for folder nr " + i));
                                vector.add(mailFolderHeader);
                                if (!mailFolderHeader.isPrimary()) continue;
                                bl = true;
                                continue;
                            }
                            catch (MessagingException messagingException) {
                                this.log.warn((Object)("createMailboxOverview() got an exception with content: " + messagingException.toString() + ", propagating"));
                                throw messagingException;
                            }
                            catch (ModelException modelException) {
                                this.log.warn((Object)("createMailboxOverview() got an exception trying to create the model: " + modelException.toString() + ", creating a controller exception"));
                                throw new ControllerException("createMailboxOverview() got an exception trying to create the model: " + modelException.toString(), (Throwable)modelException);
                            }
                        }
                        this.log.warn((Object)("createMailboxOverview() detected configuration error: folder " + folderArray[i].getName() + " is listed as subscribed, but does not exist. Folder not added to client model."));
                    }
                    if (!bl) {
                        this.log.info((Object)("primary folder not detected in subscribed folder list for user " + string + ", attempting to retrieve it forcefully"));
                        Folder folder2 = store.getFolder("INBOX");
                        if (folder2.exists()) {
                            try {
                                mailFolderHeader = new MailFolderHeader(folder2);
                                vector.insertElementAt(mailFolderHeader, 0);
                            }
                            catch (ModelException modelException) {
                                this.log.warn((Object)"unexpected error on primary folder", (Throwable)modelException);
                            }
                        } else {
                            this.log.info((Object)("primary folder not found for " + string));
                        }
                    }
                    break block15;
                }
                throw new UserInstallationException("root folder has no subfolders", string, applicationConfiguration.getAdmin());
            }
            catch (FolderNotFoundException folderNotFoundException) {
                throw new UserInstallationException("shouldn't happen here: " + folderNotFoundException.toString(), string, applicationConfiguration.getAdmin());
            }
        }
        this.log.debug((Object)"createMailboxOverview() completed, not creating the object");
        return new MailboxOverview(uRLName, vector);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

