/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller.action;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletRequest;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.MailWorkerBean;
import net.jatec.ironmailer.controller.UserInput;
import net.jatec.ironmailer.controller.action.ActionDispatcher;
import net.jatec.ironmailer.framework.ServletTools;
import net.jatec.ironmailer.model.Contact;
import net.jatec.ironmailer.model.ContactDuplicateException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Redirector;
import org.apache.log4j.Logger;

public class ContactAction
implements ActionDispatcher.ActionStrategy {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$action$ContactAction == null ? (class$net$jatec$ironmailer$controller$action$ContactAction = ContactAction.class$((String)"net.jatec.ironmailer.controller.action.ContactAction")) : class$net$jatec$ironmailer$controller$action$ContactAction));
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_NICKNAME = "nickname";
    private static final String[] CONTACTS_PARAMS = new String[]{"email", "name", "nickname"};
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$action$ContactAction;

    public void process(ServletRequest servletRequest, MailWorkerBean mailWorkerBean, Redirector redirector, Map map) throws ControllerException {
        this.log.debug((Object)"process() called");
        if (ServletTools.getBoolean((ServletRequest)servletRequest, (String)"new")) {
            this.handleNew(servletRequest, mailWorkerBean);
        } else if (ServletTools.getBoolean((ServletRequest)servletRequest, (String)"add")) {
            this.handleAdd(servletRequest, mailWorkerBean, redirector);
        } else if (ServletTools.getBoolean((ServletRequest)servletRequest, (String)"edit")) {
            this.handleEdit(servletRequest, mailWorkerBean);
        } else if (ServletTools.getBoolean((ServletRequest)servletRequest, (String)"update")) {
            this.handleUpdate(servletRequest, mailWorkerBean, redirector);
        } else {
            throw new ControllerException("setup error - what are you trying to do ?");
        }
        this.log.debug((Object)"process completed");
    }

    private void handleEdit(ServletRequest servletRequest, MailWorkerBean mailWorkerBean) throws ControllerException {
        Contact contact;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"handleEdit() called");
        }
        int n = ServletTools.getInteger((ServletRequest)servletRequest, (String)"contactNr", (boolean)true);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("handleEdit() editing contactNr=" + n));
        }
        if ((contact = mailWorkerBean.getContactListController().getContactList().getContact(n)) == null) {
            throw new ControllerException("setup error: trying to edit non-existing contact");
        }
        servletRequest.setAttribute("contact.edit", (Object)"true");
        servletRequest.setAttribute("contact.nr", (Object)String.valueOf(n));
        UserInput userInput = new UserInput();
        userInput.add(PARAM_EMAIL, contact.getEmailAddress().getAddress());
        userInput.add(PARAM_NAME, contact.getEmailAddress().getPersonal());
        userInput.add(PARAM_NICKNAME, contact.getNickname());
        mailWorkerBean.setUserInput(userInput);
    }

    private void handleNew(ServletRequest servletRequest, MailWorkerBean mailWorkerBean) {
        this.log.debug((Object)"handleNew() for new contact");
        servletRequest.setAttribute("contact.new", (Object)"true");
        String string = ServletTools.getString((ServletRequest)servletRequest, (String)"address");
        if (string != null) {
            UserInput userInput = new UserInput();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("handleNew() new contact, got initial address " + string));
            }
            try {
                InternetAddress internetAddress = new InternetAddress(string);
                userInput.add(PARAM_EMAIL, internetAddress.getAddress());
                userInput.add(PARAM_NAME, internetAddress.getPersonal());
            }
            catch (AddressException addressException) {
                userInput.add(PARAM_NAME, string);
            }
            mailWorkerBean.setUserInput(userInput);
        }
    }

    private void handleUpdate(ServletRequest servletRequest, MailWorkerBean mailWorkerBean, Redirector redirector) throws ControllerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"handleUpdate called");
        }
        int n = ServletTools.getInteger((ServletRequest)servletRequest, (String)"contactNr", (boolean)true);
        UserInput userInput = new UserInput(servletRequest, CONTACTS_PARAMS);
        try {
            Contact contact = this.getContact(userInput, mailWorkerBean);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"handleUpdate setting contact");
            }
            mailWorkerBean.getContactListController().setContact(n, contact);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"handleUpdate done setting contact");
            }
            servletRequest.setAttribute("contact.updated", (Object)"true");
            servletRequest.setAttribute("contact.updated.name", (Object)contact.getEmailAddress().toString());
            servletRequest.setAttribute("contact.new", (Object)"true");
            String string = ServletTools.getString((ServletRequest)servletRequest, (String)"redirect");
            if (string != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"handleUpdate() done, calling redirect");
                }
                redirector.redirect(false, string);
            }
        }
        catch (AddressException addressException) {
            this.log.debug((Object)"handleAdd() setting AddressException");
            mailWorkerBean.setUserInput(userInput);
            mailWorkerBean.setLastException((Throwable)addressException);
            servletRequest.setAttribute("contact.new", (Object)"true");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ControllerException("cannot create address due to encoding, application encoding is set to " + mailWorkerBean.getApplicationConfiguration().getEncoding(), (Throwable)unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ControllerException("got IOException when trying to redirect after a successful update", (Throwable)iOException);
        }
        catch (ProcessingException processingException) {
            throw new ControllerException("got IOException when trying to redirect after a successful update", (Throwable)processingException);
        }
    }

    private void handleAdd(ServletRequest servletRequest, MailWorkerBean mailWorkerBean, Redirector redirector) throws ControllerException {
        UserInput userInput = new UserInput(servletRequest, CONTACTS_PARAMS);
        try {
            Contact contact = this.getContact(userInput, mailWorkerBean);
            mailWorkerBean.getContactListController().addContact(contact);
            servletRequest.setAttribute("contact.added", (Object)"true");
            servletRequest.setAttribute("contact.added.name", (Object)contact.getEmailAddress().toString());
            servletRequest.setAttribute("contact.new", (Object)"true");
            String string = ServletTools.getString((ServletRequest)servletRequest, (String)"redirect");
            if (string != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"handleUpdate() done, calling redirect");
                }
                redirector.redirect(false, string);
            }
        }
        catch (ContactDuplicateException contactDuplicateException) {
            this.log.debug((Object)"handleAdd() setting ContactDuplicateException");
            mailWorkerBean.setUserInput(userInput);
            mailWorkerBean.setLastException((Throwable)contactDuplicateException);
            servletRequest.setAttribute("contact.new", (Object)"true");
        }
        catch (AddressException addressException) {
            this.log.debug((Object)"handleAdd() setting AddressException");
            mailWorkerBean.setUserInput(userInput);
            mailWorkerBean.setLastException((Throwable)addressException);
            servletRequest.setAttribute("contact.new", (Object)"true");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ControllerException("cannot create address due to encoding, application encoding is set to " + mailWorkerBean.getApplicationConfiguration().getEncoding(), (Throwable)unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ControllerException("got IOException when trying to redirect after a successful add", (Throwable)iOException);
        }
        catch (ProcessingException processingException) {
            throw new ControllerException("got IOException when trying to redirect after a successful add", (Throwable)processingException);
        }
    }

    private Contact getContact(UserInput userInput, MailWorkerBean mailWorkerBean) throws AddressException, UnsupportedEncodingException {
        String string = userInput.get(PARAM_EMAIL);
        String string2 = userInput.get(PARAM_NAME);
        Contact contact = new Contact();
        new InternetAddress(string);
        InternetAddress internetAddress = new InternetAddress(string, string2, mailWorkerBean.getApplicationConfiguration().getEncoding());
        contact.setEmailAddress(internetAddress);
        contact.setNickname(userInput.get(PARAM_NICKNAME));
        return contact;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

