<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="page/attach">
  <content>

   <xsl:variable name="delete_link_prefix"
      select="'attach.xsl?act=attach&amp;delete=true&amp;fileId='"/>
   <xsl:variable name="compose_link" 
      select="'compose.xsl?act=compose&amp;continue=true'"/>
   <xsl:variable name="fileattach_link"
      select="'attach.xsl'"/>

   <form enctype="multipart/form-data" method="post" name="attachform">
      <xsl:attribute name="action">
         <xsl:value-of select="$fileattach_link"/>
      </xsl:attribute>
      <input type="hidden" name="act" value="fileattach" />
		
      <table cellpadding="4" cellspacing="2" border="0" width="100%"><tbody>
	<!-- Header row -->
	<tr>
	   <td class="simpletext" colspan="2">
	      <img align="middle" border="0" hspace="5" src="images/gnome/composer.png" /><xsl:value-of select="normalize-space(attach/headertext1)" />
	   </td>
	</tr>
	<!-- "Browse file" step row 1 -->
	<tr class="bg_for_invert">
	   <td class="white_text" colspan="2">
	   	<b><xsl:value-of select="normalize-space(attach/step1/header)" /></b>&#160;<xsl:value-of select="normalize-space(attach/step1/content)" />
	   </td>
	</tr>
	<!-- "Browse file" step row 2 -->
	<tr class="field_light_bg">
		<td class="simpletext" colspan="2">
			<!-- note: input widget with type file does not seem to have a way of setting it's button name :( -->
			<input class="simpletext" size="20" name="file" type="file">
			</input>
		</td>
	</tr>
	<!-- space row -->
	<tr class="field_dark_bg">
		<td class="link_text">
			&#160;
		</td>
	</tr>
	<!-- "Attach file" step row 1 -->
	<tr class="bg_for_invert">
		<td class="white_text">
        		<b><xsl:value-of select="normalize-space(attach/step2/header)" /></b>&#160;<xsl:value-of select="normalize-space(attach/step2/content)" />
        	</td>
	</tr>
	<!-- "Attach file" step row 2 -->
	<tr class="field_light_bg">
		<td  class="simpletext">
			<input class="simpletext" name="add" type="submit">
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(attach/loadactiontext)" />
				</xsl:attribute>
			</input>
		</td>				
	</tr>
	<!-- space row -->
	<tr class="field_dark_bg">
		<td class="link_text" align="left">
			&#160;
		</td>
	</tr>

	</tbody></table>
   </form>

   <!-- List of already attached files -->			
   <table cellpadding="4" cellspacing="2" border="0" width="100%"><tbody>
	<!-- header -->
	<tr class="bg_for_invert">
		<td class="white_text" colspan="3">
	        	<b><xsl:value-of select="normalize-space(attach/step3/header)" /></b>&#160;<xsl:value-of select="normalize-space(attach/step3/content)" />
	        </td>
	</tr>

	<!-- list header row -->
	<tr class="bg_for_invert">
		<td class="white_text"><xsl:value-of select="normalize-space(attach/listheader1)" /></td>
		<td class="white_text"><xsl:value-of select="normalize-space(attach/listheader2)" /></td>
		<td class="white_text">&#160;</td>
	</tr>	
	<!-- list of attached files -->
	<xsl:for-each select="attach/file">
		<tr class="field_light_bg">
			<td class="simpletext">
				<xsl:value-of select="normalize-space(name)" />
			</td>
			<td class="simpletext">
				<xsl:value-of select="normalize-space(size)" />
			</td>
			<td class="simpletext">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="concat($delete_link_prefix,normalize-space(id))"/>
					</xsl:attribute>
					<img src="images/gnome/flag-deleted.png" border="0">
						<xsl:attribute name="alt">
							<xsl:value-of select="normalize-space(../delactionhelp)" />
						</xsl:attribute>
					</img>
				</a>
			</td>
		</tr>
	</xsl:for-each>

	<!-- size row -->
	<tr class="field_middle_bg">
		<td class="link_text" align="left" colspan="3">
			<xsl:value-of select="normalize-space(attach/size/header)" />&#160;<xsl:value-of select="normalize-space(attach/size/used)" />&#160;/&#160;<xsl:value-of select="normalize-space(attach/size/allowed)" />
		</td>
	</tr>
			
	<!-- space row -->
	<tr class="field_dark_bg">
		<td class="link_text" align="left" colspan="3">
			&#160;
		</td>
	</tr>
			
	<!-- footer row (with "back" button) -->
	<tr class="bg_for_invert">
		<td colspan="3">
			<table cellspacing="0" cellpadding="0" border="0">
			<tbody>
				<tr>
					<td>
						<a>
						  <xsl:attribute name="href"><xsl:value-of select="$compose_link"/></xsl:attribute>
							<img border="0" hspace="5" src="images/gnome/arrow_back.png" />
						</a>
					</td>
					<td>
						<a>
						  <xsl:attribute name="href"><xsl:value-of select="$compose_link"/></xsl:attribute>
							<span class="white_text"><xsl:value-of select="normalize-space(attach/footertext1)" /></span>
						</a>
					</td>
				</tr>
			</tbody>
			</table>
		</td>
	</tr>
			
   </tbody></table>	
		
	
   <xsl:if test="error">
	<p class="bold_red">
	    <img align="middle" border="0" src="images/gnome/dialog-error.png" />
	       	<xsl:value-of select="normalize-space(error/content)"/>
	</p>
	<xsl:comment>Error stack: <xsl:value-of select="normalize-space(error/stack)"/></xsl:comment>
   </xsl:if>
 </content>
</xsl:template>
	
   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
