/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import com.coyotegulch.jisp.BTreeIndex;
import com.coyotegulch.jisp.IndexedObjectDatabase;
import com.coyotegulch.jisp.KeyNotFound;
import com.coyotegulch.jisp.ObjectIndex;
import java.io.File;
import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.util.IOUtils;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.impl.AbstractJispFilesystemStore;

public class DefaultStore
extends AbstractJispFilesystemStore
implements Store,
Contextualizable,
ThreadSafe,
Parameterizable,
Disposable {
    protected Context context;

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void parameterize(Parameters params) throws ParameterException {
        try {
            File workDir = (File)this.context.get((Object)"work-directory");
            if (params.getParameterAsBoolean("use-cache-directory", false)) {
                File cacheDir = (File)this.context.get((Object)"cache-directory");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using cache directory: " + cacheDir);
                }
                this.setDirectory(cacheDir);
            } else if (params.getParameterAsBoolean("use-work-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using work directory: " + workDir);
                }
                this.setDirectory(workDir);
            } else if (params.getParameter("directory", null) != null) {
                String dir = params.getParameter("directory");
                dir = IOUtils.getContextFilePath(workDir.getPath(), dir);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using directory: " + dir);
                }
                this.setDirectory(new File(dir));
            } else {
                try {
                    this.setDirectory(workDir);
                }
                catch (IOException e) {}
            }
        }
        catch (ContextException ce) {
            throw new ParameterException("Unable to get directory information from context.", (Throwable)ce);
        }
        catch (IOException e) {
            throw new ParameterException("Unable to set directory", (Throwable)e);
        }
        String databaseName = params.getParameter("datafile", "cocoon.dat");
        String indexName = params.getParameter("m_indexFile", "cocoon.idx");
        int order = params.getParameterAsInteger("order", 301);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Database file name = " + databaseName);
            this.getLogger().debug("Index file name = " + indexName);
            this.getLogger().debug("Order=" + order);
        }
        File databaseFile = new File(this.m_directoryFile, databaseName);
        File indexFile = new File(this.m_directoryFile, indexName);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Initializing JispFilesystemStore");
        }
        try {
            boolean databaseExists = databaseFile.exists();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Datafile exists: " + databaseExists);
            }
            this.m_Database = new IndexedObjectDatabase(databaseFile.toString(), !databaseExists);
            this.m_Index = !databaseExists ? new BTreeIndex(indexFile.toString(), order, super.getNullKey(), false) : new BTreeIndex(indexFile.toString());
            this.m_Database.attachIndex((ObjectIndex)this.m_Index);
        }
        catch (KeyNotFound ignore) {
        }
        catch (Exception e) {
            this.getLogger().error("Exception during initialization of jisp store.", (Throwable)e);
        }
    }

    public void dispose() {
        try {
            this.getLogger().debug("Disposing");
            if (this.m_Index != null) {
                this.m_Index.close();
            }
            if (this.m_Database != null) {
                this.m_Database.close();
            }
        }
        catch (Exception e) {
            this.getLogger().error("dispose(..) Exception", (Throwable)e);
        }
    }
}

