/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cocoon.servlet.ParanoidCocoonServlet;

public class BootstrapServlet
extends ParanoidCocoonServlet {
    protected File contextDir;

    protected File getContextDir() throws ServletException {
        ServletContext context = this.getServletContext();
        ServletConfig config = this.getServletConfig();
        this.log("getRealPath(\"/\") = " + context.getRealPath("/"));
        String contextDirParam = config.getInitParameter("context-directory");
        if (contextDirParam == null) {
            throw new ServletException("The 'context-directory' parameter must be set to the root of the servlet context");
        }
        if (contextDirParam.endsWith("/")) {
            contextDirParam = contextDirParam.substring(0, contextDirParam.length() - 1);
        }
        this.contextDir = new File(contextDirParam);
        if (!this.contextDir.exists()) {
            String msg = "Context dir '" + this.contextDir + "' doesn't exist";
            this.log(msg);
            throw new ServletException(msg);
        }
        if (!this.contextDir.isDirectory()) {
            String msg = "Context dir '" + this.contextDir + "' should be a directory";
            this.log(msg);
            throw new ServletException(msg);
        }
        context.log("Context dir set to " + this.contextDir);
        return this.contextDir;
    }

    protected void initServlet() throws ServletException {
        ContextWrapper newContext = new ContextWrapper(this.getServletContext(), this.contextDir);
        ConfigWrapper newConfig = new ConfigWrapper(this.getServletConfig(), newContext);
        this.servlet.init((ServletConfig)newConfig);
    }

    public static class ContextWrapper
    implements ServletContext {
        ServletContext context;
        File contextRoot;

        public ContextWrapper(ServletContext context, File contextRoot) {
            this.context = context;
            this.contextRoot = contextRoot;
        }

        public ServletContext getContext(String param) {
            return this.context.getContext(param);
        }

        public int getMajorVersion() {
            return this.context.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.context.getMinorVersion();
        }

        public String getMimeType(String param) {
            return this.context.getMimeType(param);
        }

        public URL getResource(String path) throws MalformedURLException {
            File file = new File(this.contextRoot, path);
            if (file.exists()) {
                URL result = file.toURL();
                return result;
            }
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            try {
                URL url = this.getResource(path);
                return url == null ? null : url.openStream();
            }
            catch (Exception e) {
                this.context.log("getResourceAsStream(" + path + ") failed", (Throwable)e);
                return null;
            }
        }

        public RequestDispatcher getRequestDispatcher(String param) {
            return this.context.getRequestDispatcher(param);
        }

        public RequestDispatcher getNamedDispatcher(String param) {
            return this.context.getNamedDispatcher(param);
        }

        public Servlet getServlet(String param) throws ServletException {
            return this.context.getServlet(param);
        }

        public Enumeration getServlets() {
            return this.context.getServlets();
        }

        public Enumeration getServletNames() {
            return this.context.getServletNames();
        }

        public void log(String msg) {
            this.context.log(msg);
        }

        public void log(Exception ex, String msg) {
            this.context.log(ex, msg);
        }

        public void log(String msg, Throwable thr) {
            this.context.log(msg, thr);
        }

        public String getRealPath(String path) {
            String result = this.contextRoot + path;
            return result;
        }

        public String getServerInfo() {
            return this.context.getServerInfo();
        }

        public String getInitParameter(String param) {
            return this.context.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return this.context.getInitParameterNames();
        }

        public Object getAttribute(String param) {
            Object result = this.context.getAttribute(param);
            return result;
        }

        public Enumeration getAttributeNames() {
            return this.context.getAttributeNames();
        }

        public void setAttribute(String name, Object value) {
            this.context.setAttribute(name, value);
        }

        public void removeAttribute(String name) {
            this.context.removeAttribute(name);
        }

        public Set getResourcePaths(String param) {
            return null;
        }

        public String getServletContextName() {
            return "Cocoon context";
        }
    }

    public static class ConfigWrapper
    implements ServletConfig {
        ServletConfig config;
        ServletContext context;

        public ConfigWrapper(ServletConfig config, ServletContext context) {
            this.config = config;
            this.context = context;
        }

        public String getServletName() {
            return this.config.getServletName();
        }

        public Enumeration getInitParameterNames() {
            return this.config.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getInitParameter(String name) {
            return this.config.getInitParameter(name);
        }
    }
}

