/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.transformation.helpers.IncludeCacheStorageProxy;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public final class ModifiableSourceIncludeCacheStorageProxy
implements IncludeCacheStorageProxy {
    private SourceResolver resolver;
    private String parentURI;
    private Logger logger;

    public ModifiableSourceIncludeCacheStorageProxy(SourceResolver resolver, String parentURI, Logger logger) {
        this.resolver = resolver;
        this.parentURI = parentURI;
        this.logger = logger;
    }

    private String getURI(String uri) {
        long hash = HashUtil.hash(uri);
        StringBuffer buffer = new StringBuffer(this.parentURI);
        buffer.append('/');
        if (hash < 0L) {
            buffer.append('M').append(hash * -1L);
        } else {
            buffer.append(hash);
        }
        buffer.append(".cxml");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Serializable get(String uri) {
        Serializable result;
        Source child;
        block7: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("WSCProxy: Getting content for " + uri);
            }
            child = null;
            result = null;
            try {
                child = this.resolver.resolveURI(this.getURI(uri));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("WSCProxy: Resolved to " + child.getURI());
                }
                if (!child.exists()) break block7;
                InputStream is = child.getInputStream();
                ObjectInputStream ois = new ObjectInputStream(is);
                result = (Serializable)ois.readObject();
                ois.close();
            }
            catch (Exception ignore) {
                this.resolver.release(child);
                catch (Throwable throwable) {
                    this.resolver.release(child);
                    throw throwable;
                }
            }
        }
        this.resolver.release(child);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WSCProxy: Result for " + uri + " : " + (result == null ? "Not in cache" : "Found"));
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(String uri, Serializable object) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WSCProxy: Storing content for " + uri);
        }
        Source child = null;
        try {
            child = this.resolver.resolveURI(this.getURI(uri));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("WSCProxy: Resolved to " + child.getURI());
            }
            if (!(child instanceof ModifiableSource)) throw new IOException("Source " + uri + " is not writeable.");
            OutputStream os = ((ModifiableSource)child).getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(object);
            oos.flush();
            oos.close();
        }
        catch (IOException io) {
            try {
                throw io;
                catch (Exception ignore) {
                    throw new CascadingIOException("Exception.", ignore);
                }
            }
            catch (Throwable throwable) {
                this.resolver.release(child);
                throw throwable;
            }
        }
        this.resolver.release(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void remove(String uri) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WSCProxy: Removing content for " + uri);
        }
        Source child = null;
        try {
            child = this.resolver.resolveURI(this.getURI(uri));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("WSCProxy: Resolved to " + child.getURI());
            }
            if (!(child instanceof ModifiableSource)) {
                throw new IOException("Source " + uri + " is not writeable.");
            }
            ((ModifiableSource)child).delete();
        }
        catch (Exception exception) {
            this.resolver.release(child);
            catch (Throwable throwable) {
                this.resolver.release(child);
                throw throwable;
            }
        }
        this.resolver.release(child);
    }

    public boolean equals(Object object) {
        if (object instanceof ModifiableSourceIncludeCacheStorageProxy) {
            return this.parentURI.equals(((ModifiableSourceIncludeCacheStorageProxy)object).parentURI);
        }
        return false;
    }

    public int hashCode() {
        return this.parentURI.hashCode();
    }
}

