/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.dom;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.xml.dom.DOMSerializer;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DefaultDOMSerializer
extends AbstractLogEnabled
implements DOMSerializer,
Component {
    private final TransformerFactory m_factory = TransformerFactory.newInstance();

    public void serialize(Document document, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException {
        try {
            Transformer transformer = this.m_factory.newTransformer();
            DOMSource source = new DOMSource(document);
            SAXResult result = new SAXResult(contentHandler);
            result.setLexicalHandler(lexicalHandler);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            this.getLogger().error("Cannot create transformer", (Throwable)e);
            throw new SAXException(e);
        }
        catch (TransformerException e) {
            this.getLogger().error("Cannot serialize document", (Throwable)e);
            throw new SAXException(e);
        }
    }
}

