/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.BranchStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class Continue
extends BranchStatement {
    public Continue(char[] l, int s, int e) {
        super(l, s, e);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowContext targetContext;
        FlowContext flowContext2 = targetContext = this.label == null ? flowContext.getTargetContextForDefaultContinue() : flowContext.getTargetContextForContinueLabel(this.label);
        if (targetContext == null) {
            if (this.label == null) {
                currentScope.problemReporter().invalidContinue(this);
            } else {
                currentScope.problemReporter().undefinedLabel(this);
            }
            return flowInfo;
        }
        if (targetContext == FlowContext.NotContinuableContext) {
            currentScope.problemReporter().invalidContinue(this);
            return flowInfo;
        }
        this.targetLabel = targetContext.continueLabel();
        FlowContext traversedContext = flowContext;
        int subIndex = 0;
        int maxSub = 5;
        this.subroutines = new AstNode[maxSub];
        do {
            AstNode sub;
            if ((sub = traversedContext.subRoutine()) != null) {
                if (subIndex == maxSub) {
                    this.subroutines = new AstNode[maxSub *= 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
                }
                this.subroutines[subIndex++] = sub;
                if (sub.cannotReturn()) break;
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            AstNode node = traversedContext.associatedNode;
            if (node instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)node;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                continue;
            }
            if (traversedContext != targetContext) continue;
            targetContext.recordContinueFrom(flowInfo);
            break;
        } while ((traversedContext = traversedContext.parent) != null);
        if (subIndex != maxSub) {
            this.subroutines = new AstNode[subIndex];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
        }
        return FlowInfo.DEAD_END;
    }

    public String toString(int tab) {
        String s = AstNode.tabString(tab);
        s = String.valueOf(s) + "continue ";
        if (this.label != null) {
            s = String.valueOf(s) + new String(this.label);
        }
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        visitor.visit(this, blockScope);
        visitor.endVisit(this, blockScope);
    }
}

