/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;

public abstract class ClasspathLocation {
    static ClasspathLocation forSourceFolder(IContainer sourceFolder, IContainer outputFolder, char[][] exclusionPatterns) {
        return new ClasspathMultiDirectory(sourceFolder, outputFolder, exclusionPatterns);
    }

    public static ClasspathLocation forBinaryFolder(IContainer binaryFolder, boolean isOutputFolder) {
        return new ClasspathDirectory(binaryFolder, isOutputFolder);
    }

    static ClasspathLocation forLibrary(String libraryPathname) {
        return new ClasspathJar(libraryPathname);
    }

    static ClasspathLocation forLibrary(IFile library) {
        return new ClasspathJar(library);
    }

    public abstract NameEnvironmentAnswer findClass(String var1, String var2, String var3);

    public abstract IPath getProjectRelativePath();

    public boolean isOutputFolder() {
        return false;
    }

    public abstract boolean isPackage(String var1);

    public void cleanup() {
    }

    public void reset() {
    }
}

