/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.RepeatablePageMasterAlternatives;

public class ConditionalPageMasterReference
extends FObj {
    private RepeatablePageMasterAlternatives repeatablePageMasterAlternatives;
    private String masterName;
    private int pagePosition;
    private int oddOrEven;
    private int blankOrNotBlank;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public ConditionalPageMasterReference(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (this.getProperty("master-reference") != null) {
            this.masterName = this.getProperty("master-reference").getString();
        }
        if (parent.getName().equals("fo:repeatable-page-master-alternatives")) {
            this.repeatablePageMasterAlternatives = (RepeatablePageMasterAlternatives)parent;
            if (this.masterName == null) {
                this.log.warn("A fo:conditional-page-master-reference does not have a master-reference and so is being ignored");
            } else {
                this.repeatablePageMasterAlternatives.addConditionalPageMasterReference(this);
            }
        } else {
            throw new FOPException("fo:conditional-page-master-reference must be child of fo:repeatable-page-master-alternatives, not " + parent.getName(), systemId, line, column);
        }
        this.pagePosition = this.properties.get("page-position").getEnum();
        this.oddOrEven = this.properties.get("odd-or-even").getEnum();
        this.blankOrNotBlank = this.properties.get("blank-or-not-blank").getEnum();
    }

    public String getName() {
        return "fo:conditional-page-master-reference";
    }

    protected boolean isValid(boolean isOddPage, boolean isFirstPage, boolean isEmptyPage) {
        if (isFirstPage) {
            if (this.pagePosition == 94) {
                return false;
            }
            if (this.pagePosition == 55) {
                this.log.warn("conditional-page-master-reference: page-position='last' is not yet implemented (NYI)");
                return false;
            }
        } else {
            if (this.pagePosition == 38) {
                return false;
            }
            if (this.pagePosition == 55) {
                this.log.warn("conditional-page-master-reference: page-position='last' is not yet implemented (NYI)");
            }
        }
        if (isOddPage ? this.oddOrEven == 34 : this.oddOrEven == 79) {
            return false;
        }
        return !(isEmptyPage ? this.blankOrNotBlank == 77 : this.blankOrNotBlank == 13);
    }

    protected int getPagePosition() {
        return this.pagePosition;
    }

    protected int getOddOrEven() {
        return this.oddOrEven;
    }

    protected int getBlankOrNotBlank() {
        return this.blankOrNotBlank;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new ConditionalPageMasterReference(parent, propertyList, systemId, line, column);
        }
    }
}

