/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.testcase;

import org.apache.avalon.framework.ExceptionUtil;
import org.apache.avalon.framework.logger.Logger;

public class BufferedLogger
implements Logger {
    private final StringBuffer m_sb = new StringBuffer();

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable throwable) {
        this.append("DEBUG", message, throwable);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Throwable throwable) {
        this.append("INFO", message, throwable);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable throwable) {
        this.append("WARN", message, throwable);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable throwable) {
        this.append("ERROR", message, throwable);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void fatalError(String message) {
        this.fatalError(message, null);
    }

    public void fatalError(String message, Throwable throwable) {
        this.append("FATAL ERROR", message, throwable);
    }

    public boolean isFatalErrorEnabled() {
        return true;
    }

    public Logger getChildLogger(String name) {
        return this;
    }

    public String toString() {
        return this.m_sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(String level, String message, Throwable throwable) {
        StringBuffer stringBuffer = this.m_sb;
        synchronized (stringBuffer) {
            this.m_sb.append(level);
            this.m_sb.append(" - ");
            this.m_sb.append(message);
            if (null != throwable) {
                String stackTrace = ExceptionUtil.printStackTrace((Throwable)throwable);
                this.m_sb.append(" : ");
                this.m_sb.append(stackTrace);
            }
            this.m_sb.append("\n");
        }
    }
}

