/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.impl;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import org.apache.excalibur.event.PreparedEnqueue;
import org.apache.excalibur.event.SinkException;
import org.apache.excalibur.event.SinkFullException;
import org.apache.excalibur.event.impl.AbstractQueue;

public final class FixedSizeQueue
extends AbstractQueue {
    private final Object[] m_elements;
    private final ReentrantLock m_mutex;
    private int m_start = 0;
    private int m_end = 0;
    protected int m_reserve = 0;

    public FixedSizeQueue(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Cannot specify an unbounded Queue");
        }
        this.m_elements = new Object[size + 1];
        this.m_mutex = new ReentrantLock();
    }

    public int size() {
        int size = 0;
        size = this.m_end < this.m_start ? this.maxSize() - this.m_start + this.m_end : this.m_end - this.m_start;
        return size + this.m_reserve;
    }

    public int maxSize() {
        return this.m_elements.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedEnqueue prepareEnqueue(Object[] elements) throws SinkException {
        FixedSizePreparedEnqueue enqueue = null;
        try {
            this.m_mutex.acquire();
            try {
                if (elements.length + this.size() > this.maxSize()) {
                    throw new SinkFullException("Not enough room to enqueue these elements.");
                }
                enqueue = new FixedSizePreparedEnqueue(this, elements);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_mutex.release();
                throw throwable;
            }
            this.m_mutex.release();
            {
            }
        }
        catch (InterruptedException ie) {}
        return enqueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryEnqueue(Object element) {
        boolean success = false;
        try {
            block6: {
                boolean bl;
                block5: {
                    this.m_mutex.acquire();
                    try {
                        if (1 + this.size() > this.maxSize()) {
                            bl = false;
                            Object var5_5 = null;
                            break block5;
                        }
                        this.addElement(element);
                        success = true;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        this.m_mutex.release();
                        throw throwable;
                    }
                }
                this.m_mutex.release();
                return bl;
            }
            Object var5_6 = null;
            this.m_mutex.release();
            return success;
        }
        catch (InterruptedException ie) {
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object[] elements) throws SinkException {
        int len = elements.length;
        try {
            this.m_mutex.acquire();
            try {
                if (elements.length + this.size() > this.maxSize()) {
                    throw new SinkFullException("Not enough room to enqueue these elements.");
                }
                int i = 0;
                while (i < len) {
                    this.addElement(elements[i]);
                    ++i;
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.m_mutex.release();
                throw throwable;
            }
            this.m_mutex.release();
            {
            }
        }
        catch (InterruptedException ie) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object element) throws SinkException {
        try {
            this.m_mutex.acquire();
            try {
                if (1 + this.size() > this.maxSize()) {
                    throw new SinkFullException("Not enough room to enqueue these elements.");
                }
                this.addElement(element);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_mutex.release();
                throw throwable;
            }
            this.m_mutex.release();
            {
            }
        }
        catch (InterruptedException ie) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] dequeue(int numElements) {
        Object[] elements;
        block4: {
            elements = AbstractQueue.EMPTY_ARRAY;
            try {
                if (!this.m_mutex.attempt(this.m_timeout)) break block4;
                try {
                    elements = this.retrieveElements(Math.min(this.size(), numElements));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.m_mutex.release();
                    throw throwable;
                }
                this.m_mutex.release();
                {
                }
            }
            catch (InterruptedException ie) {}
        }
        return elements;
    }

    private final void addElement(Object element) {
        this.m_elements[this.m_end] = element;
        ++this.m_end;
        if (this.m_end >= this.maxSize()) {
            this.m_end = 0;
        }
    }

    private final Object removeElement() {
        Object element = this.m_elements[this.m_start];
        if (null != element) {
            this.m_elements[this.m_start] = null;
            ++this.m_start;
            if (this.m_start >= this.maxSize()) {
                this.m_start = 0;
            }
        }
        return element;
    }

    private final Object[] retrieveElements(int count) {
        Object[] elements = new Object[count];
        int i = 0;
        while (i < count) {
            elements[i] = this.removeElement();
            ++i;
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] dequeueAll() {
        Object[] elements;
        block4: {
            elements = AbstractQueue.EMPTY_ARRAY;
            try {
                if (!this.m_mutex.attempt(this.m_timeout)) break block4;
                try {
                    elements = this.retrieveElements(this.size());
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.m_mutex.release();
                    throw throwable;
                }
                this.m_mutex.release();
                {
                }
            }
            catch (InterruptedException ie) {}
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue() {
        Object element;
        block5: {
            element = null;
            try {
                if (!this.m_mutex.attempt(this.m_timeout)) break block5;
                try {
                    if (this.size() > 0) {
                        element = this.removeElement();
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.m_mutex.release();
                    throw throwable;
                }
                this.m_mutex.release();
                {
                }
            }
            catch (InterruptedException ie) {}
        }
        return element;
    }

    private static final class FixedSizePreparedEnqueue
    implements PreparedEnqueue {
        private final FixedSizeQueue m_parent;
        private Object[] m_elements;

        private FixedSizePreparedEnqueue(FixedSizeQueue parent, Object[] elements) {
            this.m_parent = parent;
            this.m_elements = elements;
            this.m_parent.m_reserve += this.m_elements.length;
        }

        public void commit() {
            if (null == this.m_elements) {
                throw new IllegalStateException("This PreparedEnqueue has already been processed!");
            }
            try {
                this.m_parent.enqueue(this.m_elements);
                this.m_parent.m_reserve -= this.m_elements.length;
                this.m_elements = null;
            }
            catch (Exception e) {
                throw new IllegalStateException("Default enqueue did not happen--should be impossible");
            }
        }

        public void abort() {
            if (null == this.m_elements) {
                throw new IllegalStateException("This PreparedEnqueue has already been processed!");
            }
            this.m_parent.m_reserve -= this.m_elements.length;
            this.m_elements = null;
        }
    }
}

