/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class AND_AND_Expression
extends BinaryExpression {
    int rightInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public AND_AND_Expression(Expression left, Expression right, int operator) {
        super(left, right, operator);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean isLeftOptimizedFalse;
        Constant cst = this.left.optimizedBooleanConstant();
        boolean isLeftOptimizedTrue = cst != AstNode.NotAConstant && cst.booleanValue();
        boolean bl = isLeftOptimizedFalse = cst != AstNode.NotAConstant && !cst.booleanValue();
        if (isLeftOptimizedTrue) {
            FlowInfo mergedInfo = this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            mergedInfo = this.right.analyseCode(currentScope, flowContext, mergedInfo);
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
            return mergedInfo;
        }
        FlowInfo leftInfo = this.left.analyseCode(currentScope, flowContext, flowInfo);
        FlowInfo rightInfo = leftInfo.initsWhenTrue().unconditionalInits().copy();
        this.rightInitStateIndex = currentScope.methodScope().recordInitializationStates(rightInfo);
        int previousMode = rightInfo.reachMode();
        if (isLeftOptimizedFalse) {
            rightInfo.setReachMode(1);
        }
        rightInfo = this.right.analyseCode(currentScope, flowContext, rightInfo);
        FlowInfo trueMergedInfo = rightInfo.initsWhenTrue().copy();
        rightInfo.setReachMode(previousMode);
        FlowInfo mergedInfo = FlowInfo.conditional(trueMergedInfo, leftInfo.initsWhenFalse().copy().unconditionalInits().mergedWith(rightInfo.initsWhenFalse().copy().unconditionalInits()));
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        this.bits |= 0x20;
        Label falseLabel = new Label(codeStream);
        this.generateOptimizedBoolean(currentScope, codeStream, null, falseLabel, valueRequired);
        if (falseLabel.hasForwardReferences()) {
            if (valueRequired) {
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.ireturn();
                    falseLabel.place();
                    codeStream.iconst_0();
                } else {
                    Label endLabel = new Label(codeStream);
                    codeStream.goto_(endLabel);
                    codeStream.decrStackSize(1);
                    falseLabel.place();
                    codeStream.iconst_0();
                    endLabel.place();
                }
            } else {
                falseLabel.place();
            }
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.updateLastRecordedEndPC(codeStream.position);
    }

    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if (this.constant != Constant.NotAConstant) {
            super.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            return;
        }
        Constant condConst = this.left.optimizedBooleanConstant();
        if (condConst != AstNode.NotAConstant) {
            if (condConst.booleanValue()) {
                this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                if (this.rightInitStateIndex != -1) {
                    codeStream.addDefinitelyAssignedVariables(currentScope, this.rightInitStateIndex);
                }
                if ((this.bits & 0x20) != 0) {
                    this.right.generateCode(currentScope, codeStream, valueRequired);
                } else {
                    this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                }
            } else {
                this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                if (valueRequired) {
                    if ((this.bits & 0x20) != 0) {
                        codeStream.iconst_0();
                    } else if (falseLabel != null) {
                        codeStream.goto_(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            return;
        }
        condConst = this.right.optimizedBooleanConstant();
        if (condConst != AstNode.NotAConstant) {
            if (condConst.booleanValue()) {
                if ((this.bits & 0x20) != 0) {
                    this.left.generateCode(currentScope, codeStream, valueRequired);
                } else {
                    this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                }
                if (this.rightInitStateIndex != -1) {
                    codeStream.addDefinitelyAssignedVariables(currentScope, this.rightInitStateIndex);
                }
                this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
            } else {
                Label internalTrueLabel = new Label(codeStream);
                this.left.generateOptimizedBoolean(currentScope, codeStream, internalTrueLabel, null, false);
                if (this.rightInitStateIndex != -1) {
                    codeStream.addDefinitelyAssignedVariables(currentScope, this.rightInitStateIndex);
                }
                internalTrueLabel.place();
                this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                if (valueRequired) {
                    if ((this.bits & 0x20) != 0) {
                        codeStream.iconst_0();
                    } else if (falseLabel != null) {
                        codeStream.goto_(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            return;
        }
        if (falseLabel == null) {
            if (trueLabel != null) {
                Label internalFalseLabel = new Label(codeStream);
                this.left.generateOptimizedBoolean(currentScope, codeStream, null, internalFalseLabel, true);
                if (this.rightInitStateIndex != -1) {
                    codeStream.addDefinitelyAssignedVariables(currentScope, this.rightInitStateIndex);
                }
                this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, null, valueRequired);
                internalFalseLabel.place();
            }
        } else if (trueLabel == null) {
            this.left.generateOptimizedBoolean(currentScope, codeStream, null, falseLabel, true);
            if (this.rightInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(currentScope, this.rightInitStateIndex);
            }
            this.right.generateOptimizedBoolean(currentScope, codeStream, null, falseLabel, valueRequired);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
    }

    public boolean isCompactableOperation() {
        return false;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

