/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class IfStatement
extends Statement {
    public Expression condition;
    public Statement thenStatement;
    public Statement elseStatement;
    boolean thenExit;
    int thenInitStateIndex = -1;
    int elseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public IfStatement(Expression condition, Statement thenStatement, int s, int e) {
        this.condition = condition;
        this.thenStatement = thenStatement;
        this.sourceStart = s;
        this.sourceEnd = e;
    }

    public IfStatement(Expression condition, Statement thenStatement, Statement elseStatement, int s, int e) {
        this.condition = condition;
        this.thenStatement = thenStatement;
        this.elseStatement = elseStatement;
        this.sourceEnd = e;
        this.sourceStart = s;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean elseExit;
        flowInfo = this.condition.analyseCode(currentScope, flowContext, flowInfo);
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != AstNode.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != AstNode.NotAConstant && !cst.booleanValue();
        FlowInfo thenFlowInfo = flowInfo.initsWhenTrue().copy();
        if (isConditionOptimizedFalse) {
            thenFlowInfo.setReachMode(1);
        }
        if (this.thenStatement != null) {
            this.thenInitStateIndex = currentScope.methodScope().recordInitializationStates(thenFlowInfo);
            if (!thenFlowInfo.complainIfUnreachable(this.thenStatement, currentScope, false)) {
                thenFlowInfo = this.thenStatement.analyseCode(currentScope, flowContext, thenFlowInfo);
            }
        }
        this.thenExit = !thenFlowInfo.isReachable();
        FlowInfo elseFlowInfo = flowInfo.initsWhenFalse().copy();
        if (isConditionOptimizedTrue) {
            elseFlowInfo.setReachMode(1);
        }
        if (this.elseStatement != null) {
            this.elseInitStateIndex = currentScope.methodScope().recordInitializationStates(elseFlowInfo);
            if (!elseFlowInfo.complainIfUnreachable(this.elseStatement, currentScope, false)) {
                elseFlowInfo = this.elseStatement.analyseCode(currentScope, flowContext, elseFlowInfo);
            }
        }
        boolean bl = elseExit = !elseFlowInfo.isReachable();
        FlowInfo mergedInfo = isConditionOptimizedTrue ? (!this.thenExit ? thenFlowInfo.addPotentialInitializationsFrom(elseFlowInfo) : elseFlowInfo.setReachMode(1)) : (isConditionOptimizedFalse ? (!elseExit ? elseFlowInfo.addPotentialInitializationsFrom(thenFlowInfo) : thenFlowInfo.setReachMode(1)) : thenFlowInfo.mergedWith(elseFlowInfo.unconditionalInits()));
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        boolean hasElsePart;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        Label endifLabel = new Label(codeStream);
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean hasThenPart = (cst == AstNode.NotAConstant || cst.booleanValue()) && this.thenStatement != null && !this.thenStatement.isEmptyBlock();
        boolean bl = hasElsePart = (cst == AstNode.NotAConstant || !cst.booleanValue()) && this.elseStatement != null && !this.elseStatement.isEmptyBlock();
        if (hasThenPart) {
            Label falseLabel = new Label(codeStream);
            this.condition.generateOptimizedBoolean(currentScope, codeStream, null, falseLabel, true);
            if (this.thenInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.thenInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.thenInitStateIndex);
            }
            this.thenStatement.generateCode(currentScope, codeStream);
            if (hasElsePart && !this.thenExit) {
                this.thenStatement.branchChainTo(endifLabel);
                int position = codeStream.position;
                codeStream.goto_(endifLabel);
                codeStream.updateLastRecordedEndPC(position);
            }
            falseLabel.place();
        } else if (hasElsePart) {
            this.condition.generateOptimizedBoolean(currentScope, codeStream, endifLabel, null, true);
        } else {
            this.condition.generateCode(currentScope, codeStream, false);
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        if (hasElsePart) {
            if (this.elseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.elseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.elseInitStateIndex);
            }
            this.elseStatement.generateCode(currentScope, codeStream);
        }
        endifLabel.place();
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resolve(BlockScope scope) {
        TypeBinding type = this.condition.resolveTypeExpecting(scope, BaseTypes.BooleanBinding);
        this.condition.implicitWidening(type, type);
        if (this.thenStatement != null) {
            this.thenStatement.resolve(scope);
        }
        if (this.elseStatement != null) {
            this.elseStatement.resolve(scope);
        }
    }

    public String toString(int tab) {
        String s;
        String inFront = s = AstNode.tabString(tab);
        s = String.valueOf(s) + "if (" + this.condition.toStringExpression() + ") \n";
        s = String.valueOf(s) + this.thenStatement.toString(tab + 2) + ";";
        if (this.elseStatement != null) {
            s = String.valueOf(s) + "\n" + inFront + "else\n" + this.elseStatement.toString(tab + 2) + ";";
        }
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.condition.traverse(visitor, blockScope);
            if (this.thenStatement != null) {
                this.thenStatement.traverse(visitor, blockScope);
            }
            if (this.elseStatement != null) {
                this.elseStatement.traverse(visitor, blockScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

