/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Break;
import org.eclipse.jdt.internal.compiler.ast.Case;
import org.eclipse.jdt.internal.compiler.ast.DefaultCase;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SwitchStatement
extends Statement {
    public Expression testExpression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public Label breakLabel;
    public Case[] cases;
    public DefaultCase defaultCase;
    public int caseCount = 0;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.testExpression.analyseCode(currentScope, flowContext, flowInfo);
        this.breakLabel = new Label();
        SwitchFlowContext switchContext = new SwitchFlowContext(flowContext, this, this.breakLabel);
        FlowInfo caseInits = FlowInfo.DEAD_END;
        this.preSwitchInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        int caseIndex = 0;
        if (this.statements != null) {
            boolean didAlreadyComplain = false;
            int i = 0;
            int max = this.statements.length;
            while (i < max) {
                Statement statement = this.statements[i];
                if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                    ++caseIndex;
                    caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.copy().unconditionalInits());
                    didAlreadyComplain = false;
                } else if (statement == this.defaultCase) {
                    caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.copy().unconditionalInits());
                    didAlreadyComplain = false;
                }
                if (!((FlowInfo)caseInits).complainIfUnreachable(statement, this.scope, didAlreadyComplain)) {
                    caseInits = statement.analyseCode(this.scope, switchContext, caseInits);
                } else {
                    didAlreadyComplain = true;
                }
                ++i;
            }
        }
        if (this.defaultCase == null) {
            flowInfo.addPotentialInitializationsFrom(((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak));
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
            return flowInfo;
        }
        UnconditionalFlowInfo mergedInfo = ((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        int[] sortedIndexes = new int[this.caseCount];
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.breakLabel.codeStream = codeStream;
        CaseLabel[] caseLabels = new CaseLabel[this.caseCount];
        int[] constants = new int[this.caseCount];
        boolean needSwitch = this.caseCount != 0;
        int i = 0;
        while (i < this.caseCount) {
            constants[i] = this.cases[i].constantExpression.constant.intValue();
            this.cases[i].targetLabel = caseLabels[i] = new CaseLabel(codeStream);
            ++i;
        }
        i = 0;
        while (i < this.caseCount) {
            sortedIndexes[i] = i;
            ++i;
        }
        int[] localKeysCopy = new int[this.caseCount];
        System.arraycopy(constants, 0, localKeysCopy, 0, this.caseCount);
        CodeStream.sort(localKeysCopy, 0, this.caseCount - 1, sortedIndexes);
        CaseLabel defaultLabel = new CaseLabel(codeStream);
        if (this.defaultCase != null) {
            this.defaultCase.targetLabel = defaultLabel;
        }
        this.testExpression.generateCode(currentScope, codeStream, needSwitch);
        if (needSwitch) {
            int max = localKeysCopy[this.caseCount - 1];
            int min = localKeysCopy[0];
            if ((long)((double)this.caseCount * 2.5) > (long)max - (long)min) {
                if (max > 0x7FFF0000 && currentScope.environment().options.complianceLevel < 3) {
                    codeStream.lookupswitch(defaultLabel, constants, sortedIndexes, caseLabels);
                } else {
                    codeStream.tableswitch(defaultLabel, min, max, constants, sortedIndexes, caseLabels);
                }
            } else {
                codeStream.lookupswitch(defaultLabel, constants, sortedIndexes, caseLabels);
            }
            codeStream.updateLastRecordedEndPC(codeStream.position);
        }
        int caseIndex = 0;
        if (this.statements != null) {
            int i2 = 0;
            int maxCases = this.statements.length;
            while (i2 < maxCases) {
                Statement statement = this.statements[i2];
                if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                    if (this.preSwitchInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        ++caseIndex;
                    }
                } else if (statement == this.defaultCase && this.preSwitchInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                }
                statement.generateCode(this.scope, codeStream);
                ++i2;
            }
        }
        this.breakLabel.place();
        if (this.defaultCase == null) {
            defaultLabel.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        if (this.scope != currentScope) {
            codeStream.exitUserScope(this.scope);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resetStateForCodeGeneration() {
        if (this.breakLabel != null) {
            this.breakLabel.resetStateForCodeGeneration();
        }
    }

    public void resolve(BlockScope upperScope) {
        TypeBinding testType = this.testExpression.resolveType(upperScope);
        if (testType == null) {
            return;
        }
        this.testExpression.implicitWidening(testType, testType);
        if (!this.testExpression.isConstantValueOfTypeAssignableToType(testType, BaseTypes.IntBinding) && !testType.isCompatibleWith(BaseTypes.IntBinding)) {
            upperScope.problemReporter().incorrectSwitchType(this.testExpression, testType);
            return;
        }
        if (this.statements != null) {
            this.scope = this.explicitDeclarations == 0 ? upperScope : new BlockScope(upperScope);
            int length = this.statements.length;
            this.cases = new Case[length];
            int[] casesValues = new int[length];
            int counter = 0;
            int i = 0;
            while (i < length) {
                Constant cst = this.statements[i].resolveCase(this.scope, testType, this);
                if (cst != null && cst != AstNode.NotAConstant) {
                    int key = cst.intValue();
                    int j = 0;
                    while (j < counter) {
                        if (casesValues[j] == key) {
                            this.scope.problemReporter().duplicateCase((Case)this.statements[i], cst);
                        }
                        ++j;
                    }
                    casesValues[counter++] = key;
                }
                ++i;
            }
        }
    }

    public String toString(int tab) {
        String s;
        String inFront = s = AstNode.tabString(tab);
        s = String.valueOf(s) + "switch (" + this.testExpression.toStringExpression() + ") ";
        if (this.statements == null) {
            s = String.valueOf(s) + "{}";
            return s;
        }
        s = String.valueOf(s) + "{";
        s = String.valueOf(s) + (this.explicitDeclarations != 0 ? "// ---scope needed for " + String.valueOf(this.explicitDeclarations) + " locals------------ \n" : "// ---NO scope needed------ \n");
        int i = 0;
        String tabulation = "  ";
        try {
            block2: while (true) {
                if (this.statements[i] instanceof Expression) {
                    s = String.valueOf(s) + "\n" + inFront + tabulation;
                }
                s = this.statements[i] instanceof Break ? String.valueOf(s) + this.statements[i].toString(0) : String.valueOf(s) + "\n" + this.statements[i].toString(tab + 2);
                if (this.statements[i] instanceof Case || this.statements[i] instanceof DefaultCase) {
                    ++i;
                    while (true) {
                        if (this.statements[i] instanceof Case || this.statements[i] instanceof DefaultCase) continue block2;
                        s = this.statements[i] instanceof Expression || this.statements[i] instanceof Break ? String.valueOf(s) + this.statements[i].toString(0) + " ; " : String.valueOf(s) + "\n" + this.statements[i].toString(tab + 6) + " ; ";
                        ++i;
                    }
                }
                s = String.valueOf(s) + " ;";
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            s = String.valueOf(s) + "}";
            return s;
        }
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.testExpression.traverse(visitor, this.scope);
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public void branchChainTo(Label label) {
        if (this.breakLabel.hasForwardReferences()) {
            label.appendForwardReferencesFrom(this.breakLabel);
        }
    }
}

