/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.MemberElementInfo;
import org.eclipse.jdt.internal.core.SourceRange;
import org.eclipse.jdt.internal.core.SourceRefElement;

abstract class Member
extends SourceRefElement
implements IMember {
    protected Member(int type, IJavaElement parent, String name) {
        super(type, parent, name);
    }

    protected boolean areSimilarMethods(String name1, String[] params1, String name2, String[] params2, String[] simpleNames1) {
        int params1Length;
        if (name1.equals(name2) && (params1Length = params1.length) == params2.length) {
            int i = 0;
            while (i < params1Length) {
                String simpleName2;
                String simpleName1 = simpleNames1 == null ? Signature.getSimpleName(Signature.toString(params1[i])) : simpleNames1[i];
                if (!simpleName1.equals(simpleName2 = Signature.getSimpleName(Signature.toString(params2[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected static Object convertConstant(Constant constant) {
        if (constant == null) {
            return null;
        }
        if (constant == Constant.NotAConstant) {
            return null;
        }
        switch (constant.typeID()) {
            case 5: {
                return constant.booleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return new Byte(constant.byteValue());
            }
            case 2: {
                return new Character(constant.charValue());
            }
            case 8: {
                return new Double(constant.doubleValue());
            }
            case 9: {
                return new Float(constant.floatValue());
            }
            case 10: {
                return new Integer(constant.intValue());
            }
            case 7: {
                return new Long(constant.longValue());
            }
            case 4: {
                return new Short(constant.shortValue());
            }
            case 11: {
                return constant.stringValue();
            }
        }
        return null;
    }

    protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
        return this.getElementName().equals(node.getName());
    }

    protected IMethod[] findMethods(IMethod method, IMethod[] methods) {
        String elementName = method.getElementName();
        String[] parameters = method.getParameterTypes();
        int paramLength = parameters.length;
        String[] simpleNames = new String[paramLength];
        int i = 0;
        while (i < paramLength) {
            simpleNames[i] = Signature.getSimpleName(Signature.toString(parameters[i]));
            ++i;
        }
        ArrayList<IMethod> list = new ArrayList<IMethod>();
        int i2 = 0;
        int length = methods.length;
        while (i2 < length) {
            IMethod existingMethod = methods[i2];
            if (this.areSimilarMethods(elementName, parameters, existingMethod.getElementName(), existingMethod.getParameterTypes(), simpleNames)) {
                list.add(existingMethod);
            }
            ++i2;
        }
        int size = list.size();
        if (size == 0) {
            return null;
        }
        IMethod[] result = new IMethod[size];
        list.toArray(result);
        return result;
    }

    public IClassFile getClassFile() {
        return ((JavaElement)this.getParent()).getClassFile();
    }

    public IType getDeclaringType() {
        JavaElement parent = (JavaElement)this.getParent();
        if (parent.fLEType == 7) {
            return (IType)((Object)parent);
        }
        return null;
    }

    public int getFlags() throws JavaModelException {
        MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
        return info.getModifiers();
    }

    protected char getHandleMementoDelimiter() {
        return '[';
    }

    public ISourceRange getNameRange() throws JavaModelException {
        MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
        return new SourceRange(info.getNameSourceStart(), info.getNameSourceEnd() - info.getNameSourceStart() + 1);
    }

    public boolean isBinary() {
        return false;
    }

    protected boolean isMainMethod(IMethod method) throws JavaModelException {
        String[] paramTypes;
        int flags;
        if ("main".equals(method.getElementName()) && "V".equals(method.getReturnType()) && Flags.isStatic(flags = method.getFlags()) && Flags.isPublic(flags) && (paramTypes = method.getParameterTypes()).length == 1) {
            String name = Signature.toString(paramTypes[0]);
            return "String[]".equals(Signature.getSimpleName(name));
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.getClassFile() != null;
    }

    public String readableName() {
        IType declaringType = this.getDeclaringType();
        if (declaringType != null) {
            String declaringName = ((JavaElement)((Object)this.getDeclaringType())).readableName();
            StringBuffer buffer = new StringBuffer(declaringName);
            buffer.append('.');
            buffer.append(this.getElementName());
            return buffer.toString();
        }
        return super.readableName();
    }

    protected void updateNameRange(int nameStart, int nameEnd) {
        try {
            MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
            info.setNameSourceStart(nameStart);
            info.setNameSourceEnd(nameEnd);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }
}

