/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.WorkingCopy;

public class SelectionRequestor
implements ISelectionRequestor {
    protected NameLookup fNameLookup = null;
    protected IJavaElement fCodeResolve;
    protected IJavaElement[] fElements = fgEmptyElements;
    protected static IJavaElement[] fgEmptyElements = new IJavaElement[0];

    public SelectionRequestor(NameLookup nameLookup, IJavaElement codeResolve) {
        this.fNameLookup = nameLookup;
        this.fCodeResolve = codeResolve;
    }

    protected void acceptBinaryMethod(IType type, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames) {
        IMethod method;
        String[] parameterTypes = null;
        if (parameterTypeNames != null) {
            parameterTypes = new String[parameterTypeNames.length];
            int i = 0;
            int max = parameterTypeNames.length;
            while (i < max) {
                String typeName;
                String pkg = "";
                if (parameterPackageNames[i] != null && parameterPackageNames[i].length > 0) {
                    pkg = String.valueOf(new String(parameterPackageNames[i])) + ".";
                }
                if ((typeName = new String(parameterTypeNames[i])).indexOf(46) > 0) {
                    typeName = typeName.replace('.', '$');
                }
                parameterTypes[i] = Signature.createTypeSignature(String.valueOf(pkg) + typeName, true);
                ++i;
            }
        }
        if ((method = type.getMethod(new String(selector), parameterTypes)).exists()) {
            this.fElements = this.growAndAddToArray(this.fElements, method);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept method(");
                System.out.print(method.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptClass(char[] packageName, char[] className, boolean needQualification) {
        this.acceptType(packageName, className, 2, needQualification);
    }

    public void acceptError(IProblem error) {
    }

    public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name) {
        IField field;
        IType type = this.resolveType(declaringTypePackageName, declaringTypeName, 6);
        if (type != null && (field = type.getField(new String(name))).exists()) {
            this.fElements = this.growAndAddToArray(this.fElements, field);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept field(");
                System.out.print(field.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, boolean needQualification) {
        this.acceptType(packageName, interfaceName, 4, needQualification);
    }

    public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, boolean isConstructor) {
        IType type = this.resolveType(declaringTypePackageName, declaringTypeName, 6);
        if (type != null) {
            if (type.isBinary()) {
                IType declaringDeclaringType = type.getDeclaringType();
                boolean isStatic = false;
                try {
                    isStatic = Flags.isStatic(type.getFlags());
                }
                catch (JavaModelException javaModelException) {}
                if (declaringDeclaringType != null && isConstructor && !isStatic) {
                    int length = parameterPackageNames.length;
                    char[][] cArray = parameterPackageNames;
                    parameterPackageNames = new char[length + 1][];
                    System.arraycopy(cArray, 0, parameterPackageNames, 1, length);
                    char[][] cArray2 = parameterTypeNames;
                    parameterTypeNames = new char[length + 1][];
                    System.arraycopy(cArray2, 0, parameterTypeNames, 1, length);
                    parameterPackageNames[0] = declaringDeclaringType.getPackageFragment().getElementName().toCharArray();
                    parameterTypeNames[0] = declaringDeclaringType.getTypeQualifiedName().toCharArray();
                }
                this.acceptBinaryMethod(type, selector, parameterPackageNames, parameterTypeNames);
            } else {
                this.acceptSourceMethod(type, selector, parameterPackageNames, parameterTypeNames);
            }
        }
    }

    public void acceptPackage(char[] packageName) {
        IPackageFragment[] pkgs = this.fNameLookup.findPackageFragments(new String(packageName), false);
        if (pkgs != null) {
            int i = 0;
            int length = pkgs.length;
            while (i < length) {
                this.fElements = this.growAndAddToArray(this.fElements, pkgs[i]);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept package(");
                    System.out.print(pkgs[i].toString());
                    System.out.println(")");
                }
                ++i;
            }
        }
    }

    protected void acceptSourceMethod(IType type, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames) {
        int i;
        String name = new String(selector);
        IMethod[] methods = null;
        IJavaElement[] matches = new IJavaElement[]{};
        try {
            methods = type.getMethods();
            i = 0;
            while (i < methods.length) {
                if (methods[i].getElementName().equals(name) && methods[i].getParameterTypes().length == parameterTypeNames.length) {
                    matches = this.growAndAddToArray(matches, methods[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        if (matches.length == 0) {
            this.fElements = this.growAndAddToArray(this.fElements, type);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(type.toString());
                System.out.println(")");
            }
            return;
        }
        if (matches.length == 1) {
            this.fElements = this.growAndAddToArray(this.fElements, matches[0]);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept method(");
                System.out.print(matches[0].toString());
                System.out.println(")");
            }
            return;
        }
        i = 0;
        while (i < matches.length) {
            IMethod method = (IMethod)matches[i];
            String[] signatures = method.getParameterTypes();
            boolean match = true;
            int p = 0;
            while (p < signatures.length) {
                char[] simpleParameterName;
                String simpleName = Signature.getSimpleName(Signature.toString(signatures[p]));
                if (!simpleName.equals(new String(simpleParameterName = CharOperation.lastSegment(parameterTypeNames[p], '.')))) {
                    match = false;
                    break;
                }
                ++p;
            }
            if (match) {
                this.fElements = this.growAndAddToArray(this.fElements, method);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(method.toString());
                    System.out.println(")");
                }
            }
            ++i;
        }
    }

    protected void acceptType(char[] packageName, char[] typeName, int acceptFlags, boolean needQualification) {
        IType type = this.resolveType(packageName, typeName, acceptFlags);
        if (type != null) {
            this.fElements = this.growAndAddToArray(this.fElements, type);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(type.toString());
                System.out.println(")");
            }
        }
    }

    public IJavaElement[] getElements() {
        return this.fElements;
    }

    protected IJavaElement[] growAndAddToArray(IJavaElement[] array, IJavaElement addition) {
        IJavaElement[] old = array;
        array = new IJavaElement[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected IType resolveType(char[] packageName, char[] typeName, int acceptFlags) {
        IJavaElement type = null;
        if (this.fCodeResolve instanceof WorkingCopy) {
            WorkingCopy wc = (WorkingCopy)this.fCodeResolve;
            try {
                if ((packageName == null || packageName.length == 0) && wc.getPackageDeclarations().length == 0 || packageName != null && packageName.length != 0 && wc.getPackageDeclaration(new String(packageName)).exists()) {
                    char[][] compoundName = CharOperation.splitOn('.', typeName);
                    if (compoundName.length > 0) {
                        type = wc.getType(new String(compoundName[0]));
                        int i = 1;
                        int length = compoundName.length;
                        while (i < length) {
                            type = type.getType(new String(compoundName[i]));
                            ++i;
                        }
                    }
                    if (type != null && !type.exists()) {
                        type = null;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                type = null;
            }
        }
        if (type == null) {
            IPackageFragment[] pkgs = this.fNameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
            int i = 0;
            int length = pkgs == null ? 0 : pkgs.length;
            while (i < length) {
                type = this.fNameLookup.findType(new String(typeName), pkgs[i], false, acceptFlags);
                if (type != null) break;
                ++i;
            }
            if (type == null) {
                String pName = "";
                if (packageName != null) {
                    pName = new String(packageName);
                }
                if (this.fCodeResolve != null && this.fCodeResolve.getParent().getElementName().equals(pName)) {
                    String tName = new String(typeName);
                    tName = tName.replace('.', '$');
                    IType[] allTypes = null;
                    try {
                        ArrayList list = ((JavaElement)this.fCodeResolve).getChildrenOfType(7);
                        allTypes = new IType[list.size()];
                        list.toArray(allTypes);
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                    int i2 = 0;
                    while (i2 < allTypes.length) {
                        if (allTypes[i2].getTypeQualifiedName().equals(tName)) {
                            return allTypes[i2];
                        }
                        ++i2;
                    }
                }
            }
        }
        return type;
    }
}

