/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.ImageBuilderInternalException;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.MissingClassFileException;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.WorkQueue;

public abstract class AbstractImageBuilder
implements ICompilerRequestor {
    protected JavaBuilder javaBuilder;
    protected State newState;
    protected NameEnvironment nameEnvironment;
    protected ClasspathMultiDirectory[] sourceLocations;
    protected BuildNotifier notifier;
    protected String encoding;
    protected Compiler compiler;
    protected WorkQueue workQueue;
    protected ArrayList problemSourceFiles;
    protected boolean compiledAllAtOnce;
    private boolean inCompiler;
    public static int MAX_AT_ONCE = 1000;

    protected AbstractImageBuilder(JavaBuilder javaBuilder) {
        this.javaBuilder = javaBuilder;
        this.newState = new State(javaBuilder);
        this.nameEnvironment = javaBuilder.nameEnvironment;
        this.sourceLocations = this.nameEnvironment.sourceLocations;
        this.notifier = javaBuilder.notifier;
        this.encoding = javaBuilder.javaProject.getOption("org.eclipse.jdt.core.encoding", true);
        this.compiler = this.newCompiler();
        this.workQueue = new WorkQueue();
        this.problemSourceFiles = new ArrayList(3);
    }

    /*
     * Unable to fully structure code
     */
    public void acceptResult(CompilationResult result) {
        block6: {
            compilationUnit = (SourceFile)result.getCompilationUnit();
            if (this.workQueue.isCompiled(compilationUnit)) break block6;
            try {
                this.workQueue.finished(compilationUnit);
                this.updateProblemsFor(compilationUnit, result);
                this.updateTasksFor(compilationUnit, result);
                typeLocator = compilationUnit.typeLocator();
                classFiles = result.getClassFiles();
                length = classFiles.length;
                duplicateTypeNames = null;
                definedTypeNames = new ArrayList<char[]>(length);
                i = 0;
                while (i < length) {
                    block8: {
                        block7: {
                            classFile = classFiles[i];
                            compoundName = classFile.getCompoundName();
                            typeName = compoundName[compoundName.length - 1];
                            isNestedType = CharOperation.contains('$', typeName);
                            if (!isNestedType) break block7;
                            qualifiedTypeName = new String(classFile.outerMostEnclosingClassFile().fileName());
                            if (!this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) ** GOTO lbl32
                            break block8;
                        }
                        qualifiedTypeName = new String(classFile.fileName());
                        if (this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) {
                            if (duplicateTypeNames == null) {
                                duplicateTypeNames = new ArrayList<char[][]>();
                            }
                            duplicateTypeNames.add(compoundName);
                            this.createErrorFor((IResource)compilationUnit.resource, Util.bind("build.duplicateClassFile", new String(typeName)));
                        } else {
                            this.newState.recordLocatorForType(qualifiedTypeName, typeLocator);
lbl32:
                            // 2 sources

                            definedTypeNames.add(this.writeClassFile(classFile, compilationUnit.sourceLocation.binaryFolder, isNestedType == false));
                        }
                    }
                    ++i;
                }
                this.finishedWith(typeLocator, result, compilationUnit.getMainTypeName(), definedTypeNames, duplicateTypeNames);
                this.notifier.compiled(compilationUnit);
            }
            catch (CoreException e) {
                Util.log(e, "JavaBuilder handling CoreException");
                this.createErrorFor((IResource)compilationUnit.resource, Util.bind("build.inconsistentClassFile"));
            }
        }
    }

    protected void cleanUp() {
        this.nameEnvironment.cleanup();
        this.javaBuilder = null;
        this.nameEnvironment = null;
        this.sourceLocations = null;
        this.notifier = null;
        this.compiler = null;
        this.workQueue = null;
        this.problemSourceFiles = null;
    }

    protected void compile(SourceFile[] units) {
        int toDo = units.length;
        this.compiledAllAtOnce = toDo <= MAX_AT_ONCE;
        if (this.compiledAllAtOnce) {
            if (JavaBuilder.DEBUG) {
                int i = 0;
                while (i < toDo) {
                    System.out.println("About to compile " + units[i].typeLocator());
                    ++i;
                }
            }
            this.compile(units, null);
        } else {
            int i = 0;
            boolean compilingFirstGroup = true;
            while (i < toDo) {
                int doNow = toDo < MAX_AT_ONCE ? toDo : MAX_AT_ONCE;
                int index = 0;
                SourceFile[] toCompile = new SourceFile[doNow];
                while (i < toDo && index < doNow) {
                    SourceFile unit = units[i++];
                    if (!compilingFirstGroup && !this.workQueue.isWaiting(unit)) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("About to compile " + unit.typeLocator());
                    }
                    toCompile[index++] = unit;
                }
                if (index < doNow) {
                    SourceFile[] sourceFileArray = toCompile;
                    toCompile = new SourceFile[index];
                    System.arraycopy(sourceFileArray, 0, toCompile, 0, index);
                }
                SourceFile[] additionalUnits = new SourceFile[toDo - i];
                System.arraycopy(units, i, additionalUnits, 0, additionalUnits.length);
                compilingFirstGroup = false;
                this.compile(toCompile, additionalUnits);
            }
        }
    }

    void compile(SourceFile[] units, SourceFile[] additionalUnits) {
        if (units.length == 0) {
            return;
        }
        this.notifier.aboutToCompile(units[0]);
        if (!this.problemSourceFiles.isEmpty()) {
            int length;
            int toAdd = this.problemSourceFiles.size();
            int n = length = additionalUnits == null ? 0 : additionalUnits.length;
            if (length == 0) {
                additionalUnits = new SourceFile[toAdd];
            } else {
                SourceFile[] sourceFileArray = additionalUnits;
                additionalUnits = new SourceFile[length + toAdd];
                System.arraycopy(sourceFileArray, 0, additionalUnits, 0, length);
            }
            int i = 0;
            while (i < toAdd) {
                additionalUnits[length + i] = (SourceFile)this.problemSourceFiles.get(i);
                ++i;
            }
        }
        String[] initialTypeNames = new String[units.length];
        int i = 0;
        int l = units.length;
        while (i < l) {
            initialTypeNames[i] = units[i].initialTypeName;
            ++i;
        }
        this.nameEnvironment.setNames(initialTypeNames, additionalUnits);
        this.notifier.checkCancel();
        try {
            try {
                this.inCompiler = true;
                this.compiler.compile(units);
            }
            catch (AbortCompilation abortCompilation) {}
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.inCompiler = false;
            throw throwable;
        }
        Object var4_7 = null;
        this.inCompiler = false;
        this.notifier.checkCancel();
    }

    protected void createErrorFor(IResource resource, String message) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.jdt.core.problem");
            int severity = 2;
            if (message.equals(Util.bind("build.duplicateResource")) && "warning".equals(this.javaBuilder.javaProject.getOption("org.eclipse.jdt.core.builder.duplicateResourceTask", true))) {
                severity = 1;
            }
            marker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd"}, new Object[]{message, new Integer(severity), new Integer(0), new Integer(1)});
        }
        catch (CoreException e) {
            throw this.internalException(e);
        }
    }

    protected void finishedWith(String sourceLocator, CompilationResult result, char[] mainTypeName, ArrayList definedTypeNames, ArrayList duplicateTypeNames) throws CoreException {
        if (duplicateTypeNames == null) {
            this.newState.record(sourceLocator, result.qualifiedReferences, result.simpleNameReferences, mainTypeName, definedTypeNames);
            return;
        }
        char[][][] qualifiedRefs = result.qualifiedReferences;
        char[][] simpleRefs = result.simpleNameReferences;
        int i = 0;
        int l = duplicateTypeNames.size();
        while (i < l) {
            block4: {
                char[][] compoundName = (char[][])duplicateTypeNames.get(i);
                char[] typeName = compoundName[compoundName.length - 1];
                int sLength = simpleRefs.length;
                int j = 0;
                while (j < sLength) {
                    if (!CharOperation.equals(simpleRefs[j], typeName)) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                char[][] cArray = simpleRefs;
                simpleRefs = new char[sLength + 1][];
                System.arraycopy(cArray, 0, simpleRefs, 0, sLength);
                simpleRefs[sLength] = typeName;
            }
            ++i;
        }
        this.newState.record(sourceLocator, qualifiedRefs, simpleRefs, mainTypeName, definedTypeNames);
    }

    protected IContainer createFolder(IPath packagePath, IContainer outputFolder) throws CoreException {
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder);
            folder.create(true, true, null);
            folder.setDerived(true);
        }
        return folder;
    }

    protected RuntimeException internalException(CoreException t) {
        ImageBuilderInternalException imageBuilderException = new ImageBuilderInternalException(t);
        if (this.inCompiler) {
            return new AbortCompilation(true, imageBuilderException);
        }
        return imageBuilderException;
    }

    protected Compiler newCompiler() {
        return new Compiler(this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.javaBuilder.javaProject.getOptions(true), this, ProblemFactory.getProblemFactory(Locale.getDefault()));
    }

    protected boolean isExcludedFromProject(IPath childPath) throws JavaModelException {
        if (childPath.segmentCount() > 2) {
            return false;
        }
        int j = 0;
        int k = this.sourceLocations.length;
        while (j < k) {
            if (childPath.equals((Object)this.sourceLocations[j].binaryFolder.getFullPath())) {
                return true;
            }
            if (childPath.equals((Object)this.sourceLocations[j].sourceFolder.getFullPath())) {
                return true;
            }
            ++j;
        }
        return childPath.equals((Object)this.javaBuilder.javaProject.getOutputLocation());
    }

    protected void storeProblemsFor(SourceFile sourceFile, IProblem[] problems) throws CoreException {
        if (sourceFile == null || problems == null || problems.length == 0) {
            return;
        }
        String missingClassFile = null;
        IFile resource = sourceFile.resource;
        int i = 0;
        int l = problems.length;
        while (i < l) {
            IProblem problem = problems[i];
            int id = problem.getID();
            switch (id) {
                case 0x1000144: {
                    JavaBuilder.removeProblemsAndTasksFor((IResource)this.javaBuilder.currentProject);
                    String[] args = problem.getArguments();
                    missingClassFile = args[0];
                    break;
                }
                case 16777528: 
                case 16777531: 
                case 16777532: 
                case 16777533: 
                case 16777543: 
                case 16777546: 
                case 16777547: 
                case 16777548: 
                case 16777549: 
                case 16777550: 
                case 16777551: 
                case 0x1000150: 
                case 0x1000151: 
                case 16777554: 
                case 16777555: {
                    if (this.problemSourceFiles.contains(sourceFile)) break;
                    this.problemSourceFiles.add(sourceFile);
                }
            }
            if (id != 536871362) {
                IMarker marker = resource.createMarker("org.eclipse.jdt.core.problem");
                marker.setAttributes(new String[]{"message", "severity", "id", "charStart", "charEnd", "lineNumber", "arguments"}, new Object[]{problem.getMessage(), new Integer(problem.isError() ? 2 : 1), new Integer(id), new Integer(problem.getSourceStart()), new Integer(problem.getSourceEnd() + 1), new Integer(problem.getSourceLineNumber()), Util.getProblemArgumentsForMarker(problem.getArguments())});
            }
            if (missingClassFile != null) {
                throw new MissingClassFileException(missingClassFile);
            }
            ++i;
        }
    }

    protected void storeTasksFor(SourceFile sourceFile, IProblem[] tasks) throws CoreException {
        if (sourceFile == null || tasks == null || tasks.length == 0) {
            return;
        }
        IFile resource = sourceFile.resource;
        int i = 0;
        int l = tasks.length;
        while (i < l) {
            IProblem task = tasks[i];
            if (task.getID() == 536871362) {
                IMarker marker = resource.createMarker("org.eclipse.jdt.core.task");
                int priority = 1;
                String compilerPriority = task.getArguments()[2];
                if ("HIGH".equals(compilerPriority)) {
                    priority = 2;
                } else if ("LOW".equals(compilerPriority)) {
                    priority = 0;
                }
                marker.setAttributes(new String[]{"message", "priority", "done", "charStart", "charEnd", "lineNumber", "userEditable"}, new Object[]{task.getMessage(), new Integer(priority), new Boolean(false), new Integer(task.getSourceStart()), new Integer(task.getSourceEnd() + 1), new Integer(task.getSourceLineNumber()), new Boolean(false)});
            }
            ++i;
        }
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IProblem[] problems = result.getProblems();
        if (problems == null || problems.length == 0) {
            return;
        }
        this.notifier.updateProblemCounts(problems);
        this.storeProblemsFor(sourceFile, problems);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IProblem[] tasks = result.getTasks();
        if (tasks == null || tasks.length == 0) {
            return;
        }
        this.storeTasksFor(sourceFile, tasks);
    }

    protected char[] writeClassFile(ClassFile classFile, IContainer outputFolder, boolean isSecondaryType) throws CoreException {
        String fileName = new String(classFile.fileName());
        Path filePath = new Path(fileName);
        IContainer container = outputFolder;
        if (filePath.segmentCount() > 1) {
            container = this.createFolder(filePath.removeLastSegments(1), outputFolder);
            filePath = new Path(filePath.lastSegment());
        }
        IFile file = container.getFile(filePath.addFileExtension("class"));
        this.writeClassFileBytes(classFile.getBytes(), file, fileName, isSecondaryType);
        return filePath.lastSegment().toCharArray();
    }

    protected void writeClassFileBytes(byte[] bytes, IFile file, String qualifiedFileName, boolean isSecondaryType) throws CoreException {
        if (file.exists()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing changed class file " + file.getName());
            }
            file.setContents((InputStream)new ByteArrayInputStream(bytes), true, false, null);
            if (!file.isDerived()) {
                file.setDerived(true);
            }
        } else {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing new class file " + file.getName());
            }
            file.create((InputStream)new ByteArrayInputStream(bytes), 1, null);
            file.setDerived(true);
        }
    }
}

