/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.index.impl.PropertyDocument;

public class IFileDocument
extends PropertyDocument {
    protected IFile file;
    protected char[] charContents;
    protected byte[] byteContents;

    public IFileDocument(IFile file) {
        this(file, (char[])null);
    }

    public IFileDocument(IFile file, byte[] byteContents) {
        this.file = file;
        this.byteContents = byteContents;
    }

    public IFileDocument(IFile file, char[] charContents) {
        this.file = file;
        this.charContents = charContents;
    }

    public byte[] getByteContent() throws IOException {
        if (this.byteContents != null) {
            return this.byteContents;
        }
        IPath location = this.file.getLocation();
        if (location == null) {
            return new byte[0];
        }
        this.byteContents = Util.getFileByteContent(location.toFile());
        return this.byteContents;
    }

    public char[] getCharContent() throws IOException {
        if (this.charContents != null) {
            return this.charContents;
        }
        IPath location = this.file.getLocation();
        if (location == null) {
            return CharOperation.NO_CHAR;
        }
        this.charContents = Util.getFileCharContent(location.toFile(), this.getEncoding());
        return this.charContents;
    }

    public String getEncoding() {
        return JavaCore.create(this.file.getProject()).getOption("org.eclipse.jdt.core.encoding", true);
    }

    public String getName() {
        return this.file.getFullPath().toString();
    }

    public String getStringContent() throws IOException {
        return new String(this.getCharContent());
    }

    public String getType() {
        String extension = this.file.getFileExtension();
        if (extension == null) {
            return "";
        }
        return extension;
    }
}

