/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.components.flow.AbstractInterpreter;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public abstract class CompilingInterpreter
extends AbstractInterpreter {
    protected SourceResolver sourceresolver;
    protected Map compiledScripts = new HashMap();

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        this.sourceresolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        if (this.compiledScripts != null) {
            Iterator iter = this.compiledScripts.values().iterator();
            while (iter.hasNext()) {
                ScriptSourceEntry current = (ScriptSourceEntry)iter.next();
                this.sourceresolver.release(current.getSource());
            }
            this.compiledScripts = null;
        }
        if (this.manager != null) {
            this.manager.release((Component)this.sourceresolver);
            this.sourceresolver = null;
        }
        super.dispose();
    }

    protected abstract Script compileScript(Context var1, Scriptable var2, Source var3) throws Exception;

    protected class ScriptSourceEntry {
        private final Source source;
        private Script script;
        private long compileTime;

        public ScriptSourceEntry(Source source) {
            this.source = source;
        }

        public ScriptSourceEntry(Source source, Script script, long t) {
            this.source = source;
            this.script = script;
            this.compileTime = t;
        }

        public Source getSource() {
            return this.source;
        }

        public Script getScript(Context context, Scriptable scope, boolean refresh, CompilingInterpreter interpreter) throws Exception {
            if (refresh) {
                this.source.refresh();
            }
            if (this.script == null || this.compileTime < this.source.getLastModified()) {
                this.script = interpreter.compileScript(context, scope, this.source);
                this.compileTime = this.source.getLastModified();
            }
            return this.script;
        }
    }
}

