/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class InputHandler {
    public abstract InputSource getInputSource();

    public abstract XMLReader getParser() throws FOPException;

    public abstract void run(Driver var1) throws FOPException;

    public static InputSource urlInputSource(URL url) {
        return new InputSource(url.toString());
    }

    public static InputSource fileInputSource(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return new InputSource(new URL("file", null, path).toString());
        }
        catch (MalformedURLException e) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    protected static XMLReader createParser() throws FOPException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            MessageHandler.logln("Using " + xmlReader.getClass().getName() + " as SAX2 Parser");
            return xmlReader;
        }
        catch (ParserConfigurationException e) {
            throw new FOPException(e);
        }
        catch (SAXException e) {
            throw new FOPException(e);
        }
    }
}

