/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDNode;
import org.apache.fop.layout.Area;
import org.apache.fop.pdf.PDFGoTo;

public class IDReferences {
    private HashMap idReferences = new HashMap();
    private HashMap idValidation = new HashMap();
    private HashMap idUnvalidated = new HashMap();
    static final int ID_PADDING = 5000;

    public void initializeID(String id, Area area) throws FOPException {
        this.createID(id);
        this.configureID(id, area);
    }

    public void createID(String id) throws FOPException {
        if (id != null && !id.equals("")) {
            if (this.doesUnvalidatedIDExist(id)) {
                this.removeFromUnvalidatedIDList(id);
                this.removeFromIdValidationList(id);
            } else {
                if (this.doesIDExist(id)) {
                    throw new FOPException("The id \"" + id + "\" already exists in this document");
                }
                this.createNewId(id);
                this.removeFromIdValidationList(id);
            }
        }
    }

    public void createUnvalidatedID(String id) {
        if (id != null && !id.equals("") && !this.doesIDExist(id)) {
            this.createNewId(id);
            this.addToUnvalidatedIdList(id);
        }
    }

    public void addToUnvalidatedIdList(String id) {
        this.idUnvalidated.put(id, "");
    }

    public void removeFromUnvalidatedIDList(String id) {
        this.idUnvalidated.remove(id);
    }

    public boolean doesUnvalidatedIDExist(String id) {
        return this.idUnvalidated.containsKey(id);
    }

    public void configureID(String id, Area area) {
        if (id != null && !id.equals("")) {
            this.setPosition(id, area.getPage().getBody().getXPosition() + area.getTableCellXOffset() - 5000, area.getPage().getBody().getYPosition() - area.getAbsoluteHeight() + 5000);
            this.setPageNumber(id, area.getPage().getFormattedNumber());
            area.getPage().addToIDList(id);
        }
    }

    public void addToIdValidationList(String id) {
        this.idValidation.put(id, "");
    }

    public void removeFromIdValidationList(String id) {
        this.idValidation.remove(id);
    }

    public void removeID(String id) {
        this.idReferences.remove(id);
    }

    public boolean isEveryIdValid() {
        return this.idValidation.size() == 0;
    }

    public String getInvalidIds() {
        StringBuffer list = new StringBuffer();
        Iterator iterator = this.idValidation.keySet().iterator();
        while (iterator.hasNext()) {
            list.append("\n\"").append(iterator.next().toString()).append("\" ");
        }
        return list.toString();
    }

    public boolean doesIDExist(String id) {
        return this.idReferences.containsKey(id);
    }

    public boolean doesGoToReferenceExist(String id) {
        IDNode node = (IDNode)this.idReferences.get(id);
        return node.isThereInternalLinkGoTo();
    }

    public String getInternalLinkGoToReference(String id) {
        IDNode node = (IDNode)this.idReferences.get(id);
        return node.getInternalLinkGoToReference();
    }

    public String createInternalLinkGoTo(String id, int objectNumber) {
        IDNode node = (IDNode)this.idReferences.get(id);
        node.createInternalLinkGoTo(objectNumber);
        return node.getInternalLinkGoToReference();
    }

    public void createNewId(String id) {
        IDNode node = new IDNode(id);
        this.idReferences.put(id, node);
    }

    public PDFGoTo getPDFGoTo(String id) {
        IDNode node = (IDNode)this.idReferences.get(id);
        return node.getInternalLinkGoTo();
    }

    public void setInternalGoToPageReference(String id, String pageReference) {
        IDNode node = (IDNode)this.idReferences.get(id);
        if (node != null) {
            node.setInternalLinkGoToPageReference(pageReference);
        }
    }

    public void setPageNumber(String id, String pageNumber) {
        IDNode node = (IDNode)this.idReferences.get(id);
        node.setPageNumber(pageNumber);
    }

    public String getPageNumber(String id) {
        if (this.doesIDExist(id)) {
            IDNode node = (IDNode)this.idReferences.get(id);
            return node.getPageNumber();
        }
        this.addToIdValidationList(id);
        return null;
    }

    public void setPosition(String id, int x, int y) {
        IDNode node = (IDNode)this.idReferences.get(id);
        node.setPosition(x, y);
    }

    public Iterator getInvalidElements() {
        return this.idValidation.keySet().iterator();
    }

    public String getDestinationRef(String id) {
        if (this.doesIDExist(id)) {
            IDNode node = (IDNode)this.idReferences.get(id);
            return "[ " + node.getPageReference() + " /XYZ " + (float)node.getXPosition() / 1000.0f + " " + (float)node.getYPosition() / 1000.0f + " null ]";
        }
        this.addToIdValidationList(id);
        return null;
    }
}

