/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.pdf.DCTFilter;

public class JpegImage
extends AbstractFopImage {
    boolean hasAPPEMarker = false;
    boolean found_icc_profile = false;
    boolean found_dimensions = false;

    public JpegImage(URL href) throws FopImageException {
        super(href);
    }

    public JpegImage(URL href, ImageReader imgReader) throws FopImageException {
        super(href, imgReader);
    }

    /*
     * WARNING - void declaration
     */
    protected void loadImage() throws FopImageException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream iccStream = new ByteArrayOutputStream();
        this.m_colorSpace = new ColorSpace(-1);
        byte[] readBuf = new byte[4096];
        int index = 0;
        boolean cont = true;
        this.m_compressionType = new DCTFilter();
        this.m_compressionType.setApplied(true);
        try {
            int bytes_read;
            InputStream inStream = this.m_href.openStream();
            while ((bytes_read = inStream.read(readBuf)) != -1) {
                void var5_7;
                baos.write(readBuf, 0, (int)var5_7);
            }
        }
        catch (IOException ex) {
            throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + ex.getClass() + " - " + ex.getMessage());
        }
        this.m_bitmaps = baos.toByteArray();
        this.m_bitsPerPixel = 8;
        this.m_isTransparent = false;
        if (this.m_bitmaps.length > index + 2 && this.uByte(this.m_bitmaps[index]) == 255 && this.uByte(this.m_bitmaps[index + 1]) == 216) {
            index += 2;
            while (index < this.m_bitmaps.length && cont) {
                if (this.m_bitmaps.length > index + 2 && this.uByte(this.m_bitmaps[index]) == 255) {
                    if (this.uByte(this.m_bitmaps[index + 1]) == 192 || this.uByte(this.m_bitmaps[index + 1]) == 194) {
                        this.m_height = this.calcBytes(this.m_bitmaps[index + 5], this.m_bitmaps[index + 6]);
                        this.m_width = this.calcBytes(this.m_bitmaps[index + 7], this.m_bitmaps[index + 8]);
                        if (this.m_bitmaps[index + 9] == 1) {
                            this.m_colorSpace.setColorSpace(1);
                        } else if (this.m_bitmaps[index + 9] == 3) {
                            this.m_colorSpace.setColorSpace(2);
                        } else if (this.m_bitmaps[index + 9] == 4) {
                            this.m_colorSpace.setColorSpace(3);
                        }
                        this.found_dimensions = true;
                        if (this.found_icc_profile) {
                            cont = false;
                            break;
                        }
                        index += this.calcBytes(this.m_bitmaps[index + 2], this.m_bitmaps[index + 3]) + 2;
                        continue;
                    }
                    if (this.uByte(this.m_bitmaps[index + 1]) == 226 && this.m_bitmaps.length > index + 60) {
                        byte[] icc_string = new byte[11];
                        System.arraycopy(this.m_bitmaps, index + 4, icc_string, 0, 11);
                        if ("ICC_PROFILE".equals(new String(icc_string))) {
                            int chunkSize = this.calcBytes(this.m_bitmaps[index + 2], this.m_bitmaps[index + 3]) + 2;
                            iccStream.write(this.m_bitmaps, index + 16, chunkSize - 18);
                        }
                        index += this.calcBytes(this.m_bitmaps[index + 2], this.m_bitmaps[index + 3]) + 2;
                        continue;
                    }
                    if (this.uByte(this.m_bitmaps[index]) == 255 && this.uByte(this.m_bitmaps[index + 1]) == 238 && this.uByte(this.m_bitmaps[index + 2]) == 0 && this.uByte(this.m_bitmaps[index + 3]) == 14 && "Adobe".equals(new String(this.m_bitmaps, index + 4, 5))) {
                        this.hasAPPEMarker = true;
                        index += this.calcBytes(this.m_bitmaps[index + 2], this.m_bitmaps[index + 3]) + 2;
                        continue;
                    }
                    index += this.calcBytes(this.m_bitmaps[index + 2], this.m_bitmaps[index + 3]) + 2;
                    continue;
                }
                cont = false;
            }
        } else {
            throw new FopImageException("\n1 Error while loading image " + this.m_href.toString() + " : JpegImage - Invalid JPEG Header.");
        }
        if (iccStream.size() > 0) {
            byte[] align = new byte[iccStream.size() % 8 + 8];
            try {
                iccStream.write(align);
            }
            catch (Exception e) {
                throw new FopImageException("\n1 Error while loading image " + this.m_href.toString() + " : " + e.getMessage());
            }
            this.m_colorSpace.setICCProfile(iccStream.toByteArray());
        }
        if (this.hasAPPEMarker && this.m_colorSpace.getColorSpace() == 3) {
            this.m_invertImage = true;
        }
    }

    private int calcBytes(byte bOne, byte bTwo) {
        return this.uByte(bOne) * 256 + this.uByte(bTwo);
    }

    private int uByte(byte bIn) {
        if (bIn < 0) {
            return 256 + bIn;
        }
        return bIn;
    }
}

