/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class GaussianBlurRed8Bit
extends AbstractRed {
    int xinset;
    int yinset;
    double stdDevX;
    double stdDevY;
    RenderingHints hints;
    ConvolveOp[] convOp = new ConvolveOp[2];
    int dX;
    int dY;
    static final float SQRT2PI = (float)Math.sqrt(Math.PI * 2);
    static final float DSQRT2PI = SQRT2PI * 3.0f / 4.0f;
    static final float precision = 0.499f;

    public GaussianBlurRed8Bit(CachableRed cachableRed, double d, RenderingHints renderingHints) {
        this(cachableRed, d, d, renderingHints);
    }

    /*
     * Unable to fully structure code
     */
    public GaussianBlurRed8Bit(CachableRed var1_1, double var2_2, double var4_3, RenderingHints var6_4) {
        super();
        this.stdDevX = var2_2;
        this.stdDevY = var4_3;
        this.hints = var6_4;
        this.xinset = GaussianBlurRed8Bit.surroundPixels(var2_2, var6_4);
        this.yinset = GaussianBlurRed8Bit.surroundPixels(var4_3, var6_4);
        var7_5 = var1_1.getBounds();
        var7_5.x += this.xinset;
        var7_5.y += this.yinset;
        var7_5.width -= 2 * this.xinset;
        var7_5.height -= 2 * this.yinset;
        if (var7_5.width <= 0 || var7_5.height <= 0) {
            var7_5.width = 0;
            var7_5.height = 0;
        }
        var8_6 = GaussianBlurRed8Bit.fixColorModel(var1_1);
        var9_7 = var1_1.getSampleModel();
        var10_8 = var9_7.getWidth();
        var11_9 = var9_7.getHeight();
        if (var10_8 > var7_5.width) {
            var10_8 = var7_5.width;
        }
        if (var11_9 > var7_5.height) {
            var11_9 = var7_5.height;
        }
        var9_7 = var8_6.createCompatibleSampleModel(var10_8, var11_9);
        this.init(var1_1, var7_5, var8_6, var9_7, var1_1.getTileGridXOffset() + this.xinset, var1_1.getTileGridYOffset() + this.yinset, null);
        if (this.hints == null) ** GOTO lbl-1000
        if (RenderingHints.VALUE_RENDER_QUALITY.equals(this.hints.get(RenderingHints.KEY_RENDERING))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var12_10 = false;
        }
        if (this.xinset != 0 && (var2_2 < 2.0 || var12_10)) {
            this.convOp[0] = new ConvolveOp(this.makeQualityKernelX(this.xinset * 2 + 1));
        } else {
            this.dX = (int)Math.floor((double)GaussianBlurRed8Bit.DSQRT2PI * var2_2 + 0.5);
        }
        if (this.yinset != 0 && (var4_3 < 2.0 || var12_10)) {
            this.convOp[1] = new ConvolveOp(this.makeQualityKernelY(this.yinset * 2 + 1));
        } else {
            this.dY = (int)Math.floor((double)GaussianBlurRed8Bit.DSQRT2PI * var4_3 + 0.5);
        }
    }

    public static int surroundPixels(double d) {
        return GaussianBlurRed8Bit.surroundPixels(d, null);
    }

    /*
     * Unable to fully structure code
     */
    public static int surroundPixels(double var0, RenderingHints var2_1) {
        if (var2_1 == null) ** GOTO lbl-1000
        if (RenderingHints.VALUE_RENDER_QUALITY.equals(var2_1.get(RenderingHints.KEY_RENDERING))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var3_2 = false;
        }
        if (var0 < 2.0 || var3_2) {
            var4_3 = (float)(0.5 / (var0 * (double)GaussianBlurRed8Bit.SQRT2PI));
            var5_5 = 0;
            while (var4_3 < 0.499f) {
                var4_3 += (float)(Math.pow(2.718281828459045, (double)(-var5_5 * var5_5) / (2.0 * var0 * var0)) / (var0 * (double)GaussianBlurRed8Bit.SQRT2PI));
                ++var5_5;
            }
            return var5_5;
        }
        var4_4 = (int)Math.floor((double)GaussianBlurRed8Bit.DSQRT2PI * var0 + 0.5);
        if (var4_4 % 2 == 0) {
            return var4_4 - 1 + var4_4 / 2;
        }
        return var4_4 - 2 + var4_4 / 2;
    }

    private float[] computeQualityKernelData(int n, double d) {
        int n2;
        float[] fArray = new float[n];
        int n3 = n / 2;
        float f = 0.0f;
        for (n2 = 0; n2 < n; ++n2) {
            fArray[n2] = (float)(Math.pow(Math.E, (double)(-(n2 - n3) * (n2 - n3)) / (2.0 * d * d)) / ((double)SQRT2PI * d));
            f += fArray[n2];
        }
        n2 = 0;
        while (n2 < n) {
            int n4 = n2++;
            fArray[n4] = fArray[n4] / f;
        }
        return fArray;
    }

    private Kernel makeQualityKernelX(int n) {
        return new Kernel(n, 1, this.computeQualityKernelData(n, this.stdDevX));
    }

    private Kernel makeQualityKernelY(int n) {
        return new Kernel(1, n, this.computeQualityKernelData(n, this.stdDevY));
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        int n;
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = writableRaster.getBounds();
        rectangle.x -= this.xinset;
        rectangle.y -= this.yinset;
        rectangle.width += 2 * this.xinset;
        rectangle.height += 2 * this.yinset;
        ColorModel colorModel = cachableRed.getColorModel();
        ColorModel colorModel2 = this.getColorModel();
        WritableRaster writableRaster2 = null;
        WritableRaster writableRaster3 = null;
        writableRaster2 = colorModel.createCompatibleWritableRaster(rectangle.width, rectangle.height);
        WritableRaster writableRaster4 = writableRaster2.createWritableTranslatedChild(rectangle.x, rectangle.y);
        cachableRed.copyData(writableRaster4);
        if (colorModel.hasAlpha() && !colorModel.isAlphaPremultiplied()) {
            GraphicsUtil.coerceData(writableRaster2, colorModel, true);
        }
        if (this.xinset == 0) {
            n = 0;
        } else if (this.convOp[0] != null) {
            writableRaster3 = this.getColorModel().createCompatibleWritableRaster(rectangle.width, rectangle.height);
            writableRaster3 = this.convOp[0].filter(writableRaster2, writableRaster3);
            n = this.convOp[0].getKernel().getXOrigin();
            WritableRaster writableRaster5 = writableRaster2;
            writableRaster2 = writableRaster3;
            writableRaster3 = writableRaster5;
        } else if ((this.dX & 1) == 0) {
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, 0, 0, this.dX, this.dX / 2);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX / 2, 0, this.dX, this.dX / 2 - 1);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX - 1, 0, this.dX + 1, this.dX / 2);
            n = this.dX - 1 + this.dX / 2;
        } else {
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, 0, 0, this.dX, this.dX / 2);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX / 2, 0, this.dX, this.dX / 2);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX - 2, 0, this.dX, this.dX / 2);
            n = this.dX - 2 + this.dX / 2;
        }
        if (this.yinset == 0) {
            writableRaster3 = writableRaster2;
        } else if (this.convOp[1] != null) {
            if (writableRaster3 == null) {
                writableRaster3 = this.getColorModel().createCompatibleWritableRaster(rectangle.width, rectangle.height);
            }
            writableRaster3 = this.convOp[1].filter(writableRaster2, writableRaster3);
        } else {
            if ((this.dY & 1) == 0) {
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, 0, this.dY, this.dY / 2);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, this.dY / 2, this.dY, this.dY / 2 - 1);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, this.dY - 1, this.dY + 1, this.dY / 2);
            } else {
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, 0, this.dY, this.dY / 2);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, this.dY / 2, this.dY, this.dY / 2);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, this.dY - 2, this.dY, this.dY / 2);
            }
            writableRaster3 = writableRaster2;
        }
        writableRaster3 = writableRaster3.createWritableTranslatedChild(rectangle.x, rectangle.y);
        GraphicsUtil.copyData(writableRaster3, writableRaster);
        return writableRaster;
    }

    private WritableRaster boxFilterH(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4) {
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n5 < 2 * n + n3) {
            return writableRaster;
        }
        if (n6 < 2 * n2) {
            return writableRaster;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        int n8 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n10 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = new int[n3];
        int n11 = 0x1000000 / n3;
        for (int i = n2; i < n6 - n2; ++i) {
            int n12;
            int n13 = n9 + i * n7;
            int n14 = n10 + i * n8;
            int n15 = n13 + (n5 - n);
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = (n13 += n) + n3;
            while (n13 < n21) {
                n12 = nArray3[n16] = nArray[n13];
                n17 += n12 >>> 24;
                n18 += n12 >> 16 & 0xFF;
                n19 += n12 >> 8 & 0xFF;
                n20 += n12 & 0xFF;
                ++n16;
                ++n13;
            }
            int n22 = nArray2[n14 += n + n4] = n17 * n11 & 0xFF000000 | (n18 * n11 & 0xFF000000) >>> 8 | (n19 * n11 & 0xFF000000) >>> 16 | (n20 * n11 & 0xFF000000) >>> 24;
            ++n14;
            n16 = 0;
            while (n13 < n15) {
                n12 = nArray3[n16];
                if (n12 == nArray[n13]) {
                    nArray2[n14] = n22;
                } else {
                    n17 -= n12 >>> 24;
                    n18 -= n12 >> 16 & 0xFF;
                    n19 -= n12 >> 8 & 0xFF;
                    n20 -= n12 & 0xFF;
                    n12 = nArray3[n16] = nArray[n13];
                    n22 = nArray2[n14] = (n17 += n12 >>> 24) * n11 & 0xFF000000 | ((n18 += n12 >> 16 & 0xFF) * n11 & 0xFF000000) >>> 8 | ((n19 += n12 >> 8 & 0xFF) * n11 & 0xFF000000) >>> 16 | ((n20 += n12 & 0xFF) * n11 & 0xFF000000) >>> 24;
                }
                n16 = (n16 + 1) % n3;
                ++n13;
                ++n14;
            }
        }
        return writableRaster;
    }

    private WritableRaster boxFilterV(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4) {
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n5 < 2 * n) {
            return writableRaster;
        }
        if (n6 < 2 * n2 + n3) {
            return writableRaster;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        int n8 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n10 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = new int[n3];
        int n11 = 0x1000000 / n3;
        for (int i = n; i < n5 - n; ++i) {
            int n12;
            int n13 = n9 + i;
            int n14 = n10 + i;
            int n15 = n13 + (n6 - n2) * n7;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = (n13 += n2 * n7) + n3 * n7;
            while (n13 < n21) {
                n12 = nArray3[n16] = nArray[n13];
                n17 += n12 >>> 24;
                n18 += n12 >> 16 & 0xFF;
                n19 += n12 >> 8 & 0xFF;
                n20 += n12 & 0xFF;
                ++n16;
                n13 += n7;
            }
            int n22 = nArray2[n14 += (n2 + n4) * n8] = n17 * n11 & 0xFF000000 | (n18 * n11 & 0xFF000000) >>> 8 | (n19 * n11 & 0xFF000000) >>> 16 | (n20 * n11 & 0xFF000000) >>> 24;
            n14 += n8;
            n16 = 0;
            while (n13 < n15) {
                n12 = nArray3[n16];
                if (n12 == nArray[n13]) {
                    nArray2[n14] = n22;
                } else {
                    n17 -= n12 >>> 24;
                    n18 -= n12 >> 16 & 0xFF;
                    n19 -= n12 >> 8 & 0xFF;
                    n20 -= n12 & 0xFF;
                    n12 = nArray3[n16] = nArray[n13];
                    n22 = nArray2[n14] = (n17 += n12 >>> 24) * n11 & 0xFF000000 | ((n18 += n12 >> 16 & 0xFF) * n11 & 0xFF000000) >>> 8 | ((n19 += n12 >> 8 & 0xFF) * n11 & 0xFF000000) >>> 16 | ((n20 += n12 & 0xFF) * n11 & 0xFF000000) >>> 24;
                }
                n16 = (n16 + 1) % n3;
                n13 += n7;
                n14 += n8;
            }
        }
        return writableRaster;
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        int n = cachableRed.getSampleModel().getNumBands();
        int[] nArray = new int[4];
        switch (n) {
            case 1: {
                nArray[0] = 255;
                break;
            }
            case 2: {
                nArray[0] = 255;
                nArray[3] = 65280;
                break;
            }
            case 3: {
                nArray[0] = 0xFF0000;
                nArray[1] = 65280;
                nArray[2] = 255;
                break;
            }
            case 4: {
                nArray[0] = 0xFF0000;
                nArray[1] = 65280;
                nArray[2] = 255;
                nArray[3] = -16777216;
                break;
            }
            default: {
                throw new IllegalArgumentException("GaussianBlurRed8Bit only supports one to four band images");
            }
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        return new DirectColorModel(colorSpace, 8 * n, nArray[0], nArray[1], nArray[2], nArray[3], true, 3);
    }
}

