/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.parser.DefaultErrorHandler;
import org.apache.batik.parser.ErrorHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.Parser;
import org.apache.batik.util.io.NormalizingReader;
import org.apache.batik.util.io.StreamNormalizingReader;
import org.apache.batik.util.io.StringNormalizingReader;

public abstract class AbstractParser
implements Parser {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.parser.resources.Messages";
    protected ErrorHandler errorHandler = new DefaultErrorHandler();
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.parser.resources.Messages");
    protected NormalizingReader reader;
    protected int current;

    public int getCurrent() {
        return this.current;
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void parse(Reader reader) throws ParseException {
        try {
            this.reader = new StreamNormalizingReader(reader);
            this.doParse();
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
    }

    public void parse(InputStream inputStream, String string) throws ParseException {
        try {
            this.reader = new StreamNormalizingReader(inputStream, string);
            this.doParse();
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
    }

    public void parse(String string) throws ParseException {
        try {
            this.reader = new StringNormalizingReader(string);
            this.doParse();
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
    }

    protected abstract void doParse() throws ParseException, IOException;

    protected void reportError(String string, Object[] objectArray) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage(string, objectArray), this.reader.getLine(), this.reader.getColumn()));
    }

    protected String createErrorMessage(String string, Object[] objectArray) {
        try {
            return this.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    protected String getBundleClassName() {
        return BUNDLE_CLASSNAME;
    }

    protected void skipSpaces() throws IOException {
        while (true) {
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            this.current = this.reader.read();
        }
    }

    protected void skipCommaSpaces() throws IOException {
        block6: while (true) {
            switch (this.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.current = this.reader.read();
                    continue block6;
                }
            }
            break;
        }
        if (this.current == 44) {
            block7: while (true) {
                this.current = this.reader.read();
                switch (this.current) {
                    default: {
                        break block7;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block7;
                    }
                }
                break;
            }
        }
    }
}

