/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.SingleThreaded;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.flow.ContinuationsManager;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelinesNode;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.excalibur.source.SourceUtil;

public abstract class AbstractInterpreter
extends AbstractLogEnabled
implements Component,
Composable,
Contextualizable,
Interpreter,
SingleThreaded,
Configurable,
Disposable {
    protected ArrayList needResolve = new ArrayList();
    protected Context context;
    protected ComponentManager manager;
    protected ContinuationsManager continuationsMgr;
    protected boolean reloadScripts;
    protected long checkTime;

    public void configure(Configuration config) throws ConfigurationException {
        this.reloadScripts = config.getChild("reload-scripts").getValueAsBoolean(false);
        this.checkTime = config.getChild("check-time").getValueAsLong(1000L);
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.continuationsMgr = (ContinuationsManager)manager.lookup(ContinuationsManager.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this.context = (Context)context.get((Object)"environment-context");
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.continuationsMgr);
            this.continuationsMgr = null;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String source) {
        AbstractInterpreter abstractInterpreter = this;
        synchronized (abstractInterpreter) {
            this.needResolve.add(source);
        }
    }

    public boolean process(String uri, Object biz, OutputStream out, Environment env) throws Exception {
        boolean bl;
        Processor processor;
        Object key;
        EnvironmentWrapper wrapper;
        block6: {
            if (out == null) {
                throw new NullPointerException("No outputstream specified for process");
            }
            uri = uri.length() > 0 && uri.charAt(0) == '/' ? uri.substring(1) : env.getURIPrefix() + uri;
            wrapper = new EnvironmentWrapper(env, uri, "", this.getLogger());
            wrapper.setURI("", uri);
            wrapper.setOutputStream(out);
            Map objectModel = env.getObjectModel();
            FlowHelper.setContextObject(objectModel, biz);
            key = CocoonComponentManager.startProcessing(wrapper);
            processor = null;
            boolean result = false;
            try {
                processor = (Processor)this.manager.lookup(Processor.ROLE);
                CocoonComponentManager.enterEnvironment(wrapper, this.manager, processor);
                result = processor.process(wrapper);
                wrapper.commitResponse();
                out.flush();
                bl = result;
                Object var12_12 = null;
                if (processor == null) break block6;
            }
            catch (Exception any) {
                try {
                    throw any;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (processor != null) {
                        CocoonComponentManager.leaveEnvironment();
                    }
                    CocoonComponentManager.endProcessing(wrapper, key);
                    this.manager.release((Component)processor);
                    throw throwable;
                }
            }
            CocoonComponentManager.leaveEnvironment();
        }
        CocoonComponentManager.endProcessing(wrapper, key);
        this.manager.release((Component)processor);
        return bl;
    }

    public void forwardTo(String uri, Object bizData, WebContinuation continuation, Environment environment) throws Exception {
        if (SourceUtil.indexOfSchemeColon((String)uri) != -1) {
            throw new Exception("uri is not allowed to contain a scheme (cocoon:/ is always automatically used)");
        }
        uri = "cocoon:/" + uri;
        Map objectModel = environment.getObjectModel();
        FlowHelper.setContextObject(objectModel, bizData);
        FlowHelper.setWebContinuation(objectModel, continuation);
        PipelinesNode.getRedirector(environment).redirect(false, uri);
    }
}

