/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.pipeline.OutputComponentSelector;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.reading.Reader;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.sitemap.SitemapModelComponent;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public abstract class AbstractProcessingPipeline
extends AbstractLogEnabled
implements ProcessingPipeline,
Parameterizable,
Recyclable {
    protected Generator generator;
    protected Parameters generatorParam;
    protected String generatorSource;
    protected ComponentSelector generatorSelector;
    protected ArrayList transformers = new ArrayList();
    protected ArrayList transformerParams = new ArrayList();
    protected ArrayList transformerSources = new ArrayList();
    protected ArrayList transformerSelectors = new ArrayList();
    protected Serializer serializer;
    protected Parameters serializerParam;
    protected String serializerSource;
    protected String serializerMimeType;
    protected String sitemapSerializerMimeType;
    protected OutputComponentSelector serializerSelector;
    protected Reader reader;
    protected Parameters readerParam;
    protected String readerSource;
    protected String readerMimeType;
    protected String sitemapReaderMimeType;
    protected OutputComponentSelector readerSelector;
    protected XMLConsumer lastConsumer;
    protected ComponentManager manager;
    protected ComponentManager newManager;
    protected Parameters configuration;
    protected Parameters parameters;
    protected long expires;
    protected long configuredExpires;
    protected int configuredOutputBufferSize;
    protected int outputBufferSize;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.newManager = manager;
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.newManager = manager;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.configuration = params;
        String expiresValue = params.getParameter("expires", null);
        if (expiresValue != null) {
            this.configuredExpires = this.parseExpires(expiresValue);
        }
        this.configuredOutputBufferSize = params.getParameterAsInteger("outputBufferSize", -1);
    }

    public void setup(Parameters params) {
        this.parameters = params;
        String expiresValue = params.getParameter("expires", null);
        this.expires = expiresValue != null ? this.parseExpires(expiresValue) : this.configuredExpires;
        this.outputBufferSize = params.getParameterAsInteger("outputBufferSize", this.configuredOutputBufferSize);
    }

    public void release() {
        try {
            CocoonComponentManager.removeFromAutomaticRelease(this);
        }
        catch (ProcessingException pe) {
            this.getLogger().error("Unabled to release processing component.", (Throwable)((Object)pe));
        }
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void informBranchPoint() {
    }

    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. You can only select one Generator (" + role + ")");
        }
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. You cannot use a reader and a generator for one pipeline.");
        }
        try {
            this.generatorSelector = (ComponentSelector)this.newManager.lookup(Generator.ROLE + "Selector");
        }
        catch (ComponentException ce) {
            throw new ProcessingException("Lookup of generator selector failed.", ce);
        }
        try {
            this.generator = (Generator)this.generatorSelector.select((Object)role);
        }
        catch (ComponentException ce) {
            throw new ProcessingException("Lookup of generator for role '" + role + "' failed.", ce);
        }
        this.generatorSource = source;
        this.generatorParam = param;
    }

    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. You cannot use a transformer with a reader.");
        }
        if (this.generator == null) {
            throw new ProcessingException("You must set a generator first before you can use a transformer.");
        }
        ComponentSelector selector = null;
        try {
            selector = (ComponentSelector)this.newManager.lookup(Transformer.ROLE + "Selector");
        }
        catch (ComponentException ce) {
            throw new ProcessingException("Lookup of transformer selector failed.", ce);
        }
        try {
            this.transformers.add(selector.select((Object)role));
            this.transformerSelectors.add(selector);
        }
        catch (ComponentException ce) {
            throw new ProcessingException("Lookup of transformer for role '" + role + "' failed.", ce);
        }
        this.transformerSources.add(source);
        this.transformerParams.add(param);
    }

    public void setSerializer(String role, String source, Parameters param, Parameters hintParam, String mimeType) throws ProcessingException {
        if (this.serializer != null) {
            throw new ProcessingException("Serializer already set. You can only select one Serializer (" + role + ")");
        }
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. You cannot use a serializer with a reader.");
        }
        if (this.generator == null) {
            throw new ProcessingException("You must set a generator first before you can use a serializer.");
        }
        try {
            this.serializerSelector = (OutputComponentSelector)this.newManager.lookup(Serializer.ROLE + "Selector");
        }
        catch (ComponentException ce) {
            throw new ProcessingException("Lookup of serializer selector failed.", ce);
        }
        try {
            this.serializer = (Serializer)this.serializerSelector.select(role);
        }
        catch (ComponentException ce) {
            throw new ProcessingException("Lookup of serializer for role '" + role + "' failed.", ce);
        }
        this.serializerSource = source;
        this.serializerParam = param;
        this.serializerMimeType = mimeType;
        this.sitemapSerializerMimeType = this.serializerSelector.getMimeTypeForHint(role);
        this.lastConsumer = this.serializer;
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws ProcessingException {
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. You can only select one Reader (" + role + ")");
        }
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. You cannot use a reader and a generator for one pipeline.");
        }
        try {
            this.readerSelector = (OutputComponentSelector)this.newManager.lookup(Reader.ROLE + "Selector");
        }
        catch (ComponentException ce) {
            throw new ProcessingException("Lookup of reader selector failed.", ce);
        }
        try {
            this.reader = (Reader)this.readerSelector.select(role);
        }
        catch (ComponentException ce) {
            throw new ProcessingException("Lookup of reader for role '" + role + "' failed.", ce);
        }
        this.readerSource = source;
        this.readerParam = param;
        this.readerMimeType = mimeType;
        this.sitemapReaderMimeType = this.readerSelector.getMimeTypeForHint(role);
    }

    protected boolean checkPipeline() {
        if (this.generator == null && this.reader == null) {
            return false;
        }
        return this.generator == null || this.serializer != null;
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        block8: {
            try {
                String mimeType;
                this.generator.setup(environment, environment.getObjectModel(), this.generatorSource, this.generatorParam);
                Iterator transformerItt = this.transformers.iterator();
                Iterator transformerSourceItt = this.transformerSources.iterator();
                Iterator transformerParamItt = this.transformerParams.iterator();
                while (transformerItt.hasNext()) {
                    Transformer trans = (Transformer)transformerItt.next();
                    trans.setup(environment, environment.getObjectModel(), (String)transformerSourceItt.next(), (Parameters)transformerParamItt.next());
                }
                if (this.serializer instanceof SitemapModelComponent) {
                    ((SitemapModelComponent)((Object)this.serializer)).setup(environment, environment.getObjectModel(), this.serializerSource, this.serializerParam);
                }
                if ((mimeType = this.serializer.getMimeType()) != null) {
                    environment.setContentType(mimeType);
                    break block8;
                }
                if (this.serializerMimeType != null) {
                    environment.setContentType(this.serializerMimeType);
                    break block8;
                }
                if (this.sitemapSerializerMimeType != null) {
                    environment.setContentType(this.sitemapSerializerMimeType);
                    break block8;
                }
                String message = "Unable to determine MIME type for " + environment.getURIPrefix() + "/" + environment.getURI();
                throw new ProcessingException(message);
            }
            catch (SAXException e) {
                throw new ProcessingException("Could not setup pipeline.", e);
            }
            catch (IOException e) {
                throw new ProcessingException("Could not setup pipeline.", e);
            }
        }
    }

    protected void connect(Environment environment, XMLProducer producer, XMLConsumer consumer) throws ProcessingException {
        XMLProducer next = producer;
        next.setConsumer(consumer);
    }

    protected void connectPipeline(Environment environment) throws ProcessingException {
        XMLProducer prev = this.generator;
        Iterator itt = this.transformers.iterator();
        while (itt.hasNext()) {
            Transformer next = (Transformer)itt.next();
            this.connect(environment, prev, next);
            prev = next;
        }
        this.connect(environment, prev, this.lastConsumer);
    }

    public boolean process(Environment environment) throws ProcessingException {
        if (null == this.lastConsumer) {
            this.lastConsumer = this.serializer;
        }
        this.preparePipeline(environment);
        if (this.expires != 0L) {
            Response res = ObjectModelHelper.getResponse(environment.getObjectModel());
            res.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
            res.setHeader("Cache-Control", "max-age=" + this.expires / 1000L + ", public");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Setting a new Expires object for this resource");
            }
            environment.getObjectModel().put("expires", new Long(this.expires + System.currentTimeMillis()));
        }
        if (this.reader != null) {
            if (this.checkIfModified(environment, this.reader.getLastModified())) {
                return true;
            }
            return this.processReader(environment);
        }
        this.connectPipeline(environment);
        return this.processXMLPipeline(environment);
    }

    protected void preparePipeline(Environment environment) throws ProcessingException {
        if (!this.checkPipeline()) {
            throw new ProcessingException("Attempted to process incomplete pipeline.");
        }
        if (this.reader != null) {
            this.setupReader(environment);
        } else {
            this.setupPipeline(environment);
        }
    }

    public void prepareInternal(Environment environment) throws ProcessingException {
        this.lastConsumer = null;
        this.preparePipeline(environment);
    }

    protected boolean processXMLPipeline(Environment environment) throws ProcessingException {
        try {
            if (this.serializer != this.lastConsumer) {
                this.generator.generate();
            } else if (this.serializer.shouldSetContentLength()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.serializer.setOutputStream(os);
                this.generator.generate();
                byte[] data = os.toByteArray();
                environment.setContentLength(data.length);
                environment.getOutputStream(0).write(data);
            } else {
                this.serializer.setOutputStream(environment.getOutputStream(this.outputBufferSize));
                this.generator.generate();
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
        return true;
    }

    protected void setupReader(Environment environment) throws ProcessingException {
        try {
            this.reader.setup(environment, environment.getObjectModel(), this.readerSource, this.readerParam);
            String mimeType = this.reader.getMimeType();
            if (mimeType != null) {
                environment.setContentType(mimeType);
            } else if (this.readerMimeType != null) {
                environment.setContentType(this.readerMimeType);
            } else {
                environment.setContentType(this.sitemapReaderMimeType);
            }
        }
        catch (SAXException e) {
            throw new ProcessingException("Failed to execute reader pipeline.", e);
        }
        catch (IOException e) {
            throw new ProcessingException("Failed to execute reader pipeline.", e);
        }
    }

    protected boolean checkIfModified(Environment environment, long lastModified) throws ProcessingException {
        if (!environment.isResponseModified(lastModified)) {
            environment.setResponseIsNotModified();
            return true;
        }
        return false;
    }

    protected boolean processReader(Environment environment) throws ProcessingException {
        try {
            if (this.reader.shouldSetContentLength()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.reader.setOutputStream(os);
                this.reader.generate();
                byte[] data = os.toByteArray();
                environment.setContentLength(data.length);
                environment.getOutputStream(0).write(data);
            } else {
                this.reader.setOutputStream(environment.getOutputStream(this.outputBufferSize));
                this.reader.generate();
            }
        }
        catch (SocketException se) {
            if (se.getMessage().indexOf("reset") > 0 || se.getMessage().indexOf("aborted") > 0 || se.getMessage().indexOf("connection abort") > 0) {
                throw new ConnectionResetException("Connection reset by peer", se);
            }
            throw new ProcessingException("Failed to execute reader pipeline.", se);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Error executing reader pipeline.", e);
        }
        return true;
    }

    public void recycle() {
        if (this.readerSelector != null) {
            this.readerSelector.release(this.reader);
            this.newManager.release((Component)this.readerSelector);
            this.readerSelector = null;
            this.reader = null;
            this.readerParam = null;
        }
        if (this.generatorSelector != null) {
            this.generatorSelector.release((Component)this.generator);
            this.newManager.release((Component)this.generatorSelector);
            this.generatorSelector = null;
            this.generator = null;
            this.generatorParam = null;
        }
        int size = this.transformerSelectors.size();
        for (int i = 0; i < size; ++i) {
            ComponentSelector selector = (ComponentSelector)this.transformerSelectors.get(i);
            selector.release((Component)this.transformers.get(i));
            this.newManager.release((Component)selector);
        }
        this.transformerSelectors.clear();
        this.transformers.clear();
        this.transformerParams.clear();
        this.transformerSources.clear();
        if (this.serializerSelector != null) {
            this.serializerSelector.release(this.serializer);
            this.newManager.release((Component)this.serializerSelector);
            this.serializerSelector = null;
            this.serializerParam = null;
        }
        this.serializer = null;
        this.parameters = null;
    }

    public boolean process(Environment environment, XMLConsumer consumer) throws ProcessingException {
        this.lastConsumer = consumer;
        if (this.reader != null) {
            throw new ProcessingException("Streaming of an internal pipeline is not possible with a reader.");
        }
        this.connectPipeline(environment);
        return this.processXMLPipeline(environment);
    }

    public SourceValidity getValidityForEventPipeline() {
        return null;
    }

    private long parseExpires(String expire) {
        StringTokenizer tokens = new StringTokenizer(expire);
        String current = tokens.nextToken();
        if (current.equals("modification")) {
            this.getLogger().warn("the \"modification\" keyword is not yet implemented. Assuming \"now\" as the base attribute");
            current = "now";
        }
        if (!current.equals("now") && !current.equals("access")) {
            this.getLogger().error("bad <base> attribute, Expires header will not be set");
            return -1L;
        }
        long number = 0L;
        long modifier = 0L;
        long expires = 0L;
        while (tokens.hasMoreTokens()) {
            current = tokens.nextToken();
            if (current.equals("plus")) {
                current = tokens.nextToken();
            }
            try {
                number = Long.parseLong(current);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().error("state violation: a number was expected here");
                return -1L;
            }
            try {
                current = tokens.nextToken();
            }
            catch (NoSuchElementException nsee) {
                this.getLogger().error("State violation: expecting a modifier but no one found: Expires header will not be set");
            }
            if (current.equals("years")) {
                modifier = 31536000000L;
            } else if (current.equals("months")) {
                modifier = 2592000000L;
            } else if (current.equals("weeks")) {
                modifier = 604800000L;
            } else if (current.equals("days")) {
                modifier = 86400000L;
            } else if (current.equals("hours")) {
                modifier = 3600000L;
            } else if (current.equals("minutes")) {
                modifier = 60000L;
            } else if (current.equals("seconds")) {
                modifier = 1000L;
            } else {
                this.getLogger().error("Bad modifier (" + current + "): ignoring expires configuration");
                return -1L;
            }
            expires += number * modifier;
        }
        return expires;
    }

    public String getKeyForEventPipeline() {
        return null;
    }
}

