/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.excalibur.xml.xpath.NodeListImpl;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.apache.excalibur.xml.xpath.XPathUtil;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class DOMUtil {
    private static final String XML_DEFINITION = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    private static final String XML_ROOT_DEFINITION = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><root>";

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static String getValueOfNode(XPathProcessor processor, Node root, String path) throws ProcessingException {
        Node node;
        if (path == null) {
            throw new ProcessingException("Not a valid XPath: " + path);
        }
        if (root == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((node = XPathUtil.searchSingleNode((XPathProcessor)processor, (Node)root, (String)path)) != null) {
            return DOMUtil.getValueOfNode(node);
        }
        return null;
    }

    public static String getValueOfNode(XPathProcessor processor, Node root, String path, String defaultValue) throws ProcessingException {
        String value = DOMUtil.getValueOfNode(processor, root, path);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getValueOfNodeAsBoolean(XPathProcessor processor, Node root, String path) throws ProcessingException {
        String value = DOMUtil.getValueOfNode(processor, root, path);
        if (value == null) {
            throw new ProcessingException("No such node: " + path);
        }
        return Boolean.valueOf(value);
    }

    public static boolean getValueOfNodeAsBoolean(XPathProcessor processor, Node root, String path, boolean defaultValue) throws ProcessingException {
        String value = DOMUtil.getValueOfNode(processor, root, path);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static String getValueOfNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        String value = null;
        node.normalize();
        NodeList childs = node.getChildNodes();
        int i = 0;
        int l = childs.getLength();
        while (i < l && value == null) {
            if (childs.item(i).getNodeType() == 3) {
                value = childs.item(i).getNodeValue().trim();
                continue;
            }
            ++i;
        }
        return value;
    }

    public static String getValueOfNode(Node node, String defaultValue) {
        String value = DOMUtil.getValueOfNode(node);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static void setValueOfNode(Node node, String value) {
        if (node.getNodeType() == 2) {
            node.setNodeValue(value);
        } else {
            while (node.hasChildNodes()) {
                node.removeChild(node.getFirstChild());
            }
            node.appendChild(node.getOwnerDocument().createTextNode(value));
        }
    }

    public static DocumentFragment getDocumentFragment(SAXParser parser, Reader stream) throws ProcessingException {
        DocumentFragment frag = null;
        boolean removeRoot = true;
        try {
            int len;
            StringWriter writer = new StringWriter();
            ((Writer)writer).write(XML_ROOT_DEFINITION);
            char[] cbuf = new char[16384];
            do {
                if ((len = stream.read(cbuf, 0, 16384)) == -1) continue;
                ((Writer)writer).write(cbuf, 0, len);
            } while (len != -1);
            ((Writer)writer).write("</root>");
            String xml = ((Object)writer).toString();
            String searchString = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><root><?xml ";
            if (xml.startsWith(searchString)) {
                xml = xml.substring(XML_ROOT_DEFINITION.length(), xml.length() - 7);
                removeRoot = false;
            }
            StringReader reader = new StringReader(xml);
            InputSource input = new InputSource(reader);
            DOMBuilder builder = new DOMBuilder();
            builder.startDocument();
            builder.startElement("", "root", "root", new AttributesImpl());
            IncludeXMLConsumer filter = new IncludeXMLConsumer(builder, builder);
            parser.parse(input, (ContentHandler)filter);
            builder.endElement("", "root", "root");
            builder.endDocument();
            Document doc = builder.getDocument();
            frag = doc.createDocumentFragment();
            Node root = doc.getDocumentElement().getFirstChild();
            root.normalize();
            if (!removeRoot) {
                root.getParentNode().removeChild(root);
                frag.appendChild(root);
            } else {
                while (root.hasChildNodes()) {
                    Node child = root.getFirstChild();
                    root.removeChild(child);
                    frag.appendChild(child);
                }
            }
        }
        catch (SAXException sax) {
            throw new ProcessingException("SAXException: " + sax, sax);
        }
        catch (IOException ioe) {
            throw new ProcessingException("IOException: " + ioe, ioe);
        }
        return frag;
    }

    public static SourceParameters createParameters(Node fragment, SourceParameters source) {
        NodeList childs;
        SourceParameters par;
        SourceParameters sourceParameters = par = source == null ? new SourceParameters() : source;
        if (fragment != null && (childs = fragment.getChildNodes()) != null) {
            for (int i = 0; i < childs.getLength(); ++i) {
                Node current = childs.item(i);
                if (current.getNodeType() != 1) continue;
                current.normalize();
                NodeList valueChilds = current.getChildNodes();
                String key = current.getNodeName();
                StringBuffer valueBuffer = new StringBuffer();
                for (int m = 0; m < valueChilds.getLength(); ++m) {
                    current = valueChilds.item(m);
                    if (current.getNodeType() != 3) continue;
                    if (valueBuffer.length() > 0) {
                        valueBuffer.append(' ');
                    }
                    valueBuffer.append(current.getNodeValue());
                }
                String value = valueBuffer.toString().trim();
                if (key == null || value == null || value.length() <= 0) continue;
                par.setParameter(key, value);
            }
        }
        return par;
    }

    public static String createText(DocumentFragment fragment) {
        NodeList childs;
        StringBuffer value = new StringBuffer();
        if (fragment != null && (childs = fragment.getChildNodes()) != null) {
            for (int i = 0; i < childs.getLength(); ++i) {
                Node current = childs.item(i);
                if (current.getNodeType() != 3) continue;
                if (value.length() > 0) {
                    value.append(' ');
                }
                value.append(current.getNodeValue());
            }
        }
        return value.toString().trim();
    }

    public static boolean compareAttributes(Element first, Element second) {
        int i;
        int l;
        int attr2Len;
        NamedNodeMap attr1 = first.getAttributes();
        NamedNodeMap attr2 = second.getAttributes();
        if (attr1 == null && attr2 == null) {
            return true;
        }
        int attr1Len = attr1 == null ? 0 : attr1.getLength();
        int n = attr2Len = attr2 == null ? 0 : attr2.getLength();
        if (attr1Len > 0) {
            l = attr1.getLength();
            for (i = 0; i < l; ++i) {
                if (!attr1.item(i).getNodeName().startsWith("xmlns:")) continue;
                --attr1Len;
            }
        }
        if (attr2Len > 0) {
            l = attr2.getLength();
            for (i = 0; i < l; ++i) {
                if (!attr2.item(i).getNodeName().startsWith("xmlns:")) continue;
                --attr2Len;
            }
        }
        if (attr1Len != attr2Len) {
            return false;
        }
        int l2 = attr1.getLength();
        int l22 = attr2.getLength();
        boolean ok = true;
        for (int i2 = 0; i2 < l2 && ok; ++i2) {
            String value = attr1.item(i2).getNodeName();
            if (value.startsWith("xmlns:")) continue;
            ok = false;
            for (int m = 0; m < l22 && !ok; ++m) {
                if (!attr2.item(m).getNodeName().equals(value)) continue;
                ok = attr1.item(i2).getNodeValue().equals(attr2.item(m).getNodeValue());
            }
        }
        return ok;
    }

    public static void valueOf(Node parent, String text) throws ProcessingException {
        if (text != null) {
            parent.appendChild(parent.getOwnerDocument().createTextNode(text));
        }
    }

    public static void valueOf(Node parent, XMLizable v) throws ProcessingException {
        if (v != null) {
            DOMBuilder builder = new DOMBuilder(parent);
            try {
                v.toSAX((ContentHandler)builder);
            }
            catch (SAXException e) {
                throw new ProcessingException(e);
            }
        }
    }

    public static void valueOf(Node parent, Node v) throws ProcessingException {
        if (v != null) {
            parent.appendChild(parent.getOwnerDocument().importNode(v, true));
        }
    }

    public static void valueOf(Node parent, Collection v) throws ProcessingException {
        if (v != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                DOMUtil.valueOf(parent, iterator.next());
            }
        }
    }

    public static void valueOf(Node parent, Map v) throws ProcessingException {
        if (v != null) {
            Iterator iterator = v.keySet().iterator();
            Element mapNode = parent.getOwnerDocument().createElementNS(null, "java.util.map");
            parent.appendChild(mapNode);
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Element entryNode = mapNode.getOwnerDocument().createElementNS(null, "entry");
                mapNode.appendChild(entryNode);
                Element keyNode = entryNode.getOwnerDocument().createElementNS(null, "key");
                entryNode.appendChild(keyNode);
                DOMUtil.valueOf((Node)keyNode, key);
                Element valueNode = entryNode.getOwnerDocument().createElementNS(null, "value");
                entryNode.appendChild(valueNode);
                DOMUtil.valueOf((Node)valueNode, v.get(key));
            }
        }
    }

    public static void valueOf(Node parent, Object v) throws ProcessingException {
        if (v == null) {
            return;
        }
        if (v.getClass().isArray()) {
            Object[] elements = (Object[])v;
            for (int i = 0; i < elements.length; ++i) {
                DOMUtil.valueOf(parent, elements[i]);
            }
            return;
        }
        if (v instanceof XMLizable) {
            DOMUtil.valueOf(parent, (XMLizable)v);
            return;
        }
        if (v instanceof Node) {
            DOMUtil.valueOf(parent, (Node)v);
            return;
        }
        if (v instanceof Collection) {
            DOMUtil.valueOf(parent, (Collection)v);
            return;
        }
        if (v instanceof Map) {
            DOMUtil.valueOf(parent, (Map)v);
            return;
        }
        DOMUtil.valueOf(parent, String.valueOf(v));
    }

    public static Node getSingleNode(Node contextNode, String str) throws TransformerException {
        String[] pathComponents = DOMUtil.buildPathArray(str);
        if (pathComponents == null) {
            return XPathAPI.selectSingleNode((Node)contextNode, (String)str);
        }
        return DOMUtil.getFirstNodeFromPath(contextNode, pathComponents, false);
    }

    public static Node selectSingleNode(Node rootNode, String path) throws ProcessingException {
        int pos;
        if (path == null) {
            throw new ProcessingException("XPath is required.");
        }
        if (rootNode == null) {
            return rootNode;
        }
        if (path.length() == 0 || path.equals("/")) {
            return rootNode;
        }
        try {
            Node testNode = DOMUtil.getSingleNode(rootNode, path);
            if (testNode != null) {
                return testNode;
            }
        }
        catch (TransformerException local) {
            throw new ProcessingException("Transforming exception during selectSingleNode with path: '" + path + "'. Exception: " + local, local);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Node parent = rootNode;
        do {
            Node singleNode;
            String nodeName;
            pos = path.indexOf("/");
            int posSelector = path.indexOf("[");
            if (posSelector != -1 && posSelector < pos) {
                posSelector = path.indexOf("]");
                pos = path.indexOf("/", posSelector);
            }
            boolean isAttribute = false;
            if (pos != -1) {
                nodeName = path.substring(0, pos);
                path = path.substring(pos + 1);
            } else {
                nodeName = path;
            }
            if (nodeName.startsWith("@")) {
                isAttribute = true;
            }
            try {
                singleNode = DOMUtil.getSingleNode(parent, nodeName);
            }
            catch (TransformerException localException) {
                throw new ProcessingException("XPathUtil.selectSingleNode: " + localException.getMessage(), localException);
            }
            if (singleNode == null) {
                Node newNode;
                int posSelect = nodeName.indexOf("[");
                String XPathExp = null;
                if (posSelect != -1) {
                    XPathExp = nodeName.substring(posSelect + 1, nodeName.length() - 1);
                    nodeName = nodeName.substring(0, posSelect);
                }
                if (isAttribute) {
                    try {
                        newNode = DOMUtil.getOwnerDocument(rootNode).createAttributeNS(null, nodeName.substring(1));
                        ((Element)parent).setAttributeNodeNS((Attr)newNode);
                        parent = newNode;
                    }
                    catch (DOMException local) {
                        throw new ProcessingException("Unable to create new DOM node: '" + nodeName + "'.", local);
                    }
                }
                try {
                    newNode = DOMUtil.getOwnerDocument(rootNode).createElementNS(null, nodeName);
                }
                catch (DOMException local) {
                    throw new ProcessingException("Unable to create new DOM node: '" + nodeName + "'.", local);
                }
                if (XPathExp != null) {
                    ArrayList<String> attrValuePairs = new ArrayList<String>(4);
                    boolean noError = true;
                    StringTokenizer tokenizer = new StringTokenizer(XPathExp, "= ");
                    while (tokenizer.hasMoreTokens()) {
                        String attr = tokenizer.nextToken();
                        if (attr.startsWith("@")) {
                            if (tokenizer.hasMoreTokens()) {
                                String value = tokenizer.nextToken();
                                if (value.startsWith("'") && value.endsWith("'")) {
                                    value = value.substring(1, value.length() - 1);
                                }
                                if (value.startsWith("\"") && value.endsWith("\"")) {
                                    value = value.substring(1, value.length() - 1);
                                }
                                attrValuePairs.add(attr.substring(1));
                                attrValuePairs.add(value);
                                continue;
                            }
                            noError = false;
                            continue;
                        }
                        if (attr.trim().equals("and")) continue;
                        noError = false;
                    }
                    if (noError) {
                        for (int l = 0; l < attrValuePairs.size(); l += 2) {
                            newNode.setAttributeNS(null, (String)attrValuePairs.get(l), (String)attrValuePairs.get(l + 1));
                        }
                    }
                }
                parent.appendChild(newNode);
                parent = newNode;
                continue;
            }
            parent = singleNode;
        } while (pos != -1);
        return parent;
    }

    public static String getValueOf(Node root, String path) throws ProcessingException {
        if (path == null) {
            throw new ProcessingException("Not a valid XPath: " + path);
        }
        if (root == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            Node node = DOMUtil.getSingleNode(root, path);
            if (node != null) {
                return DOMUtil.getValueOfNode(node);
            }
        }
        catch (TransformerException localException) {
            throw new ProcessingException("XPathUtil.selectSingleNode: " + localException.getMessage(), localException);
        }
        return null;
    }

    public static String getValueOf(Node root, String path, String defaultValue) throws ProcessingException {
        String value = DOMUtil.getValueOf(root, path);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getValueAsBooleanOf(Node root, String path) throws ProcessingException {
        String value = DOMUtil.getValueOf(root, path);
        if (value == null) {
            throw new ProcessingException("No such node: " + path);
        }
        return Boolean.valueOf(value);
    }

    public static boolean getValueAsBooleanOf(Node root, String path, boolean defaultValue) throws ProcessingException {
        String value = DOMUtil.getValueOf(root, path);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static Document createDocument() throws ProcessingException {
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            documentFactory.setNamespaceAware(true);
            documentFactory.setValidating(false);
            DocumentBuilder docBuilder = documentFactory.newDocumentBuilder();
            return docBuilder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new ProcessingException("Creating document failed.", pce);
        }
    }

    public static NodeList selectNodeList(Node contextNode, String str) throws TransformerException {
        String[] pathComponents = DOMUtil.buildPathArray(str);
        if (pathComponents == null) {
            return XPathAPI.selectNodeList((Node)contextNode, (String)str);
        }
        return DOMUtil.getNodeListFromPath(contextNode, pathComponents);
    }

    public static String[] buildPathArray(String xpath) {
        String[] result = null;
        if (xpath != null && xpath.charAt(0) != '/') {
            int components = 1;
            int l = xpath.length();
            boolean found = false;
            int i = 0;
            block8: while (i < l && !found) {
                switch (xpath.charAt(i)) {
                    case '[': {
                        found = true;
                        continue block8;
                    }
                    case '(': {
                        found = true;
                        continue block8;
                    }
                    case '*': {
                        found = true;
                        continue block8;
                    }
                    case '@': {
                        found = true;
                        continue block8;
                    }
                    case ':': {
                        found = true;
                        continue block8;
                    }
                    case '/': {
                        ++components;
                    }
                }
                ++i;
            }
            if (!found) {
                result = new String[components];
                if (components == 1) {
                    result[components - 1] = xpath;
                } else {
                    int start = 0;
                    components = 0;
                    for (i = 0; i < l; ++i) {
                        if (xpath.charAt(i) != '/') continue;
                        result[components] = xpath.substring(start, i);
                        start = i + 1;
                        ++components;
                    }
                    result[components] = xpath.substring(start);
                }
            }
        }
        return result;
    }

    public static Node getFirstNodeFromPath(Node contextNode, String[] path, boolean create) {
        if (contextNode == null || path == null || path.length == 0) {
            return contextNode;
        }
        Node item = DOMUtil.getFirstNodeFromPath(contextNode, path, 0);
        if (item == null && create) {
            for (int i = 0; contextNode != null && i < path.length; ++i) {
                NodeList childs = contextNode.getChildNodes();
                boolean found = false;
                if (childs != null) {
                    int l = childs.getLength();
                    for (int m = 0; !found && m < l; ++m) {
                        item = childs.item(m);
                        if (item.getNodeType() != 1 || !item.getLocalName().equals(path[i])) continue;
                        found = true;
                        contextNode = item;
                    }
                }
                if (found) continue;
                Element e = contextNode.getOwnerDocument().createElementNS(null, path[i]);
                contextNode.appendChild(e);
                contextNode = e;
            }
            item = contextNode;
        }
        return item;
    }

    private static Node getFirstNodeFromPath(Node contextNode, String[] path, int startIndex) {
        int i = 0;
        Node item = null;
        NodeList childs = contextNode.getChildNodes();
        boolean found = false;
        if (childs != null) {
            i = 0;
            int l = childs.getLength();
            while (!found && i < l) {
                item = childs.item(i);
                if (item.getNodeType() == 1 && path[startIndex].equals(item.getLocalName() != null ? item.getLocalName() : item.getNodeName())) {
                    if (startIndex == path.length - 1) {
                        found = true;
                    } else if ((item = DOMUtil.getFirstNodeFromPath(item, path, startIndex + 1)) != null) {
                        found = true;
                    }
                }
                if (found) continue;
                ++i;
            }
            if (!found) {
                item = null;
            }
        }
        return item;
    }

    public static NodeList getNodeListFromPath(Node contextNode, String[] path) {
        if (contextNode == null) {
            return new NodeListImpl();
        }
        if (path == null || path.length == 0) {
            return new NodeListImpl(new Node[]{contextNode});
        }
        NodeListImpl result = new NodeListImpl();
        try {
            DOMUtil.getNodesFromPath(result, contextNode, path, 0);
        }
        catch (NullPointerException npe) {
            throw new NullPointerException("XMLUtil.getNodeListFromPath() did catch a NullPointerException.This might be due to a missconfigured XML parser which does not use DOM Level 2.Make sure that you use the XML parser shipped with Cocoon.");
        }
        return result;
    }

    private static void getNodesFromPath(NodeListImpl result, Node contextNode, String[] path, int startIndex) {
        block4: {
            NodeList childs;
            block3: {
                childs = contextNode.getChildNodes();
                if (startIndex != path.length - 1) break block3;
                if (childs == null) break block4;
                int l = childs.getLength();
                for (int m = 0; m < l; ++m) {
                    Node item = childs.item(m);
                    if (item.getNodeType() != 1 || !path[startIndex].equals(item.getLocalName() != null ? item.getLocalName() : item.getNodeName())) continue;
                    result.addNode(item);
                }
                break block4;
            }
            if (childs != null) {
                int l = childs.getLength();
                for (int m = 0; m < l; ++m) {
                    Node item = childs.item(m);
                    if (item.getNodeType() != 1 || !path[startIndex].equals(item.getLocalName() != null ? item.getLocalName() : item.getNodeName())) continue;
                    DOMUtil.getNodesFromPath(result, item, path, startIndex + 1);
                }
            }
        }
    }

    public static String node2String(Node node) {
        try {
            return XMLUtils.serializeNodeToXML(node);
        }
        catch (ProcessingException processingException) {
            return "";
        }
    }

    public static String node2String(Node node, boolean pretty) {
        try {
            if (pretty) {
                Properties props = new Properties();
                props.setProperty("indent", "yes");
                return XMLUtils.serializeNode(node, props);
            }
            return XMLUtils.serializeNodeToXML(node);
        }
        catch (ProcessingException processingException) {
            return "";
        }
    }

    public static StringBuffer node2StringBuffer(Node node) {
        return new StringBuffer(DOMUtil.node2String(node));
    }

    public static StringBuffer node2StringBuffer(Node node, boolean pretty, String indent) {
        return new StringBuffer(DOMUtil.node2String(node, pretty));
    }
}

