/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

class TypeBinding
implements ITypeBinding {
    private static final String NO_NAME = "";
    private static final ITypeBinding[] NO_INTERFACES = new ITypeBinding[0];
    private static final ITypeBinding[] NO_DECLARED_TYPES = new ITypeBinding[0];
    private static final IVariableBinding[] NO_DECLARED_FIELDS = new IVariableBinding[0];
    private static final IMethodBinding[] NO_DECLARED_METHODS = new IMethodBinding[0];
    private org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding;
    private BindingResolver resolver;

    public TypeBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding) {
        this.binding = binding;
        this.resolver = resolver;
    }

    public boolean isPrimitive() {
        return !this.isNullType() && this.binding.isBaseType();
    }

    public boolean isArray() {
        return this.binding.isArrayType();
    }

    public ITypeBinding getElementType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.leafComponentType);
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return arrayBinding.dimensions;
    }

    public boolean isClass() {
        return this.binding.isClass();
    }

    public boolean isInterface() {
        return this.binding.isInterface();
    }

    public String getName() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            if (referenceBinding.isAnonymousType()) {
                return NO_NAME;
            }
            if (referenceBinding.isMemberType()) {
                char[] name = referenceBinding.compoundName[referenceBinding.compoundName.length - 1];
                return new String(CharOperation.subarray(name, CharOperation.lastIndexOf('$', name) + 1, name.length));
            }
            if (referenceBinding.isLocalType()) {
                char[] name = referenceBinding.compoundName[referenceBinding.compoundName.length - 1];
                return new String(CharOperation.subarray(name, CharOperation.lastIndexOf('$', name) + 1, name.length));
            }
            return new String(referenceBinding.compoundName[referenceBinding.compoundName.length - 1]);
        }
        if (this.binding.isArrayType()) {
            ArrayBinding arrayBinding = (ArrayBinding)this.binding;
            int dimensions = arrayBinding.dimensions;
            char[] brackets = new char[dimensions * 2];
            int i = dimensions * 2 - 1;
            while (i >= 0) {
                brackets[i] = 93;
                brackets[i - 1] = 91;
                i -= 2;
            }
            StringBuffer buffer = new StringBuffer();
            org.eclipse.jdt.internal.compiler.lookup.TypeBinding leafComponentTypeBinding = arrayBinding.leafComponentType;
            if (leafComponentTypeBinding.isClass() || leafComponentTypeBinding.isInterface()) {
                ReferenceBinding referenceBinding2 = (ReferenceBinding)leafComponentTypeBinding;
                if (referenceBinding2.isMemberType()) {
                    char[] name = referenceBinding2.compoundName[referenceBinding2.compoundName.length - 1];
                    buffer.append(CharOperation.subarray(name, CharOperation.lastIndexOf('$', name) + 1, name.length));
                } else if (referenceBinding2.isLocalType()) {
                    char[] name = referenceBinding2.compoundName[referenceBinding2.compoundName.length - 1];
                    buffer.append(CharOperation.subarray(name, CharOperation.lastIndexOf('$', name) + 1, name.length));
                } else {
                    buffer.append(referenceBinding2.compoundName[referenceBinding2.compoundName.length - 1]);
                }
            } else {
                buffer.append(leafComponentTypeBinding.readableName());
            }
            buffer.append(brackets);
            return buffer.toString();
        }
        return new String(this.binding.readableName());
    }

    public IPackageBinding getPackage() {
        if (this.binding.isBaseType() || this.binding.isArrayType()) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        return this.resolver.getPackageBinding(referenceBinding.getPackage());
    }

    public ITypeBinding getDeclaringClass() {
        if (this.binding.isArrayType() || this.binding.isBaseType()) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        if (referenceBinding.isNestedType()) {
            return this.resolver.getTypeBinding(referenceBinding.enclosingType());
        }
        return null;
    }

    public ITypeBinding getSuperclass() {
        if (this.binding.isArrayType() || this.binding.isBaseType() || this.binding.isInterface()) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        ReferenceBinding superclass = referenceBinding.superclass();
        if (superclass == null) {
            return null;
        }
        return this.resolver.getTypeBinding(superclass);
    }

    public ITypeBinding[] getInterfaces() {
        if (this.binding.isArrayType() || this.binding.isBaseType()) {
            return NO_INTERFACES;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        ReferenceBinding[] interfaces = referenceBinding.superInterfaces();
        int length = interfaces.length;
        if (length == 0) {
            return NO_INTERFACES;
        }
        ITypeBinding[] newInterfaces = new ITypeBinding[length];
        int i = 0;
        while (i < length) {
            newInterfaces[i] = this.resolver.getTypeBinding(interfaces[i]);
            ++i;
        }
        return newInterfaces;
    }

    public int getModifiers() {
        if (this.binding.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            if (referenceBinding.isAnonymousType()) {
                return referenceBinding.getAccessFlags() & 0xFFFFFFEF;
            }
            return referenceBinding.getAccessFlags();
        }
        if (this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.getAccessFlags() & 0xFFFFF9FF;
        }
        return 0;
    }

    public int getDeclaredModifiers() {
        return this.getModifiers();
    }

    public boolean isTopLevel() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return !referenceBinding.isNestedType();
        }
        return false;
    }

    public boolean isNested() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isNestedType();
        }
        return false;
    }

    public boolean isMember() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isLocal() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isLocalType() && !referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isAnonymous() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isAnonymousType();
        }
        return false;
    }

    public ITypeBinding[] getDeclaredTypes() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            ReferenceBinding[] members = referenceBinding.memberTypes();
            int length = members.length;
            ITypeBinding[] newMembers = new ITypeBinding[length];
            int i = 0;
            while (i < length) {
                newMembers[i] = this.resolver.getTypeBinding(members[i]);
                ++i;
            }
            return newMembers;
        }
        return NO_DECLARED_TYPES;
    }

    public IVariableBinding[] getDeclaredFields() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            FieldBinding[] fields = referenceBinding.fields();
            int length = fields.length;
            IVariableBinding[] newFields = new IVariableBinding[length];
            int i = 0;
            while (i < length) {
                newFields[i] = this.resolver.getVariableBinding(fields[i]);
                ++i;
            }
            return newFields;
        }
        return NO_DECLARED_FIELDS;
    }

    public IMethodBinding[] getDeclaredMethods() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            MethodBinding[] methods = referenceBinding.methods();
            int length = methods.length;
            int removeSyntheticsCounter = 0;
            IMethodBinding[] newMethods = new IMethodBinding[length];
            int i = 0;
            while (i < length) {
                MethodBinding methodBinding = methods[i];
                if (!this.shouldBeRemoved(methodBinding)) {
                    newMethods[removeSyntheticsCounter++] = this.resolver.getMethodBinding(methodBinding);
                }
                ++i;
            }
            if (removeSyntheticsCounter != length) {
                IMethodBinding[] iMethodBindingArray = newMethods;
                newMethods = new IMethodBinding[removeSyntheticsCounter];
                System.arraycopy(iMethodBindingArray, 0, newMethods, 0, removeSyntheticsCounter);
            }
            return newMethods;
        }
        return NO_DECLARED_METHODS;
    }

    private boolean shouldBeRemoved(MethodBinding methodBinding) {
        return methodBinding.isDefaultAbstract() || methodBinding.isSynthetic() || methodBinding.isConstructor() && this.isInterface();
    }

    public boolean isFromSource() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return !referenceBinding.isBinaryBinding();
        }
        return false;
    }

    public int getKind() {
        return 2;
    }

    public boolean isDeprecated() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isDeprecated();
        }
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public String getKey() {
        if (this.isLocal()) {
            return null;
        }
        if (this.binding.isClass() || this.binding.isInterface()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getPackage().getName()).append('.').append(this.getName());
            return buffer.toString();
        }
        if (this.binding.isArrayType()) {
            return String.valueOf(this.getElementType().getKey()) + this.getDimensions();
        }
        return this.getName();
    }

    public boolean isNullType() {
        return this.binding == BaseTypes.NullBinding;
    }

    public String getQualifiedName() {
        if (this.isAnonymous() || this.isLocal()) {
            return NO_NAME;
        }
        if (this.isPrimitive() || this.isNullType()) {
            return this.getName();
        }
        if (this.isArray()) {
            ITypeBinding elementType = this.getElementType();
            String elementTypeQualifiedName = elementType.getQualifiedName();
            if (elementTypeQualifiedName.length() != 0) {
                int dimensions = this.getDimensions();
                char[] brackets = new char[dimensions * 2];
                int i = dimensions * 2 - 1;
                while (i >= 0) {
                    brackets[i] = 93;
                    brackets[i - 1] = 91;
                    i -= 2;
                }
                StringBuffer stringBuffer = new StringBuffer(elementTypeQualifiedName);
                stringBuffer.append(brackets);
                return stringBuffer.toString();
            }
            return NO_NAME;
        }
        if (this.isTopLevel() || this.isMember()) {
            PackageBinding packageBinding = this.binding.getPackage();
            if (packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR) {
                return new String(this.binding.qualifiedSourceName());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.binding.qualifiedPackageName()).append('.').append(this.binding.qualifiedSourceName());
            return stringBuffer.toString();
        }
        return NO_NAME;
    }

    public String toString() {
        return this.binding.toString();
    }
}

