/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class CompilerOptions
implements ProblemReasons,
ProblemSeverities {
    public static final String OPTION_LocalVariableAttribute = "org.eclipse.jdt.core.compiler.debug.localVariable";
    public static final String OPTION_LineNumberAttribute = "org.eclipse.jdt.core.compiler.debug.lineNumber";
    public static final String OPTION_SourceFileAttribute = "org.eclipse.jdt.core.compiler.debug.sourceFile";
    public static final String OPTION_PreserveUnusedLocal = "org.eclipse.jdt.core.compiler.codegen.unusedLocal";
    public static final String OPTION_ReportUnreachableCode = "org.eclipse.jdt.core.compiler.problem.unreachableCode";
    public static final String OPTION_ReportInvalidImport = "org.eclipse.jdt.core.compiler.problem.invalidImport";
    public static final String OPTION_ReportMethodWithConstructorName = "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName";
    public static final String OPTION_ReportOverridingPackageDefaultMethod = "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod";
    public static final String OPTION_ReportDeprecation = "org.eclipse.jdt.core.compiler.problem.deprecation";
    public static final String OPTION_ReportDeprecationInDeprecatedCode = "org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode";
    public static final String OPTION_ReportHiddenCatchBlock = "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock";
    public static final String OPTION_ReportUnusedLocal = "org.eclipse.jdt.core.compiler.problem.unusedLocal";
    public static final String OPTION_ReportUnusedParameter = "org.eclipse.jdt.core.compiler.problem.unusedParameter";
    public static final String OPTION_ReportUnusedParameterWhenImplementingAbstract = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract";
    public static final String OPTION_ReportUnusedParameterWhenOverridingConcrete = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete";
    public static final String OPTION_ReportUnusedImport = "org.eclipse.jdt.core.compiler.problem.unusedImport";
    public static final String OPTION_ReportSyntheticAccessEmulation = "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation";
    public static final String OPTION_ReportNoEffectAssignment = "org.eclipse.jdt.core.compiler.problem.noEffectAssignment";
    public static final String OPTION_ReportNonExternalizedStringLiteral = "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral";
    public static final String OPTION_ReportIncompatibleNonInheritedInterfaceMethod = "org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod";
    public static final String OPTION_ReportUnusedPrivateMember = "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember";
    public static final String OPTION_ReportNoImplicitStringConversion = "org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion";
    public static final String OPTION_Source = "org.eclipse.jdt.core.compiler.source";
    public static final String OPTION_TargetPlatform = "org.eclipse.jdt.core.compiler.codegen.targetPlatform";
    public static final String OPTION_ReportAssertIdentifier = "org.eclipse.jdt.core.compiler.problem.assertIdentifier";
    public static final String OPTION_Compliance = "org.eclipse.jdt.core.compiler.compliance";
    public static final String OPTION_Encoding = "org.eclipse.jdt.core.encoding";
    public static final String OPTION_MaxProblemPerUnit = "org.eclipse.jdt.core.compiler.maxProblemPerUnit";
    public static final String OPTION_ReportStaticAccessReceiver = "org.eclipse.jdt.core.compiler.problem.staticAccessReceiver";
    public static final String OPTION_TaskTags = "org.eclipse.jdt.core.compiler.taskTags";
    public static final String OPTION_TaskPriorities = "org.eclipse.jdt.core.compiler.taskPriorities";
    public static final String OPTION_PrivateConstructorAccess = "org.eclipse.jdt.core.compiler.codegen.constructorAccessEmulation";
    public static final String GENERATE = "generate";
    public static final String DO_NOT_GENERATE = "do not generate";
    public static final String PRESERVE = "preserve";
    public static final String OPTIMIZE_OUT = "optimize out";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_1_4 = "1.4";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final int UnreachableCode = 256;
    public static final int ImportProblem = 1024;
    public static final int MethodWithConstructorName = 4096;
    public static final int OverriddenPackageDefaultMethod = 8192;
    public static final int UsingDeprecatedAPI = 16384;
    public static final int MaskedCatchBlock = 32768;
    public static final int UnusedLocalVariable = 65536;
    public static final int UnusedArgument = 131072;
    public static final int NoImplicitStringConversion = 262144;
    public static final int AccessEmulation = 524288;
    public static final int NonExternalizedString = 0x100000;
    public static final int AssertUsedAsAnIdentifier = 0x200000;
    public static final int UnusedImport = 0x400000;
    public static final int StaticAccessReceiver = 0x800000;
    public static final int Task = 0x1000000;
    public static final int NoEffectAssignment = 0x2000000;
    public static final int IncompatibleNonInheritedInterfaceMethod = 0x4000000;
    public static final int UnusedPrivateMember = 0x8000000;
    public int errorThreshold = 1280;
    public int warningThreshold = 69529600;
    public static final int Source = 1;
    public static final int Lines = 2;
    public static final int Vars = 4;
    public int produceDebugAttributes = 3;
    public static final int JDK1_1 = 0;
    public static final int JDK1_2 = 1;
    public static final int JDK1_3 = 2;
    public static final int JDK1_4 = 3;
    public int targetJDK = 0;
    public int complianceLevel = 2;
    public boolean isPrivateConstructorAccessChangingVisibility = false;
    public int sourceLevel = 2;
    public String defaultEncoding = null;
    public boolean verbose = Compiler.DEBUG;
    public boolean produceReferenceInfo = true;
    public boolean preserveAllLocalVariables = false;
    public boolean parseLiteralExpressionsAsConstants = true;
    public String runtimeExceptionNameForCompileError = "java.lang.Error";
    public int maxProblemsPerUnit = 100;
    public char[][] taskTags = null;
    public char[][] taskPriorites = null;
    public boolean reportDeprecationInsideDeprecatedCode = false;
    public boolean reportUnusedParameterWhenImplementingAbstract = false;
    public boolean reportUnusedParameterWhenOverridingConcrete = false;

    public CompilerOptions() {
    }

    public CompilerOptions(Map settings) {
        if (settings == null) {
            return;
        }
        Iterator entries = settings.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String optionID = (String)entry.getKey();
            String optionValue = (String)entry.getValue();
            if (optionID.equals(OPTION_LocalVariableAttribute)) {
                if (optionValue.equals(GENERATE)) {
                    this.produceDebugAttributes |= 4;
                    continue;
                }
                if (!optionValue.equals(DO_NOT_GENERATE)) continue;
                this.produceDebugAttributes &= 0xFFFFFFFB;
                continue;
            }
            if (optionID.equals(OPTION_LineNumberAttribute)) {
                if (optionValue.equals(GENERATE)) {
                    this.produceDebugAttributes |= 2;
                    continue;
                }
                if (!optionValue.equals(DO_NOT_GENERATE)) continue;
                this.produceDebugAttributes &= 0xFFFFFFFD;
                continue;
            }
            if (optionID.equals(OPTION_SourceFileAttribute)) {
                if (optionValue.equals(GENERATE)) {
                    this.produceDebugAttributes |= 1;
                    continue;
                }
                if (!optionValue.equals(DO_NOT_GENERATE)) continue;
                this.produceDebugAttributes &= 0xFFFFFFFE;
                continue;
            }
            if (optionID.equals(OPTION_PreserveUnusedLocal)) {
                if (optionValue.equals(PRESERVE)) {
                    this.preserveAllLocalVariables = true;
                    continue;
                }
                if (!optionValue.equals(OPTIMIZE_OUT)) continue;
                this.preserveAllLocalVariables = false;
                continue;
            }
            if (optionID.equals(OPTION_ReportUnreachableCode)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x100;
                    this.warningThreshold &= 0xFFFFFEFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFFFFEFF;
                    this.warningThreshold |= 0x100;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFFFFEFF;
                this.warningThreshold &= 0xFFFFFEFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportInvalidImport)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x400;
                    this.warningThreshold &= 0xFFFFFBFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFFFFBFF;
                    this.warningThreshold |= 0x400;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFFFFBFF;
                this.warningThreshold &= 0xFFFFFBFF;
                continue;
            }
            if (optionID.equals(OPTION_TargetPlatform)) {
                if (optionValue.equals(VERSION_1_1)) {
                    this.targetJDK = 0;
                    continue;
                }
                if (optionValue.equals(VERSION_1_2)) {
                    this.targetJDK = 1;
                    continue;
                }
                if (optionValue.equals(VERSION_1_3)) {
                    this.targetJDK = 2;
                    continue;
                }
                if (!optionValue.equals(VERSION_1_4)) continue;
                this.targetJDK = 3;
                continue;
            }
            if (optionID.equals(OPTION_Compliance)) {
                if (optionValue.equals(VERSION_1_1)) {
                    this.complianceLevel = 0;
                    continue;
                }
                if (optionValue.equals(VERSION_1_2)) {
                    this.complianceLevel = 1;
                    continue;
                }
                if (optionValue.equals(VERSION_1_3)) {
                    this.complianceLevel = 2;
                    continue;
                }
                if (!optionValue.equals(VERSION_1_4)) continue;
                this.complianceLevel = 3;
                continue;
            }
            if (optionID.equals(OPTION_PrivateConstructorAccess)) {
                if (optionValue.equals(VERSION_1_1)) {
                    this.isPrivateConstructorAccessChangingVisibility = false;
                    continue;
                }
                if (optionValue.equals(VERSION_1_2)) {
                    this.isPrivateConstructorAccessChangingVisibility = false;
                    continue;
                }
                if (optionValue.equals(VERSION_1_3)) {
                    this.isPrivateConstructorAccessChangingVisibility = true;
                    continue;
                }
                if (!optionValue.equals(VERSION_1_4)) continue;
                this.isPrivateConstructorAccessChangingVisibility = true;
                continue;
            }
            if (optionID.equals(OPTION_ReportMethodWithConstructorName)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x1000;
                    this.warningThreshold &= 0xFFFFEFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFFFEFFF;
                    this.warningThreshold |= 0x1000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFFFEFFF;
                this.warningThreshold &= 0xFFFFEFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportOverridingPackageDefaultMethod)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x2000;
                    this.warningThreshold &= 0xFFFFDFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFFFDFFF;
                    this.warningThreshold |= 0x2000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFFFDFFF;
                this.warningThreshold &= 0xFFFFDFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportDeprecation)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x4000;
                    this.warningThreshold &= 0xFFFFBFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFFFBFFF;
                    this.warningThreshold |= 0x4000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFFFBFFF;
                this.warningThreshold &= 0xFFFFBFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportDeprecationInDeprecatedCode)) {
                if (optionValue.equals(ENABLED)) {
                    this.reportDeprecationInsideDeprecatedCode = true;
                    continue;
                }
                if (!optionValue.equals(DISABLED)) continue;
                this.reportDeprecationInsideDeprecatedCode = false;
                continue;
            }
            if (optionID.equals(OPTION_ReportHiddenCatchBlock)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x8000;
                    this.warningThreshold &= 0xFFFF7FFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFFF7FFF;
                    this.warningThreshold |= 0x8000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFFF7FFF;
                this.warningThreshold &= 0xFFFF7FFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportUnusedLocal)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x10000;
                    this.warningThreshold &= 0xFFFEFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFFEFFFF;
                    this.warningThreshold |= 0x10000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFFEFFFF;
                this.warningThreshold &= 0xFFFEFFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportNoImplicitStringConversion)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x40000;
                    this.warningThreshold &= 0xFFFBFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFFBFFFF;
                    this.warningThreshold |= 0x40000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFFBFFFF;
                this.warningThreshold &= 0xFFFBFFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportUnusedParameter)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x20000;
                    this.warningThreshold &= 0xFFFDFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFFDFFFF;
                    this.warningThreshold |= 0x20000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFFDFFFF;
                this.warningThreshold &= 0xFFFDFFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportUnusedParameterWhenImplementingAbstract)) {
                if (optionValue.equals(ENABLED)) {
                    this.reportUnusedParameterWhenImplementingAbstract = true;
                    continue;
                }
                if (!optionValue.equals(DISABLED)) continue;
                this.reportUnusedParameterWhenImplementingAbstract = false;
                continue;
            }
            if (optionID.equals(OPTION_ReportUnusedParameterWhenOverridingConcrete)) {
                if (optionValue.equals(ENABLED)) {
                    this.reportUnusedParameterWhenOverridingConcrete = true;
                    continue;
                }
                if (!optionValue.equals(DISABLED)) continue;
                this.reportUnusedParameterWhenOverridingConcrete = false;
                continue;
            }
            if (optionID.equals(OPTION_ReportUnusedImport)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x400000;
                    this.warningThreshold &= 0xFFBFFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFBFFFFF;
                    this.warningThreshold |= 0x400000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFBFFFFF;
                this.warningThreshold &= 0xFFBFFFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportSyntheticAccessEmulation)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x80000;
                    this.warningThreshold &= 0xFFF7FFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFF7FFFF;
                    this.warningThreshold |= 0x80000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFF7FFFF;
                this.warningThreshold &= 0xFFF7FFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportNonExternalizedStringLiteral)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x100000;
                    this.warningThreshold &= 0xFFEFFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFEFFFFF;
                    this.warningThreshold |= 0x100000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFEFFFFF;
                this.warningThreshold &= 0xFFEFFFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportAssertIdentifier)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x200000;
                    this.warningThreshold &= 0xFFDFFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFFDFFFFF;
                    this.warningThreshold |= 0x200000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFFDFFFFF;
                this.warningThreshold &= 0xFFDFFFFF;
                continue;
            }
            if (optionID.equals(OPTION_Source)) {
                if (optionValue.equals(VERSION_1_3)) {
                    this.sourceLevel = 2;
                    continue;
                }
                if (!optionValue.equals(VERSION_1_4)) continue;
                this.sourceLevel = 3;
                continue;
            }
            if (optionID.equals(OPTION_Encoding)) {
                if (optionValue.length() == 0) {
                    this.defaultEncoding = null;
                    continue;
                }
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), optionValue);
                    this.defaultEncoding = optionValue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                continue;
            }
            if (optionID.equals(OPTION_MaxProblemPerUnit)) {
                try {
                    int val = Integer.parseInt(optionValue);
                    if (val < 0) continue;
                    this.maxProblemsPerUnit = val;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (optionID.equals(OPTION_ReportStaticAccessReceiver)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x800000;
                    this.warningThreshold &= 0xFF7FFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFF7FFFFF;
                    this.warningThreshold |= 0x800000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFF7FFFFF;
                this.warningThreshold &= 0xFF7FFFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportIncompatibleNonInheritedInterfaceMethod)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x4000000;
                    this.warningThreshold &= 0xFBFFFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFBFFFFFF;
                    this.warningThreshold |= 0x4000000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFBFFFFFF;
                this.warningThreshold &= 0xFBFFFFFF;
                continue;
            }
            if (optionID.equals(OPTION_ReportUnusedPrivateMember)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x8000000;
                    this.warningThreshold &= 0xF7FFFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xF7FFFFFF;
                    this.warningThreshold |= 0x8000000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xF7FFFFFF;
                this.warningThreshold &= 0xF7FFFFFF;
                continue;
            }
            if (optionID.equals(OPTION_TaskTags)) {
                if (optionValue.length() == 0) {
                    this.taskTags = null;
                    continue;
                }
                this.taskTags = CharOperation.splitAndTrimOn(',', optionValue.toCharArray());
                continue;
            }
            if (optionID.equals(OPTION_ReportNoEffectAssignment)) {
                if (optionValue.equals(ERROR)) {
                    this.errorThreshold |= 0x2000000;
                    this.warningThreshold &= 0xFDFFFFFF;
                    continue;
                }
                if (optionValue.equals(WARNING)) {
                    this.errorThreshold &= 0xFDFFFFFF;
                    this.warningThreshold |= 0x2000000;
                    continue;
                }
                if (!optionValue.equals(IGNORE)) continue;
                this.errorThreshold &= 0xFDFFFFFF;
                this.warningThreshold &= 0xFDFFFFFF;
                continue;
            }
            if (!optionID.equals(OPTION_TaskPriorities)) continue;
            this.taskPriorites = (char[][])(optionValue.length() == 0 ? null : CharOperation.splitAndTrimOn(',', optionValue.toCharArray()));
        }
    }

    public int getSeverity(int irritant) {
        if ((this.warningThreshold & irritant) != 0) {
            return 0;
        }
        if ((this.errorThreshold & irritant) != 0) {
            return 1;
        }
        return -1;
    }

    public void produceReferenceInfo(boolean flag) {
        this.produceReferenceInfo = flag;
    }

    public void setVerboseMode(boolean flag) {
        this.verbose = flag;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("CompilerOptions:");
        if ((this.produceDebugAttributes & 4) != 0) {
            buf.append("\n-local variables debug attributes: ON");
        } else {
            buf.append("\n-local variables debug attributes: OFF");
        }
        if ((this.produceDebugAttributes & 2) != 0) {
            buf.append("\n-line number debug attributes: ON");
        } else {
            buf.append("\n-line number debug attributes: OFF");
        }
        if ((this.produceDebugAttributes & 1) != 0) {
            buf.append("\n-source debug attributes: ON");
        } else {
            buf.append("\n-source debug attributes: OFF");
        }
        if (this.preserveAllLocalVariables) {
            buf.append("\n-preserve all local variables: ON");
        } else {
            buf.append("\n-preserve all local variables: OFF");
        }
        if ((this.errorThreshold & 0x100) != 0) {
            buf.append("\n-unreachable code: ERROR");
        } else if ((this.warningThreshold & 0x100) != 0) {
            buf.append("\n-unreachable code: WARNING");
        } else {
            buf.append("\n-unreachable code: IGNORE");
        }
        if ((this.errorThreshold & 0x400) != 0) {
            buf.append("\n-import problem: ERROR");
        } else if ((this.warningThreshold & 0x400) != 0) {
            buf.append("\n-import problem: WARNING");
        } else {
            buf.append("\n-import problem: IGNORE");
        }
        if ((this.errorThreshold & 0x1000) != 0) {
            buf.append("\n-method with constructor name: ERROR");
        } else if ((this.warningThreshold & 0x1000) != 0) {
            buf.append("\n-method with constructor name: WARNING");
        } else {
            buf.append("\n-method with constructor name: IGNORE");
        }
        if ((this.errorThreshold & 0x2000) != 0) {
            buf.append("\n-overridden package default method: ERROR");
        } else if ((this.warningThreshold & 0x2000) != 0) {
            buf.append("\n-overridden package default method: WARNING");
        } else {
            buf.append("\n-overridden package default method: IGNORE");
        }
        if ((this.errorThreshold & 0x4000) != 0) {
            buf.append("\n-deprecation: ERROR");
        } else if ((this.warningThreshold & 0x4000) != 0) {
            buf.append("\n-deprecation: WARNING");
        } else {
            buf.append("\n-deprecation: IGNORE");
        }
        if ((this.errorThreshold & 0x8000) != 0) {
            buf.append("\n-masked catch block: ERROR");
        } else if ((this.warningThreshold & 0x8000) != 0) {
            buf.append("\n-masked catch block: WARNING");
        } else {
            buf.append("\n-masked catch block: IGNORE");
        }
        if ((this.errorThreshold & 0x10000) != 0) {
            buf.append("\n-unused local variable: ERROR");
        } else if ((this.warningThreshold & 0x10000) != 0) {
            buf.append("\n-unused local variable: WARNING");
        } else {
            buf.append("\n-unused local variable: IGNORE");
        }
        if ((this.errorThreshold & 0x20000) != 0) {
            buf.append("\n-unused parameter: ERROR");
        } else if ((this.warningThreshold & 0x20000) != 0) {
            buf.append("\n-unused parameter: WARNING");
        } else {
            buf.append("\n-unused parameter: IGNORE");
        }
        if ((this.errorThreshold & 0x400000) != 0) {
            buf.append("\n-unused import: ERROR");
        } else if ((this.warningThreshold & 0x400000) != 0) {
            buf.append("\n-unused import: WARNING");
        } else {
            buf.append("\n-unused import: IGNORE");
        }
        if ((this.errorThreshold & 0x80000) != 0) {
            buf.append("\n-synthetic access emulation: ERROR");
        } else if ((this.warningThreshold & 0x80000) != 0) {
            buf.append("\n-synthetic access emulation: WARNING");
        } else {
            buf.append("\n-synthetic access emulation: IGNORE");
        }
        if ((this.errorThreshold & 0x2000000) != 0) {
            buf.append("\n-assignment with no effect: ERROR");
        } else if ((this.warningThreshold & 0x2000000) != 0) {
            buf.append("\n-assignment with no effect: WARNING");
        } else {
            buf.append("\n-assignment with no effect: IGNORE");
        }
        if ((this.errorThreshold & 0x100000) != 0) {
            buf.append("\n-non externalized string: ERROR");
        } else if ((this.warningThreshold & 0x100000) != 0) {
            buf.append("\n-non externalized string: WARNING");
        } else {
            buf.append("\n-non externalized string: IGNORE");
        }
        if ((this.errorThreshold & 0x800000) != 0) {
            buf.append("\n-static access receiver: ERROR");
        } else if ((this.warningThreshold & 0x800000) != 0) {
            buf.append("\n-static access receiver: WARNING");
        } else {
            buf.append("\n-static access receiver: IGNORE");
        }
        if ((this.errorThreshold & 0x4000000) != 0) {
            buf.append("\n-incompatible non inherited interface method: ERROR");
        } else if ((this.warningThreshold & 0x4000000) != 0) {
            buf.append("\n-incompatible non inherited interface method: WARNING");
        } else {
            buf.append("\n-incompatible non inherited interface method: IGNORE");
        }
        if ((this.errorThreshold & 0x8000000) != 0) {
            buf.append("\n-unused private member: ERROR");
        } else if ((this.warningThreshold & 0x8000000) != 0) {
            buf.append("\n-unused private member: WARNING");
        } else {
            buf.append("\n-unused private member: IGNORE");
        }
        switch (this.targetJDK) {
            case 0: {
                buf.append("\n-target JDK: 1.1");
                break;
            }
            case 1: {
                buf.append("\n-target JDK: 1.2");
                break;
            }
            case 2: {
                buf.append("\n-target JDK: 1.3");
                break;
            }
            case 3: {
                buf.append("\n-target JDK: 1.4");
            }
        }
        switch (this.complianceLevel) {
            case 0: {
                buf.append("\n-compliance JDK: 1.1");
                break;
            }
            case 1: {
                buf.append("\n-compliance JDK: 1.2");
                break;
            }
            case 2: {
                buf.append("\n-compliance JDK: 1.3");
                break;
            }
            case 3: {
                buf.append("\n-compliance JDK: 1.4");
            }
        }
        if (this.isPrivateConstructorAccessChangingVisibility) {
            buf.append("\n-private constructor access emulation: extra argument");
        } else {
            buf.append("\n-private constructor access emulation: make default access");
        }
        buf.append("\n-verbose : " + (this.verbose ? "ON" : "OFF"));
        buf.append("\n-produce reference info : " + (this.produceReferenceInfo ? "ON" : "OFF"));
        buf.append("\n-parse literal expressions as constants : " + (this.parseLiteralExpressionsAsConstants ? "ON" : "OFF"));
        buf.append("\n-runtime exception name for compile error : " + this.runtimeExceptionNameForCompileError);
        buf.append("\n-encoding : " + (this.defaultEncoding == null ? "<default>" : this.defaultEncoding));
        buf.append("\n-task tags: " + (this.taskTags == null ? "" : new String(CharOperation.concatWith(this.taskTags, ','))));
        buf.append("\n-task priorities : " + (this.taskPriorites == null ? "" : new String(CharOperation.concatWith(this.taskPriorites, ','))));
        buf.append("\n-report deprecation inside deprecated code : " + (this.reportDeprecationInsideDeprecatedCode ? "ENABLED" : "DISABLED"));
        buf.append("\n-report unused parameter when implementing abstract method : " + (this.reportUnusedParameterWhenImplementingAbstract ? "ENABLED" : "DISABLED"));
        buf.append("\n-report unused parameter when overriding concrete method : " + (this.reportUnusedParameterWhenOverridingConcrete ? "ENABLED" : "DISABLED"));
        return buf.toString();
    }
}

