/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredMethod
extends RecoveredElement
implements CompilerModifiers,
TerminalTokens,
BaseTypes {
    public AbstractMethodDeclaration methodDeclaration;
    public RecoveredType[] localTypes;
    public int localTypeCount;
    public RecoveredBlock methodBody;
    public boolean discardBody = true;

    public RecoveredMethod(AbstractMethodDeclaration methodDeclaration, RecoveredElement parent, int bracketBalance, Parser parser) {
        super(parent, bracketBalance, parser);
        this.methodDeclaration = methodDeclaration;
        boolean bl = this.foundOpeningBrace = !this.bodyStartsAtHeaderEnd();
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
    }

    public RecoveredElement add(Block nestedBlockDeclaration, int bracketBalance) {
        if (this.methodDeclaration.declarationSourceEnd > 0 && nestedBlockDeclaration.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(nestedBlockDeclaration, bracketBalance);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        this.methodBody = new RecoveredBlock(nestedBlockDeclaration, (RecoveredElement)this, bracketBalance);
        if (nestedBlockDeclaration.sourceEnd == 0) {
            return this.methodBody;
        }
        return this;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int bracketBalance) {
        char[][] fieldTypeName;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (fieldTypeName = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(fieldTypeName[0], BaseTypes.VoidBinding.sourceName())) {
            if (this.parent == null) {
                return this;
            }
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, bracketBalance);
        }
        if (this.methodDeclaration.declarationSourceEnd > 0 && fieldDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(fieldDeclaration, bracketBalance);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int bracketBalance) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && localDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(localDeclaration, bracketBalance);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement currentBlock = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int i = 0;
                while (i < this.bracketBalance - 1) {
                    currentBlock = currentBlock.add(new Block(0), 1);
                    ++i;
                }
                this.bracketBalance = 1;
            }
            return currentBlock.add(localDeclaration, bracketBalance);
        }
        return this.methodBody.add(localDeclaration, bracketBalance, true);
    }

    public RecoveredElement add(Statement statement, int bracketBalance) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && statement.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(statement, bracketBalance);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement currentBlock = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int i = 0;
                while (i < this.bracketBalance - 1) {
                    currentBlock = currentBlock.add(new Block(0), 1);
                    ++i;
                }
                this.bracketBalance = 1;
            }
            return currentBlock.add(statement, bracketBalance);
        }
        return this.methodBody.add(statement, bracketBalance, true);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalance) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(typeDeclaration, bracketBalance);
        }
        if (typeDeclaration instanceof LocalTypeDeclaration) {
            if (this.methodBody == null) {
                Block block = new Block(0);
                block.sourceStart = this.methodDeclaration.bodyStart;
                this.add(block, 1);
            }
            return this.methodBody.add(typeDeclaration, bracketBalance, true);
        }
        if (this.localTypes == null) {
            this.localTypes = new RecoveredType[5];
            this.localTypeCount = 0;
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new RecoveredType[2 * this.localTypeCount];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        RecoveredType element = new RecoveredType(typeDeclaration, (RecoveredElement)this, bracketBalance);
        this.localTypes[this.localTypeCount++] = element;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return element;
    }

    public boolean bodyStartsAtHeaderEnd() {
        return this.methodDeclaration.bodyStart == this.methodDeclaration.sourceEnd + 1;
    }

    public AstNode parseTree() {
        return this.methodDeclaration;
    }

    public int sourceEnd() {
        return this.methodDeclaration.declarationSourceEnd;
    }

    public String toString(int tab) {
        StringBuffer result = new StringBuffer(this.tabString(tab));
        result.append("Recovered method:\n");
        result.append(this.methodDeclaration.toString(tab + 1));
        if (this.localTypes != null) {
            int i = 0;
            while (i < this.localTypeCount) {
                result.append("\n");
                result.append(this.localTypes[i].toString(tab + 1));
                ++i;
            }
        }
        if (this.methodBody != null) {
            result.append("\n");
            result.append(this.methodBody.toString(tab + 1));
        }
        return result.toString();
    }

    public void updateBodyStart(int bodyStart) {
        this.foundOpeningBrace = true;
        this.methodDeclaration.bodyStart = bodyStart;
    }

    public AbstractMethodDeclaration updatedMethodDeclaration() {
        Block block;
        if (this.methodBody != null && (block = this.methodBody.updatedBlock()) != null) {
            this.methodDeclaration.statements = block.statements;
            if (this.methodDeclaration.isConstructor()) {
                ConstructorDeclaration constructor = (ConstructorDeclaration)this.methodDeclaration;
                if (this.methodDeclaration.statements != null && this.methodDeclaration.statements[0] instanceof ExplicitConstructorCall) {
                    constructor.constructorCall = (ExplicitConstructorCall)this.methodDeclaration.statements[0];
                    int length = this.methodDeclaration.statements.length;
                    this.methodDeclaration.statements = new Statement[length - 1];
                    System.arraycopy(this.methodDeclaration.statements, 1, this.methodDeclaration.statements, 0, length - 1);
                }
                if (constructor.constructorCall == null) {
                    constructor.constructorCall = SuperReference.implicitSuperConstructorCall();
                }
            }
        }
        if (this.localTypeCount > 0) {
            this.methodDeclaration.bits |= 2;
        }
        return this.methodDeclaration;
    }

    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd()) {
            Parser parser = this.parser();
            if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                if (this.methodDeclaration.sourceEnd == parser.rParenPos) {
                    boolean canConsume;
                    int length = parser.astLengthStack[parser.astLengthPtr];
                    int astPtr = parser.astPtr - length;
                    boolean bl = canConsume = astPtr >= 0;
                    if (canConsume) {
                        if (!(parser.astStack[astPtr] instanceof AbstractMethodDeclaration)) {
                            canConsume = false;
                        }
                        int i = 1;
                        int max = length + 1;
                        while (i < max) {
                            if (!(parser.astStack[astPtr + i] instanceof TypeReference)) {
                                canConsume = false;
                            }
                            ++i;
                        }
                    }
                    if (canConsume) {
                        parser.consumeMethodHeaderThrowsClause();
                    } else {
                        parser.listLength = 0;
                    }
                } else {
                    if (parser.currentToken == 10 || parser.currentToken == 41) {
                        int n = parser.astLengthPtr;
                        parser.astLengthStack[n] = parser.astLengthStack[n] - 1;
                        --parser.astPtr;
                        --parser.listLength;
                        parser.currentToken = 0;
                    }
                    int argLength = parser.astLengthStack[parser.astLengthPtr];
                    int argStart = parser.astPtr - argLength + 1;
                    boolean needUpdateRParenPos = parser.rParenPos < parser.lParenPos;
                    int count = 0;
                    while (count < argLength) {
                        Argument argument = (Argument)parser.astStack[argStart + count];
                        char[][] argTypeName = argument.type.getTypeName();
                        if ((argument.modifiers & 0xFFFFFFEF) != 0 || argTypeName.length == 1 && CharOperation.equals(argTypeName[0], BaseTypes.VoidBinding.sourceName())) {
                            parser.astLengthStack[parser.astLengthPtr] = count;
                            parser.astPtr = argStart + count - 1;
                            parser.listLength = count;
                            parser.currentToken = 0;
                            break;
                        }
                        if (needUpdateRParenPos) {
                            parser.rParenPos = argument.sourceEnd + 1;
                        }
                        ++count;
                    }
                    if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                        boolean canConsume;
                        int length = parser.astLengthStack[parser.astLengthPtr];
                        int astPtr = parser.astPtr - length;
                        boolean bl = canConsume = astPtr >= 0;
                        if (canConsume) {
                            if (!(parser.astStack[astPtr] instanceof AbstractMethodDeclaration)) {
                                canConsume = false;
                            }
                            int i = 1;
                            int max = length + 1;
                            while (i < max) {
                                if (!(parser.astStack[astPtr + i] instanceof Argument)) {
                                    canConsume = false;
                                }
                                ++i;
                            }
                        }
                        if (canConsume) {
                            parser.consumeMethodHeaderParameters();
                            if (parser.currentElement == this) {
                                this.methodDeclaration.sourceEnd = this.methodDeclaration.arguments[this.methodDeclaration.arguments.length - 1].sourceEnd;
                                parser.lastCheckPoint = this.methodDeclaration.bodyStart = this.methodDeclaration.sourceEnd + 1;
                            }
                        }
                    }
                }
            }
        }
    }

    public RecoveredElement updateOnOpeningBrace(int braceEnd) {
        if (this.bracketBalance == 0) {
            switch (this.parser().lastIgnoredToken) {
                case -1: 
                case 227: {
                    break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        return super.updateOnOpeningBrace(braceEnd);
    }

    public void updateParseTree() {
        this.updatedMethodDeclaration();
    }

    public void updateSourceEndIfNecessary(int sourceEnd) {
        if (this.methodDeclaration.declarationSourceEnd == 0) {
            this.methodDeclaration.declarationSourceEnd = sourceEnd;
            this.methodDeclaration.bodyEnd = sourceEnd;
        }
    }
}

