/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;

public class SuperInterfaceReferencePattern
extends SuperTypeReferencePattern {
    public SuperInterfaceReferencePattern(char[] superQualification, char[] superSimpleName, int matchMode, boolean isCaseSensitive) {
        super(superQualification, superSimpleName, matchMode, isCaseSensitive);
    }

    protected boolean matchIndexEntry() {
        return this.decodedSuperClassOrInterface == 'I' && super.matchIndexEntry();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SuperInterfaceReferencePattern: <");
        if (this.superSimpleName != null) {
            buffer.append(this.superSimpleName);
        }
        buffer.append(">, ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    public boolean matchesBinary(Object binaryInfo, Object enclosingBinaryInfo) {
        if (!(binaryInfo instanceof IBinaryType)) {
            return false;
        }
        IBinaryType type = (IBinaryType)binaryInfo;
        char[][] superInterfaces = type.getInterfaceNames();
        if (superInterfaces != null) {
            int i = 0;
            int max = superInterfaces.length;
            while (i < max) {
                char[] superInterfaceName = (char[])superInterfaces[i].clone();
                CharOperation.replace(superInterfaceName, '/', '.');
                if (this.matchesType(this.superSimpleName, this.superQualification, superInterfaceName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int matchLevel(Binding binding) {
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof ReferenceBinding)) {
            return 0;
        }
        int level = 0;
        ReferenceBinding type = (ReferenceBinding)binding;
        ReferenceBinding[] superInterfaces = type.superInterfaces();
        int i = 0;
        int max = superInterfaces.length;
        while (i < max) {
            int newLevel = this.matchLevelForType(this.superSimpleName, this.superQualification, superInterfaces[i]);
            switch (newLevel) {
                case 0: {
                    break;
                }
                case 2: {
                    return 2;
                }
                default: {
                    level = newLevel;
                }
            }
            ++i;
        }
        return level;
    }
}

