/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.LengthRange;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableFooter;
import org.apache.fop.fo.flow.TableHeader;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;

public class Table
extends FObj {
    private static final int MINCOLWIDTH = 10000;
    int breakBefore;
    int breakAfter;
    int spaceBefore;
    int spaceAfter;
    LengthRange ipd;
    int height;
    String id;
    TableHeader tableHeader = null;
    TableFooter tableFooter = null;
    boolean omitHeaderAtBreak = false;
    boolean omitFooterAtBreak = false;
    ArrayList columns = new ArrayList();
    int bodyCount = 0;
    private boolean bAutoLayout = false;
    private int contentWidth = 0;
    private int optIPD;
    private int minIPD;
    private int maxIPD;
    AreaContainer areaContainer;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public Table(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:table";
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1001) {
            return 1;
        }
        if (this.marker == -1000) {
            AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
            AuralProps mAurProps = this.propMgr.getAuralProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            MarginProps mProps = this.propMgr.getMarginProps();
            RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.ipd = this.properties.get("inline-progression-dimension").getLengthRange();
            this.height = this.properties.get("height").getLength().mvalue();
            this.bAutoLayout = this.properties.get("table-layout").getEnum() == 8;
            this.id = this.properties.get("id").getString();
            this.omitHeaderAtBreak = this.properties.get("table-omit-header-at-break").getEnum() == 120;
            boolean bl = this.omitFooterAtBreak = this.properties.get("table-omit-footer-at-break").getEnum() == 120;
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.areaContainer == null) {
                try {
                    area.getIDReferences().createID(this.id);
                }
                catch (FOPException e) {
                    if (!e.isLocationSet()) {
                        e.setLocation(this.systemId, this.line, this.column);
                    }
                    throw e;
                }
            }
            this.marker = 0;
            if (this.breakBefore == 83) {
                return 4;
            }
            if (this.breakBefore == 80) {
                return 6;
            }
            if (this.breakBefore == 35) {
                return 5;
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.marker == 0 && this.areaContainer == null) {
            area.getIDReferences().configureID(this.id, area);
        }
        int spaceLeft = area.spaceLeft();
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), 0, 0, area.getAllocationWidth(), area.spaceLeft(), 107);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setParent(area);
        this.areaContainer.setBackground(this.propMgr.getBackgroundProps());
        this.areaContainer.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        boolean addedHeader = false;
        boolean addedFooter = false;
        int numChildren = this.children.size();
        if (this.columns.size() == 0) {
            this.findColumns(this.areaContainer);
            if (this.bAutoLayout) {
                this.log.warn("table-layout=auto is not supported, using fixed!");
            }
            this.contentWidth = this.calcFixedColumnWidths(this.areaContainer.getAllocationWidth());
        }
        this.areaContainer.setAllocationWidth(this.contentWidth);
        this.layoutColumns(this.areaContainer);
        int i = this.marker;
        while (i < numChildren) {
            FONode fo = (FONode)this.children.get(i);
            if (fo instanceof Marker) {
                ((Marker)fo).layout(area);
            } else if (fo instanceof TableHeader) {
                if (this.columns.size() == 0) {
                    this.log.warn("current implementation of tables requires a table-column for each column, indicating column-width");
                    return 1;
                }
                this.tableHeader = (TableHeader)fo;
                this.tableHeader.setColumns(this.columns);
            } else if (fo instanceof TableFooter) {
                if (this.columns.size() == 0) {
                    this.log.warn("current implementation of tables requires a table-column for each column, indicating column-width");
                    return 1;
                }
                this.tableFooter = (TableFooter)fo;
                this.tableFooter.setColumns(this.columns);
            } else if (fo instanceof TableBody) {
                int status;
                if (this.columns.size() == 0) {
                    this.log.warn("current implementation of tables requires a table-column for each column, indicating column-width");
                    return 1;
                }
                if (this.tableHeader != null && !addedHeader) {
                    status = this.tableHeader.layout(this.areaContainer);
                    if (Status.isIncomplete(status)) {
                        this.tableHeader.resetMarker();
                        return 2;
                    }
                    addedHeader = true;
                    this.tableHeader.resetMarker();
                    area.setMaxHeight(area.getMaxHeight() - spaceLeft + this.areaContainer.getMaxHeight());
                }
                if (this.tableFooter != null && !this.omitFooterAtBreak && !addedFooter) {
                    status = this.tableFooter.layout(this.areaContainer);
                    if (Status.isIncomplete(status)) {
                        return 2;
                    }
                    addedFooter = true;
                    this.tableFooter.resetMarker();
                }
                ((TableBody)fo).setColumns(this.columns);
                status = fo.layout(this.areaContainer);
                if (Status.isIncomplete(status)) {
                    this.marker = i;
                    if (this.bodyCount == 0 && status == 2) {
                        if (this.tableHeader != null) {
                            this.tableHeader.removeLayout(this.areaContainer);
                        }
                        if (this.tableFooter != null) {
                            this.tableFooter.removeLayout(this.areaContainer);
                        }
                        this.resetMarker();
                    }
                    if (this.areaContainer.getContentHeight() > 0) {
                        area.addChild(this.areaContainer);
                        area.increaseHeight(this.areaContainer.getHeight());
                        if (this.omitHeaderAtBreak) {
                            this.tableHeader = null;
                        }
                        if (this.tableFooter != null && !this.omitFooterAtBreak) {
                            ((TableBody)fo).setYPosition(this.tableFooter.getYPosition());
                            this.tableFooter.setYPosition(this.tableFooter.getYPosition() + ((TableBody)fo).getHeight());
                        }
                        this.setupColumnHeights();
                        status = 3;
                        ++this.areasGenerated;
                    }
                    return status;
                }
                ++this.bodyCount;
                area.setMaxHeight(area.getMaxHeight() - spaceLeft + this.areaContainer.getMaxHeight());
                if (this.tableFooter != null && !this.omitFooterAtBreak) {
                    ((TableBody)fo).setYPosition(this.tableFooter.getYPosition());
                    this.tableFooter.setYPosition(this.tableFooter.getYPosition() + ((TableBody)fo).getHeight());
                }
            }
            ++i;
        }
        ++this.areasGenerated;
        if (this.tableFooter != null && this.omitFooterAtBreak && Status.isIncomplete(this.tableFooter.layout(this.areaContainer))) {
            this.log.warn("footer could not fit on page, moving last body row to next page");
            area.addChild(this.areaContainer);
            area.increaseHeight(this.areaContainer.getHeight());
            if (this.omitHeaderAtBreak) {
                this.tableHeader = null;
            }
            this.tableFooter.removeLayout(this.areaContainer);
            this.tableFooter.resetMarker();
            return 3;
        }
        if (this.height != 0) {
            this.areaContainer.setHeight(this.height);
        }
        this.setupColumnHeights();
        this.areaContainer.end();
        area.addChild(this.areaContainer);
        area.increaseHeight(this.areaContainer.getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 83) {
            this.marker = -1001;
            return 4;
        }
        if (this.breakAfter == 80) {
            this.marker = -1001;
            return 6;
        }
        if (this.breakAfter == 35) {
            this.marker = -1001;
            return 5;
        }
        return 1;
    }

    protected void setupColumnHeights() {
        int i = 0;
        while (i < this.columns.size()) {
            TableColumn c = (TableColumn)this.columns.get(i);
            if (c != null) {
                c.setHeight(this.areaContainer.getContentHeight());
            }
            ++i;
        }
    }

    private void findColumns(Area areaContainer) throws FOPException {
        int nextColumnNumber = 1;
        int i = 0;
        while (i < this.children.size()) {
            FONode fo = (FONode)this.children.get(i);
            if (fo instanceof TableColumn) {
                TableColumn c = (TableColumn)fo;
                c.doSetup(areaContainer);
                int numColumnsRepeated = c.getNumColumnsRepeated();
                int currentColumnNumber = c.getColumnNumber();
                if (currentColumnNumber == 0) {
                    currentColumnNumber = nextColumnNumber;
                }
                if (currentColumnNumber + numColumnsRepeated > this.columns.size()) {
                    this.columns.ensureCapacity(currentColumnNumber + numColumnsRepeated);
                }
                int j = 0;
                while (j < numColumnsRepeated) {
                    if (currentColumnNumber <= this.columns.size()) {
                        if (this.columns.get(currentColumnNumber - 1) != null) {
                            this.log.warn("More than one column object assigned to column " + currentColumnNumber);
                        }
                        this.columns.set(currentColumnNumber - 1, c);
                    } else {
                        this.columns.add(currentColumnNumber - 1, c);
                    }
                    ++currentColumnNumber;
                    ++j;
                }
                nextColumnNumber = currentColumnNumber;
            }
            ++i;
        }
    }

    private int calcFixedColumnWidths(int maxAllocationWidth) {
        int nextColumnNumber = 1;
        int iEmptyCols = 0;
        double dTblUnits = 0.0;
        int iFixedWidth = 0;
        double dWidthFactor = 0.0;
        double dUnitLength = 0.0;
        double tuMin = 100000.0;
        int i = 0;
        while (i < this.columns.size()) {
            TableColumn c = (TableColumn)this.columns.get(i);
            if (c == null) {
                this.log.warn("No table-column specification for column " + nextColumnNumber);
                ++iEmptyCols;
            } else {
                Length colLength = c.getColumnWidthAsLength();
                double tu = colLength.getTableUnits();
                if (tu > 0.0 && tu < tuMin && colLength.mvalue() == 0) {
                    tuMin = tu;
                }
                dTblUnits += tu;
                iFixedWidth += colLength.mvalue();
            }
            ++nextColumnNumber;
            ++i;
        }
        this.setIPD(dTblUnits > 0.0, maxAllocationWidth);
        if (dTblUnits > 0.0) {
            int iProportionalWidth = 0;
            iProportionalWidth = this.optIPD > iFixedWidth ? this.optIPD - iFixedWidth : (this.maxIPD > iFixedWidth ? this.maxIPD - iFixedWidth : maxAllocationWidth - iFixedWidth);
            if (iProportionalWidth > 0) {
                dUnitLength = (double)iProportionalWidth / dTblUnits;
            } else {
                this.log.error("Sum of fixed column widths " + iFixedWidth + " greater than maximum available IPD " + maxAllocationWidth + "; no space for " + dTblUnits + " proportional units.");
                dUnitLength = 10000.0 / tuMin;
            }
        } else {
            int iTableWidth = iFixedWidth;
            if (this.minIPD > iFixedWidth) {
                iTableWidth = this.minIPD;
                dWidthFactor = (double)this.minIPD / (double)iFixedWidth;
            } else if (this.maxIPD < iFixedWidth) {
                this.log.warn("Sum of fixed column widths " + iFixedWidth + " greater than maximum specified IPD " + this.maxIPD);
            } else if (this.optIPD != -1 && iFixedWidth != this.optIPD) {
                this.log.warn("Sum of fixed column widths " + iFixedWidth + " differs from specified optimum IPD " + this.optIPD);
            }
        }
        int offset = 0;
        int i2 = 0;
        while (i2 < this.columns.size()) {
            TableColumn c = (TableColumn)this.columns.get(i2);
            if (c != null) {
                int colWidth;
                c.setColumnOffset(offset);
                Length l = c.getColumnWidthAsLength();
                if (dUnitLength > 0.0) {
                    l.resolveTableUnit(dUnitLength);
                }
                if ((colWidth = l.mvalue()) <= 0) {
                    this.log.warn("Zero-width table column!");
                }
                if (dWidthFactor > 0.0) {
                    colWidth = (int)((double)colWidth * dWidthFactor);
                }
                c.setColumnWidth(colWidth);
                offset += colWidth;
            }
            ++i2;
        }
        return offset;
    }

    private void layoutColumns(Area tableArea) throws FOPException {
        int i = 0;
        while (i < this.columns.size()) {
            TableColumn c = (TableColumn)this.columns.get(i);
            if (c != null) {
                c.layout(tableArea);
            }
            ++i;
        }
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    public int getContentWidth() {
        if (this.areaContainer != null) {
            return this.areaContainer.getContentWidth();
        }
        return 0;
    }

    private void setIPD(boolean bHasProportionalUnits, int maxAllocIPD) {
        boolean bMaxIsSpecified = !this.ipd.getMaximum().getLength().isAuto();
        this.maxIPD = bMaxIsSpecified ? this.ipd.getMaximum().getLength().mvalue() : maxAllocIPD;
        this.optIPD = this.ipd.getOptimum().getLength().isAuto() ? -1 : this.ipd.getMaximum().getLength().mvalue();
        this.minIPD = this.ipd.getMinimum().getLength().isAuto() ? -1 : this.ipd.getMinimum().getLength().mvalue();
        if (bHasProportionalUnits && this.optIPD < 0) {
            if (this.minIPD > 0) {
                this.optIPD = bMaxIsSpecified ? (this.minIPD + this.maxIPD) / 2 : this.minIPD;
            } else if (bMaxIsSpecified) {
                this.optIPD = this.maxIPD;
            } else {
                this.log.error("At least one of minimum, optimum, or maximum IPD must be specified on table.");
                this.optIPD = this.maxIPD;
            }
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new Table(parent, propertyList, systemId, line, column);
        }
    }
}

