/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFilterException;

public class FlateFilter
extends PDFFilter {
    public static final int PREDICTION_NONE = 1;
    public static final int PREDICTION_TIFF2 = 2;
    public static final int PREDICTION_PNG_NONE = 10;
    public static final int PREDICTION_PNG_SUB = 11;
    public static final int PREDICTION_PNG_UP = 12;
    public static final int PREDICTION_PNG_AVG = 13;
    public static final int PREDICTION_PNG_PAETH = 14;
    public static final int PREDICTION_PNG_OPT = 15;
    private int _predictor = 1;
    private int _colors;
    private int _bitsPerComponent;
    private int _columns;

    public String getName() {
        return "/FlateDecode";
    }

    public String getDecodeParms() {
        if (this._predictor > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("<< /Predictor ");
            sb.append(this._predictor);
            if (this._colors > 0) {
                sb.append(" /Colors " + this._colors);
            }
            if (this._bitsPerComponent > 0) {
                sb.append(" /BitsPerComponent " + this._bitsPerComponent);
            }
            if (this._columns > 0) {
                sb.append(" /Columns " + this._columns);
            }
            sb.append(" >> ");
            return sb.toString();
        }
        return null;
    }

    public byte[] encode(byte[] data) {
        ByteArrayOutputStream outArrayStream = new ByteArrayOutputStream();
        this._predictor = 1;
        try {
            DeflaterOutputStream compressedStream = new DeflaterOutputStream(outArrayStream);
            compressedStream.write(data, 0, data.length);
            compressedStream.flush();
            compressedStream.close();
        }
        catch (IOException e) {
            MessageHandler.error("Fatal error: " + e.getMessage());
            e.printStackTrace();
        }
        return outArrayStream.toByteArray();
    }

    public void setPredictor(int predictor) throws PDFFilterException {
        this._predictor = predictor;
    }

    public int getPredictor() {
        return this._predictor;
    }

    public void setColors(int colors) throws PDFFilterException {
        if (this._predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set Colors");
        }
        this._colors = colors;
    }

    public int getColors() {
        return this._colors;
    }

    public void setBitsPerComponent(int bits) throws PDFFilterException {
        if (this._predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set bitsPerComponent");
        }
        this._bitsPerComponent = bits;
    }

    public int getBitsPerComponent() {
        return this._bitsPerComponent;
    }

    public void setColumns(int columns) throws PDFFilterException {
        if (this._predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set Columns");
        }
        this._columns = columns;
    }

    public int getColumns() {
        return this._columns;
    }
}

